/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.PacketEvents;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketListener;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketListenerAbstract;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketListenerCommon;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.PacketListenerPriority;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.event.ProtocolPacketEvent;
import me.onlyjordon.swiftdisguise.libs.retrooper.packetevents.exception.InvalidHandshakeException;
import org.jetbrains.annotations.Nullable;

public class EventManager {
    private final Map<Byte, Set<PacketListenerCommon>> listenersMap = new ConcurrentHashMap<Byte, Set<PacketListenerCommon>>();

    public void callEvent(PacketEvent event) {
        this.callEvent(event, null);
    }

    public void callEvent(PacketEvent event, @Nullable Runnable postCallListenerAction) {
        for (byte priority = PacketListenerPriority.LOWEST.getId(); priority <= PacketListenerPriority.MONITOR.getId(); priority = (byte)(priority + 1)) {
            Set<PacketListenerCommon> listeners = this.listenersMap.get(priority);
            if (listeners == null) continue;
            for (PacketListenerCommon listener : listeners) {
                block5: {
                    try {
                        event.call(listener);
                    }
                    catch (Exception t2) {
                        if (t2.getClass() == InvalidHandshakeException.class) break block5;
                        PacketEvents.getAPI().getLogger().log(Level.WARNING, "PacketEvents caught an unhandled exception while calling your listener.", t2);
                    }
                }
                if (postCallListenerAction == null) continue;
                postCallListenerAction.run();
            }
        }
        if (event instanceof ProtocolPacketEvent && !((ProtocolPacketEvent)event).needsReEncode()) {
            ((ProtocolPacketEvent)event).setLastUsedWrapper(null);
        }
    }

    public PacketListenerCommon registerListener(PacketListener listener, PacketListenerPriority priority) {
        PacketListenerAbstract packetListenerAbstract = listener.asAbstract(priority);
        return this.registerListener(packetListenerAbstract);
    }

    public PacketListenerCommon registerListener(PacketListenerCommon listener) {
        byte priority = listener.getPriority().getId();
        Set<PacketListenerCommon> listenerSet = this.listenersMap.get(priority);
        if (listenerSet == null) {
            listenerSet = ConcurrentHashMap.newKeySet();
        }
        listenerSet.add(listener);
        this.listenersMap.put(priority, listenerSet);
        return listener;
    }

    public PacketListenerCommon[] registerListeners(PacketListenerCommon ... listeners) {
        for (PacketListenerCommon listener : listeners) {
            this.registerListener(listener);
        }
        return listeners;
    }

    public void unregisterListener(PacketListenerCommon listener) {
        Set<PacketListenerCommon> listenerSet = this.listenersMap.get(listener.getPriority().getId());
        if (listenerSet == null) {
            return;
        }
        listenerSet.remove(listener);
    }

    public void unregisterListeners(PacketListenerCommon ... listeners) {
        for (PacketListenerCommon listener : listeners) {
            this.unregisterListener(listener);
        }
    }

    public void unregisterAllListeners() {
        this.listenersMap.clear();
    }
}

