/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.nms;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.onlyjordon.swiftdisguise.nms.CrossVersionPlayerHelper;
import me.onlyjordon.swiftdisguise.nms.NMSUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RespawnNMS {
    public static final Class<?> playerListClass;
    public static final Class<?> dimensionTypeClass;
    private static final Class<Enum> respawnReason;
    private static final Enum<?> pluginRespawnReason;
    public static final Method respawnMethod1_16;
    public static final Method respawnMethod1_15;
    public static final Class<?> dimensionClass;
    private static final Method getDimensionMethod;
    private static final Method getDimensionTypeMethod;
    private static final boolean isSupported;
    private static final Method legacyRespawnMethod;

    public static void nmsRespawn(Player player) throws Exception {
        if (respawnMethod1_16 != null) {
            if (respawnReason == null) {
                respawnMethod1_16.invoke(CrossVersionPlayerHelper.getHandle(Bukkit.getServer()), CrossVersionPlayerHelper.getHandle(player), false);
            } else {
                respawnMethod1_16.invoke(CrossVersionPlayerHelper.getHandle(Bukkit.getServer()), CrossVersionPlayerHelper.getHandle(player), false, pluginRespawnReason);
            }
        } else if (respawnMethod1_15 != null) {
            respawnMethod1_15.invoke(CrossVersionPlayerHelper.getHandle(Bukkit.getServer()), CrossVersionPlayerHelper.getHandle(player), RespawnNMS.getDimensionType(player.getWorld()), false);
        } else if (legacyRespawnMethod != null) {
            legacyRespawnMethod.invoke(CrossVersionPlayerHelper.getHandle(Bukkit.getServer()), CrossVersionPlayerHelper.getHandle(player), player.getWorld().getEnvironment().getId(), false);
        } else {
            throw new RuntimeException("Unsupported server version");
        }
    }

    private static Object getDimensionType(World world) {
        try {
            return getDimensionTypeMethod.invoke(RespawnNMS.getDimension(world), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getDimension(World world) {
        try {
            Object level = CrossVersionPlayerHelper.getHandle(world);
            return getDimensionMethod.invoke(level, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isSupported() {
        return isSupported;
    }

    static {
        try {
            Class<?> tempRespawnReason;
            Method tempGetDimensionMethod;
            Class<?> plc;
            try {
                plc = Class.forName("net.minecraft.server.players.PlayerList");
            }
            catch (ClassNotFoundException e) {
                plc = Class.forName("net.minecraft.server." + NMSUtils.getMinecraftPackage() + ".PlayerList");
            }
            playerListClass = plc;
            Method tempRespawnMethod1_16 = null;
            Method tempRespawnMethod1_15 = null;
            Method tempLegacyRespawnMethod = null;
            try {
                tempGetDimensionMethod = CrossVersionPlayerHelper.getWorldHandleMethod().getReturnType().getDeclaredMethod("o", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                tempGetDimensionMethod = null;
            }
            getDimensionMethod = tempGetDimensionMethod;
            dimensionClass = getDimensionMethod == null ? null : getDimensionMethod.getReturnType();
            getDimensionTypeMethod = dimensionClass == null ? null : dimensionClass.getDeclaredMethod("n", new Class[0]);
            dimensionTypeClass = getDimensionTypeMethod == null ? null : getDimensionTypeMethod.getReturnType();
            try {
                tempRespawnReason = Class.forName("org.bukkit.event.player.PlayerRespawnEvent$RespawnReason");
            }
            catch (Exception e) {
                tempRespawnReason = null;
            }
            respawnReason = tempRespawnReason;
            pluginRespawnReason = respawnReason != null ? Enum.valueOf(respawnReason, "PLUGIN") : null;
            try {
                tempRespawnMethod1_16 = playerListClass.getDeclaredMethod("respawn", CrossVersionPlayerHelper.getServerPlayerClass(), Boolean.TYPE);
            }
            catch (Exception ex) {
                try {
                    tempRespawnMethod1_16 = playerListClass.getDeclaredMethod("respawn", CrossVersionPlayerHelper.getServerPlayerClass(), Boolean.TYPE, respawnReason);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                tempRespawnMethod1_15 = playerListClass.getDeclaredMethod("moveToWorld", CrossVersionPlayerHelper.getServerPlayerClass(), dimensionTypeClass, Boolean.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                tempLegacyRespawnMethod = playerListClass.getDeclaredMethod("moveToWorld", CrossVersionPlayerHelper.getServerPlayerClass(), Integer.TYPE, Boolean.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            respawnMethod1_16 = tempRespawnMethod1_16;
            respawnMethod1_15 = tempRespawnMethod1_15;
            legacyRespawnMethod = tempLegacyRespawnMethod;
            isSupported = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

