/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerHeldItemChange;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPosition;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTeams;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerTimeUpdate;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerUpdateViewDistance;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.onlyjordon.swiftdisguise.ViaBackwardsFixer;
import me.onlyjordon.swiftdisguise.api.DisguiseData;
import me.onlyjordon.swiftdisguise.api.IDisguiseData;
import me.onlyjordon.swiftdisguise.api.ISwiftDisguiseAPI;
import me.onlyjordon.swiftdisguise.api.ITabPrefixSuffix;
import me.onlyjordon.swiftdisguise.api.SwiftDisguise;
import me.onlyjordon.swiftdisguise.api.SwiftDisguiseConfig;
import me.onlyjordon.swiftdisguise.api.TabPrefixSuffix;
import me.onlyjordon.swiftdisguise.extensions.PacketExtensions;
import me.onlyjordon.swiftdisguise.nms.CrossVersionPlayerHelper;
import me.onlyjordon.swiftdisguise.nms.RespawnNMS;
import me.onlyjordon.swiftdisguise.utils.Skin;
import me.onlyjordon.swiftdisguise.utils.Util;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u00014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0013\"\u00020\f\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J(\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0002J'\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00182\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0013\"\u00020\u0018\u00a2\u0006\u0002\u0010$J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010'\u001a\u00020\u00162\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020\fH\u0002J\u0016\u0010,\u001a\u00020\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.H\u0002J\u001e\u0010,\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.H\u0002J\u0016\u00101\u001a\u00020\u00162\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.H\u0002J\u001e\u00101\u001a\u00020\u00162\u0006\u0010/\u001a\u0002002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160.H\u0002J\u000e\u00102\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u00103\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u00065"}, d2={"Lme/onlyjordon/swiftdisguise/PlayerRefresher;", "Lme/onlyjordon/swiftdisguise/extensions/PacketExtensions;", "api", "Lme/onlyjordon/swiftdisguise/api/ISwiftDisguiseAPI;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "(Lme/onlyjordon/swiftdisguise/api/ISwiftDisguiseAPI;Lorg/bukkit/plugin/java/JavaPlugin;)V", "oldTabPrefixSuffix", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lme/onlyjordon/swiftdisguise/api/ITabPrefixSuffix;", "respawnMethod", "Lme/onlyjordon/swiftdisguise/PlayerRefresher$RespawnMethod;", "getRespawnMethod", "()Lme/onlyjordon/swiftdisguise/PlayerRefresher$RespawnMethod;", "setRespawnMethod", "(Lme/onlyjordon/swiftdisguise/PlayerRefresher$RespawnMethod;)V", "generateRespawnMethod", "exclusions", "", "([Lme/onlyjordon/swiftdisguise/PlayerRefresher$RespawnMethod;)Lme/onlyjordon/swiftdisguise/PlayerRefresher$RespawnMethod;", "refreshForOthers", "", "player", "Lorg/bukkit/entity/Player;", "refreshNameSkinForOthers", "players", "", "refreshPlayer", "refreshPlayerSync", "refreshPlayerTab", "playerVersion", "Lcom/github/retrooper/packetevents/protocol/player/ClientVersion;", "refreshPrefixSuffix", "sender", "receiver", "(Lorg/bukkit/entity/Player;[Lorg/bukkit/entity/Player;)V", "refreshSelf", "refreshSkinLayers", "removeUUID", "disguiseData", "Lme/onlyjordon/swiftdisguise/api/DisguiseData;", "respawn", "method", "runAsyncThread", "task", "Lkotlin/Function0;", "delay", "", "runPrimaryThread", "unregisterPlayer", "updateGameProfile", "RespawnMethod", "spigot"})
@SourceDebugExtension(value={"SMAP\nPlayerRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerRefresher.kt\nme/onlyjordon/swiftdisguise/PlayerRefresher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,291:1\n1855#2,2:292\n1855#2,2:294\n1855#2,2:298\n1855#2,2:300\n1855#2,2:302\n13309#3,2:296\n*S KotlinDebug\n*F\n+ 1 PlayerRefresher.kt\nme/onlyjordon/swiftdisguise/PlayerRefresher\n*L\n70#1:292,2\n77#1:294,2\n249#1:298,2\n273#1:300,2\n288#1:302,2\n105#1:296,2\n*E\n"})
public final class PlayerRefresher
extends PacketExtensions {
    @NotNull
    private final ISwiftDisguiseAPI api;
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final HashMap<UUID, ITabPrefixSuffix> oldTabPrefixSuffix;
    @NotNull
    private RespawnMethod respawnMethod;

    public PlayerRefresher(@NotNull ISwiftDisguiseAPI api, @NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(api, "api");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.api = api;
        this.plugin = plugin;
        this.oldTabPrefixSuffix = new HashMap();
        this.respawnMethod = this.generateRespawnMethod(new RespawnMethod[0]);
        Bukkit.getLogger().info("Using respawn method " + this.respawnMethod.name());
    }

    @NotNull
    public final RespawnMethod getRespawnMethod() {
        return this.respawnMethod;
    }

    public final void setRespawnMethod(@NotNull RespawnMethod respawnMethod) {
        Intrinsics.checkNotNullParameter((Object)respawnMethod, "<set-?>");
        this.respawnMethod = respawnMethod;
    }

    public final void refreshSelf(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.updateGameProfile(player);
        ClientVersion clientVersion = this.getPeUser(player).getClientVersion();
        Intrinsics.checkNotNullExpressionValue(clientVersion, "getClientVersion(...)");
        this.refreshPlayerTab(player, clientVersion, (Collection<? extends Player>)CollectionsKt.listOf(player));
        PlayerRefresher.respawn$default(this, player, null, 2, null);
    }

    private final void updateGameProfile(Player player) {
        if (SwiftDisguise.getConfig().nameMode() == SwiftDisguiseConfig.NameMode.WEAK) {
            return;
        }
        UserProfile profile = this.getPeProfile(player);
        Skin skin = this.api.getDisguiseSkin(player);
        profile.getTextureProperties().clear();
        profile.getTextureProperties().add(new TextureProperty("textures", skin.getValue(), skin.getSignature()));
        profile.setUUID(player.getUniqueId());
        profile.setName(this.api.getDisguiseName(player));
        CrossVersionPlayerHelper.setGameProfile(player, profile);
        CrossVersionPlayerHelper.updateAllNamesOnServer();
    }

    public final void refreshForOthers(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ArrayList<Object> players = new ArrayList<Object>(player.getWorld().getPlayers());
        players.removeIf(arg_0 -> PlayerRefresher.refreshForOthers$lambda$0(new Function1<Player, Boolean>(player){
            final /* synthetic */ Player $player;
            {
                this.$player = $player;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Player it) {
                return it.getUniqueId().equals(this.$player.getUniqueId());
            }
        }, arg_0));
        ClientVersion clientVersion = this.getPeUser(player).getClientVersion();
        Intrinsics.checkNotNullExpressionValue(clientVersion, "getClientVersion(...)");
        this.refreshPlayerTab(player, clientVersion, (Collection<? extends Player>)players);
        PlayerRefresher.refreshNameSkinForOthers$default(this, player, null, 2, null);
    }

    private final void refreshNameSkinForOthers(Player player, Collection<? extends Player> players) {
        if (!Bukkit.isPrimaryThread()) {
            this.runPrimaryThread(new Function0<Unit>(this, player, players){
                final /* synthetic */ PlayerRefresher this$0;
                final /* synthetic */ Player $player;
                final /* synthetic */ Collection<Player> $players;
                {
                    this.this$0 = $receiver;
                    this.$player = $player;
                    this.$players = $players;
                    super(0);
                }

                public final void invoke() {
                    PlayerRefresher.access$refreshNameSkinForOthers(this.this$0, this.$player, this.$players);
                }
            });
            return;
        }
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            it.hidePlayer(player);
            it.showPlayer(player);
        }
    }

    static /* synthetic */ void refreshNameSkinForOthers$default(PlayerRefresher playerRefresher, Player player, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            List list = player.getWorld().getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            collection = list;
        }
        playerRefresher.refreshNameSkinForOthers(player, collection);
    }

    private final void refreshPlayerTab(Player player, ClientVersion playerVersion, Collection<? extends Player> players) {
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            this.sendPacket(it, this.getPlayerInfoRemovePacketFromServerVersion(player));
            this.ifOlderThan(playerVersion, ClientVersion.V_1_16_4, new Function0<Unit>(player, it, this){
                final /* synthetic */ Player $player;
                final /* synthetic */ Player $it;
                final /* synthetic */ PlayerRefresher this$0;
                {
                    this.$player = $player;
                    this.$it = $it;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (Intrinsics.areEqual(this.$player, this.$it)) {
                        PlayerRefresher.access$sendPacket(this.this$0, this.$player, PlayerRefresher.access$getDeleteEntityPacket(this.this$0, (Entity)this.$player));
                        PlayerRefresher.access$sendPacket(this.this$0, this.$player, PlayerRefresher.access$getLegacySpawnPlayerPacket(this.this$0, this.$player));
                        PlayerRefresher.access$runPrimaryThread(this.this$0, new Function0<Unit>(this.$player){
                            final /* synthetic */ Player $player;
                            {
                                this.$player = $player;
                                super(0);
                            }

                            public final void invoke() {
                                this.$player.teleport((Entity)this.$player);
                            }
                        });
                    }
                }
            });
            this.sendPacket(it, this.getPlayerInfoAddPacketFromServerVersion(player));
        }
    }

    static /* synthetic */ void refreshPlayerTab$default(PlayerRefresher playerRefresher, Player player, ClientVersion clientVersion, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            List list = player.getWorld().getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            collection = list;
        }
        playerRefresher.refreshPlayerTab(player, clientVersion, collection);
    }

    public final void refreshPrefixSuffix(@NotNull Player sender, Player ... receiver) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        TabPrefixSuffix prefixSuffix = this.api.getDisguisePrefixSuffix(sender);
        Field colorField = NamedTextColor.class.getDeclaredField(prefixSuffix.getColor().toString());
        Object object = colorField.get(null);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type net.kyori.adventure.text.format.NamedTextColor");
        NamedTextColor color = (NamedTextColor)object;
        WrapperPlayServerTeams.ScoreBoardTeamInfo teamInfo = new WrapperPlayServerTeams.ScoreBoardTeamInfo((Component)Component.empty(), (Component)prefixSuffix.getPrefix(), (Component)prefixSuffix.getSuffix(), WrapperPlayServerTeams.NameTagVisibility.ALWAYS, WrapperPlayServerTeams.CollisionRule.NEVER, color, WrapperPlayServerTeams.OptionData.FRIENDLY_FIRE);
        Player[] $this$forEach$iv = receiver;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            char c;
            Player element$iv;
            Player it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (this.oldTabPrefixSuffix.containsKey(sender.getUniqueId())) {
                ITabPrefixSuffix oldPrefixSuffix;
                Intrinsics.checkNotNull(this.oldTabPrefixSuffix.get(sender.getUniqueId()));
                WrapperPlayServerTeams.ScoreBoardTeamInfo oldTeamInfo = new WrapperPlayServerTeams.ScoreBoardTeamInfo((Component)Component.empty(), (Component)oldPrefixSuffix.getPrefix(), (Component)oldPrefixSuffix.getSuffix(), WrapperPlayServerTeams.NameTagVisibility.ALWAYS, WrapperPlayServerTeams.CollisionRule.NEVER, color, WrapperPlayServerTeams.OptionData.FRIENDLY_FIRE);
                c = (char)oldPrefixSuffix.getPriority();
                String string = sender.getUniqueId().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                String string2 = string;
                int n2 = 0;
                int n3 = 16;
                String string3 = string2.substring(n2, n3);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                string2 = string3;
                String[] stringArray = new String[]{this.api.getDisguiseName(sender)};
                WrapperPlayServerTeams deleteOldTeam = new WrapperPlayServerTeams(c + string2, WrapperPlayServerTeams.TeamMode.REMOVE, oldTeamInfo, stringArray);
                this.sendPacket(it, (PacketWrapper)deleteOldTeam);
            }
            char c2 = (char)prefixSuffix.getPriority();
            String string = sender.getUniqueId().toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string4 = string;
            c = '\u0000';
            int n4 = 16;
            String string5 = string4.substring(c, n4);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            string4 = string5;
            String[] stringArray = new String[]{this.api.getDisguiseName(sender)};
            WrapperPlayServerTeams newTeam = new WrapperPlayServerTeams(c2 + string4, WrapperPlayServerTeams.TeamMode.CREATE, teamInfo, stringArray);
            this.sendPacket(it, (PacketWrapper)newTeam);
        }
        Map map = this.oldTabPrefixSuffix;
        UUID uUID = sender.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uUID2 = uUID;
        Intrinsics.checkNotNull(prefixSuffix);
        TabPrefixSuffix tabPrefixSuffix = prefixSuffix;
        map.put(uUID2, tabPrefixSuffix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final RespawnMethod generateRespawnMethod(RespawnMethod ... exclusions) {
        RespawnMethod respawnMethod;
        Intrinsics.checkNotNullParameter(exclusions, "exclusions");
        if (!ArraysKt.contains(exclusions, RespawnMethod.PAPER) && Util.isPaper()) {
            respawnMethod = RespawnMethod.PAPER;
            return respawnMethod;
        }
        if (!ArraysKt.contains(exclusions, RespawnMethod.REFLECTION)) {
            boolean bl;
            try {
                bl = RespawnNMS.isSupported();
            }
            catch (Exception e) {
                e.printStackTrace();
                bl = false;
            }
            if (bl) {
                respawnMethod = RespawnMethod.REFLECTION;
                return respawnMethod;
            }
        }
        respawnMethod = RespawnMethod.PACKET_EVENTS;
        return respawnMethod;
    }

    private final void respawn(Player player, RespawnMethod method) {
        Bukkit.getLogger().info("Refreshing player " + player.getName() + " using respawn method " + this.respawnMethod.name());
        if (!Bukkit.isPrimaryThread()) {
            this.runPrimaryThread(new Function0<Unit>(this, player){
                final /* synthetic */ PlayerRefresher this$0;
                final /* synthetic */ Player $player;
                {
                    this.this$0 = $receiver;
                    this.$player = $player;
                    super(0);
                }

                public final void invoke() {
                    PlayerRefresher.respawn$default(this.this$0, this.$player, null, 2, null);
                }
            });
            return;
        }
        Location location = player.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location loc = location;
        boolean playerIsLegacy = this.getPeUser(player).getClientVersion().isOlderThan(ClientVersion.V_1_16);
        boolean serverIsLegacy = PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_16);
        RespawnMethod method2 = method;
        if (serverIsLegacy) {
            method2 = this.respawnMethod = RespawnMethod.PACKET_EVENTS;
        }
        if (method2 == RespawnMethod.PAPER && !playerIsLegacy) {
            try {
                Method refresh = CrossVersionPlayerHelper.getCraftPlayerClass().getDeclaredMethod("refreshPlayer", new Class[0]);
                refresh.setAccessible(true);
                refresh.invoke((Object)player, new Object[0]);
                return;
            }
            catch (ClassNotFoundException refresh) {
            }
            catch (NoSuchMethodException refresh) {
            }
            catch (IllegalAccessException refresh) {
            }
            catch (InvocationTargetException ignored) {
                throw new RuntimeException("Failed to refresh player with Paper!", ignored);
            }
        }
        if (method2 == RespawnMethod.PAPER && playerIsLegacy) {
            RespawnMethod[] respawnMethodArray = new RespawnMethod[]{RespawnMethod.PAPER};
            RespawnMethod rs = this.generateRespawnMethod(respawnMethodArray);
            this.respawn(player, rs);
        }
        if (method2 == RespawnMethod.REFLECTION) {
            try {
                RespawnNMS.nmsRespawn(player);
            }
            catch (Exception ex) {
                this.respawnMethod = RespawnMethod.PACKET_EVENTS;
                PlayerRefresher.respawn$default(this, player, null, 2, null);
                throw new RuntimeException("Failed to refresh player with Reflection!", ex);
            }
        }
        if (method2 == RespawnMethod.PACKET_EVENTS) {
            if (!ViaBackwardsFixer.INSTANCE.sendRespawnPacketWithVia(player, 0L, (short)this.getPeGameMode(player).getId(), false)) {
                this.sendPacket(player, this.getRespawnPacket(player));
            }
            Location location2 = player.getLocation().clone();
            Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
            Location l = location2;
            this.sendPacket(player, this.getTeleportPacket(player));
            player.teleport((Entity)player);
            player.teleport(l);
            player.setExp(player.getExp());
            player.setHealth(player.getHealth());
            player.setHealthScale(player.getHealthScale());
            player.setFoodLevel(player.getFoodLevel());
            player.setSaturation(player.getSaturation());
            player.setAllowFlight(player.getAllowFlight());
            if (player.getCompassTarget() != null) {
                player.setCompassTarget(player.getCompassTarget());
            }
            player.setExhaustion(player.getExhaustion());
            player.setLevel(player.getLevel());
            Location loc2 = player.getWorld().getSpawnLocation();
            this.sendPacket(player, (PacketWrapper)new WrapperPlayServerTimeUpdate(player.getWorld().getFullTime(), player.getWorld().getTime()));
            this.sendPacket(player, (PacketWrapper)new WrapperPlayServerSpawnPosition(new Vector3i(loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ()), 0.0f));
            this.sendPacket(player, this.getRefreshChunksPacket());
            this.sendPacket(player, (PacketWrapper)new WrapperPlayServerUpdateViewDistance(Bukkit.getServer().getViewDistance()));
            player.updateInventory();
            this.sendPacket(player, (PacketWrapper)new WrapperPlayServerHeldItemChange(player.getInventory().getHeldItemSlot()));
        }
        player.teleport(loc);
    }

    static /* synthetic */ void respawn$default(PlayerRefresher playerRefresher, Player player, RespawnMethod respawnMethod, int n, Object object) {
        if ((n & 2) != 0) {
            respawnMethod = playerRefresher.respawnMethod;
        }
        playerRefresher.respawn(player, respawnMethod);
    }

    public final void refreshPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.refreshSelf(player);
        this.refreshForOthers(player);
    }

    private final void runPrimaryThread(Function0<Unit> task) {
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> PlayerRefresher.runPrimaryThread$lambda$4(task));
    }

    private final void runPrimaryThread(long delay, Function0<Unit> task) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> PlayerRefresher.runPrimaryThread$lambda$5(task), delay);
    }

    private final void runAsyncThread(Function0<Unit> task) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> PlayerRefresher.runAsyncThread$lambda$6(task));
    }

    private final void runAsyncThread(long delay, Function0<Unit> task) {
        this.plugin.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, () -> PlayerRefresher.runAsyncThread$lambda$7(task), delay);
    }

    public final void refreshSkinLayers(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        List list = player.getLocation().getWorld().getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.sendPacket(it, (PacketWrapper)this.getMetadataPacket(player));
        }
    }

    public final void unregisterPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.oldTabPrefixSuffix.remove(player.getUniqueId());
    }

    public final void refreshPlayerSync(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.updateGameProfile(player);
        ClientVersion clientVersion = this.getPeUser(player).getClientVersion();
        Intrinsics.checkNotNullExpressionValue(clientVersion, "getClientVersion(...)");
        this.refreshPlayerTab(player, clientVersion, (Collection<? extends Player>)CollectionsKt.listOf(player));
        PlayerRefresher.respawn$default(this, player, null, 2, null);
        this.refreshForOthers(player);
    }

    public final void removeUUID(@Nullable DisguiseData disguiseData, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        boolean isNull = disguiseData == null;
        DisguiseData disguiseData2 = disguiseData;
        IDisguiseData disguiseData3 = disguiseData2 != null ? (IDisguiseData)disguiseData2 : this.api.getDisguiseData(player);
        UUID[] uUIDArray = new UUID[]{disguiseData3.getFakeUUID(), UUID.fromString("00000000-0000-0000-0000-000000000000")};
        WrapperPlayServerPlayerInfoRemove modernRemove = new WrapperPlayServerPlayerInfoRemove(uUIDArray);
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        if (serverVersion.isNewerThan(ServerVersion.V_1_19_2)) {
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.sendPacket(it, (PacketWrapper)modernRemove);
            }
        }
        WrapperPlayServerPlayerInfo.PlayerData[] $i$f$forEach = new WrapperPlayServerPlayerInfo.PlayerData[]{new WrapperPlayServerPlayerInfo.PlayerData(null, new UserProfile(isNull ? disguiseData3.getRealUUID() : disguiseData3.getFakeUUID(), isNull ? disguiseData3.getRealName() : disguiseData3.getFakeName()), GameMode.defaultGameMode(), 0), new WrapperPlayServerPlayerInfo.PlayerData(null, new UserProfile(UUID.fromString("00000000-0000-0000-0000-000000000000"), "name"), GameMode.defaultGameMode(), 0)};
        WrapperPlayServerPlayerInfo oldRemove = new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER, $i$f$forEach);
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            this.sendPacket(it, (PacketWrapper)oldRemove);
        }
    }

    private static final boolean refreshForOthers$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void runPrimaryThread$lambda$4(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke();
    }

    private static final void runPrimaryThread$lambda$5(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke();
    }

    private static final void runAsyncThread$lambda$6(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke();
    }

    private static final void runAsyncThread$lambda$7(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ void access$refreshNameSkinForOthers(PlayerRefresher $this, Player player, Collection players) {
        $this.refreshNameSkinForOthers(player, players);
    }

    public static final /* synthetic */ void access$sendPacket(PlayerRefresher $this, Player $receiver, PacketWrapper packet) {
        $this.sendPacket($receiver, packet);
    }

    public static final /* synthetic */ PacketWrapper access$getDeleteEntityPacket(PlayerRefresher $this, Entity $receiver) {
        return $this.getDeleteEntityPacket($receiver);
    }

    public static final /* synthetic */ PacketWrapper access$getLegacySpawnPlayerPacket(PlayerRefresher $this, Player $receiver) {
        return $this.getLegacySpawnPlayerPacket($receiver);
    }

    public static final /* synthetic */ void access$runPrimaryThread(PlayerRefresher $this, Function0 task) {
        $this.runPrimaryThread(task);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lme/onlyjordon/swiftdisguise/PlayerRefresher$RespawnMethod;", "", "(Ljava/lang/String;I)V", "REFLECTION", "PAPER", "PACKET_EVENTS", "spigot"})
    public static final class RespawnMethod
    extends Enum<RespawnMethod> {
        public static final /* enum */ RespawnMethod REFLECTION = new RespawnMethod();
        public static final /* enum */ RespawnMethod PAPER = new RespawnMethod();
        public static final /* enum */ RespawnMethod PACKET_EVENTS = new RespawnMethod();
        private static final /* synthetic */ RespawnMethod[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RespawnMethod[] values() {
            return (RespawnMethod[])$VALUES.clone();
        }

        public static RespawnMethod valueOf(String value) {
            return Enum.valueOf(RespawnMethod.class, value);
        }

        @NotNull
        public static EnumEntries<RespawnMethod> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = respawnMethodArray = new RespawnMethod[]{RespawnMethod.REFLECTION, RespawnMethod.PAPER, RespawnMethod.PACKET_EVENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

