/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.yamlconfiguration.file;

import java.util.LinkedHashMap;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.DumperOptions;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.nodes.Node;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.representer.Representer;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.representer.SafeRepresenter;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.serialization.ConfigurationSerializable;
import org.bspfsystems.yamlconfiguration.serialization.ConfigurationSerialization;
import org.jetbrains.annotations.NotNull;

public final class YamlRepresenter
extends Representer {
    YamlRepresenter(@NotNull DumperOptions dumperOptions) {
        super(dumperOptions);
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        this.multiRepresenters.remove(Enum.class);
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super(YamlRepresenter.this);
        }

        @Override
        @NotNull
        public Node representData(@NotNull Object object) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)object;
            LinkedHashMap<String, Object> values2 = new LinkedHashMap<String, Object>();
            values2.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values2.putAll(serializable.serialize());
            return super.representData(values2);
        }
    }

    private final class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super(YamlRepresenter.this);
        }

        @Override
        @NotNull
        public Node representData(@NotNull Object object) {
            return super.representData(((ConfigurationSection)object).getValues(false));
        }
    }
}

