/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.extensions;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.player.ClientVersion;
import com.github.retrooper.packetevents.protocol.player.GameMode;
import com.github.retrooper.packetevents.protocol.player.User;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.protocol.world.Difficulty;
import com.github.retrooper.packetevents.protocol.world.Dimension;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChangeGameState;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerRespawn;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.onlyjordon.swiftdisguise.nms.CrossVersionPlayerHelper;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010J\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u001bH\u0002J\u0010\u0010L\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\fH\u0002J\u0018\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u001fH\u0002J\"\u0010S\u001a\u00020O*\u00020T2\u0006\u0010U\u001a\u00020T2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020O0WH\u0004J\"\u0010X\u001a\u00020O*\u00020T2\u0006\u0010U\u001a\u00020T2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020O0WH\u0004J\u001a\u0010Y\u001a\u00020O*\u00020\f2\f\u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004H\u0004J\f\u0010[\u001a\u00020O*\u00020\fH\u0004J\f\u0010\\\u001a\u00020+*\u00020]H\u0004R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u001c\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u001c\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\u00020\u001f*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\u001e\u001a\u00020\u001f*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\"R(\u0010%\u001a\u00020$*\u00020\f2\u0006\u0010#\u001a\u00020$8D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0018\u0010*\u001a\u00020+*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R(\u0010/\u001a\u00020.*\u00020\f2\u0006\u0010#\u001a\u00020.8D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u0018\u00104\u001a\u000205*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0018\u00108\u001a\u000209*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u001c\u0010<\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u000eR\u001c\u0010>\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u000eR\u001c\u0010@\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010\u000eR\u001c\u0010B\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u000eR\u001e\u0010D\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010\u000eR\u001c\u0010F\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u000eR\u001c\u0010H\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u000e\u00a8\u0006^"}, d2={"Lme/onlyjordon/swiftdisguise/extensions/PacketExtensions;", "", "()V", "refreshChunksPacket", "Lcom/github/retrooper/packetevents/wrapper/PacketWrapper;", "getRefreshChunksPacket", "()Lcom/github/retrooper/packetevents/wrapper/PacketWrapper;", "deleteEntityPacket", "Lorg/bukkit/entity/Entity;", "getDeleteEntityPacket", "(Lorg/bukkit/entity/Entity;)Lcom/github/retrooper/packetevents/wrapper/PacketWrapper;", "legacySpawnPlayerPacket", "Lorg/bukkit/entity/Player;", "getLegacySpawnPlayerPacket", "(Lorg/bukkit/entity/Player;)Lcom/github/retrooper/packetevents/wrapper/PacketWrapper;", "metadataPacket", "Lcom/github/retrooper/packetevents/wrapper/play/server/WrapperPlayServerEntityMetadata;", "getMetadataPacket", "(Lorg/bukkit/entity/Player;)Lcom/github/retrooper/packetevents/wrapper/play/server/WrapperPlayServerEntityMetadata;", "modernPlayerInfoAddPacket", "getModernPlayerInfoAddPacket", "modernPlayerInfoListPacket", "getModernPlayerInfoListPacket", "modernPlayerInfoRemovePacket", "getModernPlayerInfoRemovePacket", "peDifficulty", "Lcom/github/retrooper/packetevents/protocol/world/Difficulty;", "Lorg/bukkit/World;", "getPeDifficulty", "(Lorg/bukkit/World;)Lcom/github/retrooper/packetevents/protocol/world/Difficulty;", "peDimension", "Lcom/github/retrooper/packetevents/protocol/world/Dimension;", "getPeDimension", "(Lorg/bukkit/World;)Lcom/github/retrooper/packetevents/protocol/world/Dimension;", "(Lorg/bukkit/entity/Player;)Lcom/github/retrooper/packetevents/protocol/world/Dimension;", "value", "Lcom/github/retrooper/packetevents/protocol/player/GameMode;", "peGameMode", "getPeGameMode", "(Lorg/bukkit/entity/Player;)Lcom/github/retrooper/packetevents/protocol/player/GameMode;", "setPeGameMode", "(Lorg/bukkit/entity/Player;Lcom/github/retrooper/packetevents/protocol/player/GameMode;)V", "peLocation", "Lcom/github/retrooper/packetevents/protocol/world/Location;", "getPeLocation", "(Lorg/bukkit/entity/Player;)Lcom/github/retrooper/packetevents/protocol/world/Location;", "Lcom/github/retrooper/packetevents/protocol/player/UserProfile;", "peProfile", "getPeProfile", "(Lorg/bukkit/entity/Player;)Lcom/github/retrooper/packetevents/protocol/player/UserProfile;", "setPeProfile", "(Lorg/bukkit/entity/Player;Lcom/github/retrooper/packetevents/protocol/player/UserProfile;)V", "peUser", "Lcom/github/retrooper/packetevents/protocol/player/User;", "getPeUser", "(Lorg/bukkit/entity/Player;)Lcom/github/retrooper/packetevents/protocol/player/User;", "pingInMs", "", "getPingInMs", "(Lorg/bukkit/entity/Player;)I", "playerInfoAddPacket", "getPlayerInfoAddPacket", "playerInfoAddPacketFromServerVersion", "getPlayerInfoAddPacketFromServerVersion", "playerInfoRemovePacket", "getPlayerInfoRemovePacket", "playerInfoRemovePacketFromServerVersion", "getPlayerInfoRemovePacketFromServerVersion", "playerInfoUpdateListedPacketFromServerVersion", "getPlayerInfoUpdateListedPacketFromServerVersion", "respawnPacket", "getRespawnPacket", "teleportPacket", "getTeleportPacket", "getAnyOtherWorld", "world", "getDimension", "player", "setDimension", "", "env", "Lorg/bukkit/World$Environment;", "dim", "ifNewerThan", "Lcom/github/retrooper/packetevents/protocol/player/ClientVersion;", "version", "block", "Lkotlin/Function0;", "ifOlderThan", "sendPacket", "packet", "teleportToOtherDimensionAndBack", "toPacketEvents", "Lorg/bukkit/Location;", "spigot"})
@SourceDebugExtension(value={"SMAP\nPacketExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PacketExtensions.kt\nme/onlyjordon/swiftdisguise/extensions/PacketExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n288#2,2:202\n*S KotlinDebug\n*F\n+ 1 PacketExtensions.kt\nme/onlyjordon/swiftdisguise/extensions/PacketExtensions\n*L\n172#1:202,2\n*E\n"})
public class PacketExtensions {
    protected final void sendPacket(@NotNull Player $this$sendPacket, @Nullable PacketWrapper<?> packet) {
        Intrinsics.checkNotNullParameter($this$sendPacket, "<this>");
        if (packet == null) {
            return;
        }
        PacketEvents.getAPI().getPlayerManager().sendPacket((Object)$this$sendPacket, packet);
    }

    @NotNull
    protected final User getPeUser(@NotNull Player $this$peUser) {
        Intrinsics.checkNotNullParameter($this$peUser, "<this>");
        User user = PacketEvents.getAPI().getPlayerManager().getUser((Object)$this$peUser);
        Intrinsics.checkNotNullExpressionValue(user, "getUser(...)");
        return user;
    }

    @NotNull
    protected final UserProfile getPeProfile(@NotNull Player $this$peProfile) {
        Intrinsics.checkNotNullParameter($this$peProfile, "<this>");
        UserProfile userProfile = this.getPeUser($this$peProfile).getProfile();
        Intrinsics.checkNotNullExpressionValue(userProfile, "getProfile(...)");
        return userProfile;
    }

    protected final void setPeProfile(@NotNull Player $this$peProfile, @NotNull UserProfile value) {
        Intrinsics.checkNotNullParameter($this$peProfile, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        this.getPeUser($this$peProfile).getProfile().setName(value.getName());
        this.getPeUser($this$peProfile).getProfile().setUUID(value.getUUID());
        this.getPeUser($this$peProfile).getProfile().getTextureProperties().clear();
        List list = this.getPeUser($this$peProfile).getProfile().getTextureProperties();
        List list2 = value.getTextureProperties();
        Intrinsics.checkNotNullExpressionValue(list2, "getTextureProperties(...)");
        list.addAll(list2);
    }

    @NotNull
    protected final GameMode getPeGameMode(@NotNull Player $this$peGameMode) {
        Intrinsics.checkNotNullParameter($this$peGameMode, "<this>");
        GameMode gameMode = SpigotConversionUtil.fromBukkitGameMode((org.bukkit.GameMode)$this$peGameMode.getGameMode());
        Intrinsics.checkNotNullExpressionValue(gameMode, "fromBukkitGameMode(...)");
        return gameMode;
    }

    protected final void setPeGameMode(@NotNull Player $this$peGameMode, @NotNull GameMode value) {
        Intrinsics.checkNotNullParameter($this$peGameMode, "<this>");
        Intrinsics.checkNotNullParameter(value, "value");
        $this$peGameMode.setGameMode(SpigotConversionUtil.toBukkitGameMode((GameMode)value));
    }

    @NotNull
    protected final Difficulty getPeDifficulty(@NotNull World $this$peDifficulty) {
        Intrinsics.checkNotNullParameter($this$peDifficulty, "<this>");
        return Difficulty.valueOf((String)$this$peDifficulty.getDifficulty().toString());
    }

    private final Dimension getDimension(Player player) {
        World world = player.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        Dimension peDimension = this.getPeDimension(world);
        World.Environment env = player.getWorld().getEnvironment();
        User user = this.getPeUser(player);
        String string = peDimension.getDimensionName();
        Intrinsics.checkNotNullExpressionValue(string, "getDimensionName(...)");
        if (StringsKt.isBlank(string)) {
            Dimension dim = user.getClientVersion().isNewerThan(ClientVersion.V_1_19) ? new Dimension(0) : new Dimension(env.getId());
            Intrinsics.checkNotNull(env);
            this.setDimension(env, dim);
            return dim;
        }
        return peDimension;
    }

    private final void setDimension(World.Environment env, Dimension dim) {
        switch (WhenMappings.$EnumSwitchMapping$0[env.ordinal()]) {
            case 1: {
                dim.setDimensionName("the_nether");
                break;
            }
            case 2: {
                dim.setDimensionName("the_end");
                break;
            }
            case 3: {
                dim.setDimensionName("overworld");
                break;
            }
            default: {
                dim.setDimensionName("overworld");
            }
        }
    }

    private final Dimension getPeDimension(World $this$peDimension) {
        Dimension dimension = SpigotConversionUtil.fromBukkitWorld((World)$this$peDimension);
        Intrinsics.checkNotNullExpressionValue(dimension, "fromBukkitWorld(...)");
        return dimension;
    }

    @NotNull
    protected final Dimension getPeDimension(@NotNull Player $this$peDimension) {
        Intrinsics.checkNotNullParameter($this$peDimension, "<this>");
        return this.getDimension($this$peDimension);
    }

    protected final int getPingInMs(@NotNull Player $this$pingInMs) {
        Intrinsics.checkNotNullParameter($this$pingInMs, "<this>");
        return CrossVersionPlayerHelper.getPing($this$pingInMs);
    }

    @NotNull
    protected final PacketWrapper<?> getPlayerInfoAddPacket(@NotNull Player $this$playerInfoAddPacket) {
        Intrinsics.checkNotNullParameter($this$playerInfoAddPacket, "<this>");
        WrapperPlayServerPlayerInfo.PlayerData[] playerDataArray = new WrapperPlayServerPlayerInfo.PlayerData[]{new WrapperPlayServerPlayerInfo.PlayerData(null, this.getPeProfile($this$playerInfoAddPacket), this.getPeGameMode($this$playerInfoAddPacket), this.getPingInMs($this$playerInfoAddPacket))};
        return (PacketWrapper)new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.ADD_PLAYER, playerDataArray);
    }

    @NotNull
    protected final PacketWrapper<?> getPlayerInfoAddPacketFromServerVersion(@NotNull Player $this$playerInfoAddPacketFromServerVersion) {
        Intrinsics.checkNotNullParameter($this$playerInfoAddPacketFromServerVersion, "<this>");
        return PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_19_4) ? this.getPlayerInfoAddPacket($this$playerInfoAddPacketFromServerVersion) : this.getModernPlayerInfoAddPacket($this$playerInfoAddPacketFromServerVersion);
    }

    @NotNull
    protected final PacketWrapper<?> getPlayerInfoRemovePacketFromServerVersion(@NotNull Player $this$playerInfoRemovePacketFromServerVersion) {
        Intrinsics.checkNotNullParameter($this$playerInfoRemovePacketFromServerVersion, "<this>");
        return PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_19_4) ? this.getPlayerInfoRemovePacket($this$playerInfoRemovePacketFromServerVersion) : this.getModernPlayerInfoRemovePacket($this$playerInfoRemovePacketFromServerVersion);
    }

    @Nullable
    protected final PacketWrapper<?> getPlayerInfoUpdateListedPacketFromServerVersion(@NotNull Player $this$playerInfoUpdateListedPacketFromServerVersion) {
        Intrinsics.checkNotNullParameter($this$playerInfoUpdateListedPacketFromServerVersion, "<this>");
        return PacketEvents.getAPI().getServerManager().getVersion().isOlderThan(ServerVersion.V_1_19_4) ? null : this.getModernPlayerInfoListPacket($this$playerInfoUpdateListedPacketFromServerVersion);
    }

    @NotNull
    protected final PacketWrapper<?> getPlayerInfoRemovePacket(@NotNull Player $this$playerInfoRemovePacket) {
        Intrinsics.checkNotNullParameter($this$playerInfoRemovePacket, "<this>");
        WrapperPlayServerPlayerInfo.PlayerData[] playerDataArray = new WrapperPlayServerPlayerInfo.PlayerData[]{new WrapperPlayServerPlayerInfo.PlayerData(null, this.getPeProfile($this$playerInfoRemovePacket), this.getPeGameMode($this$playerInfoRemovePacket), this.getPingInMs($this$playerInfoRemovePacket))};
        return (PacketWrapper)new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.REMOVE_PLAYER, playerDataArray);
    }

    @NotNull
    protected final PacketWrapper<?> getModernPlayerInfoAddPacket(@NotNull Player $this$modernPlayerInfoAddPacket) {
        Intrinsics.checkNotNullParameter($this$modernPlayerInfoAddPacket, "<this>");
        WrapperPlayServerPlayerInfoUpdate.PlayerInfo[] playerInfoArray = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(this.getPeProfile($this$modernPlayerInfoAddPacket), true, this.getPingInMs($this$modernPlayerInfoAddPacket), this.getPeGameMode($this$modernPlayerInfoAddPacket), null, null)};
        return (PacketWrapper)new WrapperPlayServerPlayerInfoUpdate(EnumSet.allOf(WrapperPlayServerPlayerInfoUpdate.Action.class), playerInfoArray);
    }

    @NotNull
    protected final PacketWrapper<?> getModernPlayerInfoRemovePacket(@NotNull Player $this$modernPlayerInfoRemovePacket) {
        Intrinsics.checkNotNullParameter($this$modernPlayerInfoRemovePacket, "<this>");
        UUID[] uUIDArray = new UUID[]{$this$modernPlayerInfoRemovePacket.getUniqueId()};
        return (PacketWrapper)new WrapperPlayServerPlayerInfoRemove(uUIDArray);
    }

    @NotNull
    protected final PacketWrapper<?> getModernPlayerInfoListPacket(@NotNull Player $this$modernPlayerInfoListPacket) {
        Intrinsics.checkNotNullParameter($this$modernPlayerInfoListPacket, "<this>");
        WrapperPlayServerPlayerInfoUpdate.PlayerInfo[] playerInfoArray = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(this.getPeProfile($this$modernPlayerInfoListPacket), true, this.getPingInMs($this$modernPlayerInfoListPacket), this.getPeGameMode($this$modernPlayerInfoListPacket), null, null)};
        return (PacketWrapper)new WrapperPlayServerPlayerInfoUpdate(WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED, playerInfoArray);
    }

    @NotNull
    protected final PacketWrapper<?> getRespawnPacket(@NotNull Player $this$respawnPacket) {
        Intrinsics.checkNotNullParameter($this$respawnPacket, "<this>");
        Dimension dimension = this.getPeDimension($this$respawnPacket);
        String string = $this$respawnPacket.getWorld().getName();
        World world = $this$respawnPacket.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        return (PacketWrapper)new WrapperPlayServerRespawn(dimension, string, this.getPeDifficulty(world), 0L, this.getPeGameMode($this$respawnPacket), this.getPeGameMode($this$respawnPacket), false, false, true, null, null, Integer.valueOf(0));
    }

    @NotNull
    protected final WrapperPlayServerEntityMetadata getMetadataPacket(@NotNull Player $this$metadataPacket) {
        Intrinsics.checkNotNullParameter($this$metadataPacket, "<this>");
        return new WrapperPlayServerEntityMetadata($this$metadataPacket.getEntityId(), CollectionsKt.listOf(new EntityData(CrossVersionPlayerHelper.getSkinLayersIndex(PacketEvents.getAPI().getServerManager().getVersion()), EntityDataTypes.BYTE, (Object)0)));
    }

    @NotNull
    protected final PacketWrapper<?> getDeleteEntityPacket(@NotNull Entity $this$deleteEntityPacket) {
        Intrinsics.checkNotNullParameter($this$deleteEntityPacket, "<this>");
        return (PacketWrapper)new WrapperPlayServerDestroyEntities($this$deleteEntityPacket.getEntityId());
    }

    @NotNull
    protected final PacketWrapper<?> getLegacySpawnPlayerPacket(@NotNull Player $this$legacySpawnPlayerPacket) {
        Intrinsics.checkNotNullParameter($this$legacySpawnPlayerPacket, "<this>");
        return (PacketWrapper)new WrapperPlayServerSpawnPlayer($this$legacySpawnPlayerPacket.getEntityId(), $this$legacySpawnPlayerPacket.getUniqueId(), this.getPeLocation($this$legacySpawnPlayerPacket), new EntityData[0]);
    }

    @NotNull
    protected final Location getPeLocation(@NotNull Player $this$peLocation) {
        Intrinsics.checkNotNullParameter($this$peLocation, "<this>");
        org.bukkit.Location location = $this$peLocation.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        return this.toPacketEvents(location);
    }

    @NotNull
    protected final PacketWrapper<?> getTeleportPacket(@NotNull Player $this$teleportPacket) {
        Intrinsics.checkNotNullParameter($this$teleportPacket, "<this>");
        return (PacketWrapper)new WrapperPlayServerEntityTeleport($this$teleportPacket.getEntityId(), new Location(new Vector3d(0.0, -100.0, 0.0), $this$teleportPacket.getLocation().getYaw(), $this$teleportPacket.getLocation().getPitch()), $this$teleportPacket.isOnGround());
    }

    private final World getAnyOtherWorld(World world) {
        World world2;
        Object v1;
        block2: {
            List list = Bukkit.getWorlds();
            Intrinsics.checkNotNullExpressionValue(list, "getWorlds(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                World it = (World)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getUID(), world.getUID()))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((world2 = (World)v1) == null) {
            world2 = world;
        }
        return world2;
    }

    protected final void teleportToOtherDimensionAndBack(@NotNull Player $this$teleportToOtherDimensionAndBack) {
        Intrinsics.checkNotNullParameter($this$teleportToOtherDimensionAndBack, "<this>");
        org.bukkit.Location loc = $this$teleportToOtherDimensionAndBack.getLocation();
        org.bukkit.Location location = loc.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        org.bukkit.Location otherDimLoc = location;
        World world = $this$teleportToOtherDimensionAndBack.getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        otherDimLoc.setWorld(this.getAnyOtherWorld(world));
        $this$teleportToOtherDimensionAndBack.teleport(otherDimLoc);
        $this$teleportToOtherDimensionAndBack.teleport(loc);
    }

    @NotNull
    protected final PacketWrapper<?> getRefreshChunksPacket() {
        return (PacketWrapper)new WrapperPlayServerChangeGameState(WrapperPlayServerChangeGameState.Reason.START_LOADING_CHUNKS, 0.0f);
    }

    @NotNull
    protected final Location toPacketEvents(@NotNull org.bukkit.Location $this$toPacketEvents) {
        Intrinsics.checkNotNullParameter($this$toPacketEvents, "<this>");
        return new Location($this$toPacketEvents.getX(), $this$toPacketEvents.getY(), $this$toPacketEvents.getZ(), $this$toPacketEvents.getYaw(), $this$toPacketEvents.getPitch());
    }

    protected final void ifNewerThan(@NotNull ClientVersion $this$ifNewerThan, @NotNull ClientVersion version, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter($this$ifNewerThan, "<this>");
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(block, "block");
        if ($this$ifNewerThan.isNewerThan(version)) {
            block.invoke();
        }
    }

    protected final void ifOlderThan(@NotNull ClientVersion $this$ifOlderThan, @NotNull ClientVersion version, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter($this$ifOlderThan, "<this>");
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(block, "block");
        if ($this$ifOlderThan.isOlderThan(version)) {
            block.invoke();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[World.Environment.values().length];
            try {
                nArray[World.Environment.NETHER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.THE_END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[World.Environment.NORMAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

