/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.packetevents;

import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.protocol.player.TextureProperty;
import com.github.retrooper.packetevents.protocol.player.UserProfile;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientSettings;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.onlyjordon.swiftdisguise.SwiftDisguiseSpigot;
import me.onlyjordon.swiftdisguise.api.DisguiseData;
import me.onlyjordon.swiftdisguise.events.PlayerSkinLayerChangeEvent;
import me.onlyjordon.swiftdisguise.utils.SkinLayers;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SpigotPacketListener
implements PacketListener {
    SwiftDisguiseSpigot api;

    public SpigotPacketListener(SwiftDisguiseSpigot api) {
        this.api = api;
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.CLIENT_SETTINGS) {
            Player player = (Player)event.getPlayer();
            WrapperPlayClientSettings wrapper = new WrapperPlayClientSettings(event);
            ((DisguiseData)this.api.getDisguiseData(event.getPlayer())).setRealSkinLayers(SkinLayers.getFromRaw(wrapper.getVisibleSkinSectionMask()));
            PlayerSkinLayerChangeEvent e = new PlayerSkinLayerChangeEvent(player, this.api.getDisguiseSkinLayers(player), SkinLayers.getFromRaw(wrapper.getVisibleSkinSectionMask()));
            if (!e.isCancelled()) {
                ((DisguiseData)this.api.getDisguiseData(event.getPlayer())).setFakeSkinLayers(e.getNewLayers());
            }
        }
    }

    public void onPacketSend(PacketSendEvent event) {
        PacketTypeCommon packetType = event.getPacketType();
        Player player = null;
        if (event.getPlayer() instanceof Player) {
            player = (Player)event.getPlayer();
        }
        if (player == null) {
            return;
        }
        if (packetType.equals(PacketType.Play.Server.PLAYER_INFO)) {
            this.handlePlayerInfoPacket(player, new WrapperPlayServerPlayerInfo(event));
        } else if (packetType.equals(PacketType.Play.Server.PLAYER_INFO_UPDATE)) {
            this.handlePlayerInfoUpdatePacket(player, new WrapperPlayServerPlayerInfoUpdate(event));
        } else if (packetType.equals(PacketType.Play.Server.PLAYER_INFO_REMOVE)) {
            this.handlePlayerInfoRemovePacket(player, new WrapperPlayServerPlayerInfoRemove(event));
        } else if (packetType.equals(PacketType.Play.Server.SPAWN_PLAYER)) {
            this.handleSpawnPlayerPacket(player, new WrapperPlayServerSpawnPlayer(event));
        } else if (packetType.equals(PacketType.Play.Server.SPAWN_ENTITY)) {
            this.handleSpawnEntityPacket(player, new WrapperPlayServerSpawnEntity(event));
        }
    }

    private void handleSpawnPlayerPacket(Player player, WrapperPlayServerSpawnPlayer wrapper) {
        UUID fakeId = this.api.getFakeUUID(wrapper.getUUID());
        if (!this.api.isRealPlayer(Bukkit.getPlayer((UUID)wrapper.getUUID()))) {
            return;
        }
        if (!Objects.equals(player.getUniqueId(), wrapper.getUUID())) {
            wrapper.setUUID(fakeId);
        } else {
            wrapper.setUUID(this.api.getRealUUID(player));
        }
    }

    private void handleSpawnEntityPacket(Player player, WrapperPlayServerSpawnEntity wrapper) {
        if (!wrapper.getUUID().isPresent()) {
            return;
        }
        wrapper.getUUID().ifPresent(uuid -> {
            if (!Objects.equals(wrapper.getEntityType(), EntityTypes.PLAYER)) {
                return;
            }
            if (!this.api.isRealPlayer(player)) {
                return;
            }
            UUID fakeId = this.api.getFakeUUID((UUID)uuid);
            if (!Objects.equals(player.getUniqueId(), uuid)) {
                wrapper.setUUID(Optional.of(fakeId));
            } else {
                wrapper.setUUID(Optional.of(this.api.getRealUUID(player)));
            }
        });
    }

    private void handlePlayerInfoRemovePacket(Player receiver, WrapperPlayServerPlayerInfoRemove wrapper) {
        ArrayList fakeIds = new ArrayList();
        wrapper.getProfileIds().forEach(uuid -> {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                return;
            }
            if (!this.api.isRealPlayer(player)) {
                return;
            }
            if (!Objects.equals(receiver.getUniqueId(), player.getUniqueId())) {
                fakeIds.add(this.api.getDisguiseData(player).getFakeUUID());
            } else {
                fakeIds.add(player.getUniqueId());
            }
        });
        wrapper.setProfileIds(fakeIds);
    }

    private void handlePlayerInfoUpdatePacket(Player receiver, WrapperPlayServerPlayerInfoUpdate wrapper) {
        wrapper.getEntries().forEach(playerData -> {
            Player player = Bukkit.getPlayer((UUID)playerData.getGameProfile().getUUID());
            if (!this.api.isRealPlayer(player)) {
                return;
            }
            if (player == null) {
                return;
            }
            UserProfile profile = playerData.getGameProfile();
            final TextureProperty property = new TextureProperty("textures", this.api.getDisguiseSkin(player).getValue(), this.api.getDisguiseSkin(player).getSignature());
            if (!Objects.equals(receiver.getUniqueId(), profile.getUUID())) {
                profile.setUUID(this.api.getFakeUUID(player.getUniqueId()));
            } else {
                profile.setUUID(player.getUniqueId());
            }
            profile.setName(this.api.getDisguiseName(player));
            profile.setTextureProperties((List)new ArrayList<TextureProperty>(){
                {
                    this.add(property);
                }
            });
            playerData.setGameProfile(profile);
        });
    }

    private void handlePlayerInfoPacket(Player receiver, WrapperPlayServerPlayerInfo wrapper) {
        wrapper.getPlayerDataList().forEach(playerData -> {
            Player player = Bukkit.getPlayer((UUID)playerData.getUserProfile().getUUID());
            if (!this.api.isRealPlayer(player)) {
                return;
            }
            if (player == null) {
                return;
            }
            UserProfile profile = playerData.getUser();
            if (profile == null) {
                return;
            }
            if (!Objects.equals(receiver.getUniqueId(), profile.getUUID())) {
                profile.setUUID(this.api.getFakeUUID(player.getUniqueId()));
            } else {
                profile.setUUID(player.getUniqueId());
            }
            profile.setName(this.api.getDisguiseName(player));
            final TextureProperty textureProperty = new TextureProperty("textures", this.api.getDisguiseSkin(player).getValue(), this.api.getDisguiseSkin(player).getSignature());
            profile.setTextureProperties((List)new ArrayList<TextureProperty>(){
                {
                    this.add(textureProperty);
                }
            });
            playerData.setUser(profile);
        });
    }
}

