/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.onlyjordon.swiftdisguise.api.SwiftDisguiseConfig;
import me.onlyjordon.swiftdisguise.utils.Util;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SwiftDisguiseLoader {
    private static SwiftDisguiseConfig config;
    private static YamlConfiguration yamlConfig;
    private static File configFile;

    public static File getConfigFile() {
        return configFile;
    }

    public static SwiftDisguiseConfig getConfig() {
        return config;
    }

    public static YamlConfiguration getYamlConfig() {
        return yamlConfig;
    }

    @ApiStatus.Internal
    public static void load() {
        configFile = new File(Util.getDataFolder().getAbsolutePath() + File.separator + "config.yml");
        if (!configFile.exists()) {
            if (!configFile.getParentFile().exists()) {
                configFile.getParentFile().mkdirs();
            }
            try {
                configFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        yamlConfig = YamlConfiguration.loadConfiguration(configFile);
        SwiftDisguiseLoader.loadDefaultConfigValues();
        SwiftDisguiseConfig.UUIDHidingMode hidingMode = SwiftDisguiseLoader.getEnum(yamlConfig, "settings.uuid-hiding-mode", SwiftDisguiseConfig.UUIDHidingMode.class, SwiftDisguiseConfig.UUIDHidingMode.RANDOM);
        SwiftDisguiseConfig.NameMode nameMode = SwiftDisguiseLoader.getEnum(yamlConfig, "settings.name-mode", SwiftDisguiseConfig.NameMode.class, SwiftDisguiseConfig.NameMode.WEAK);
        config = SwiftDisguiseConfig.create(hidingMode, nameMode);
    }

    private static <E extends Enum<E>> E getEnum(YamlConfiguration configuration, String path, Class<E> enumClass, E defaultValue) {
        String value = configuration.getString(path);
        Object enumValue = null;
        try {
            enumValue = Enum.valueOf(enumClass, configuration.getString(path, defaultValue.toString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (value == null) {
            System.err.println("Invalid enum value at (" + path + "), using default value: " + defaultValue.toString());
        }
        return (E)((Enum)Optional.ofNullable(enumValue).orElse(defaultValue));
    }

    private static void setDefaultValue(String path, Object value) {
        if (!yamlConfig.contains(path)) {
            yamlConfig.set(path, value);
        }
    }

    private static void loadDefaultConfigValues() {
        SwiftDisguiseLoader.setDefaultValue("settings.uuid-hiding-mode", SwiftDisguiseConfig.UUIDHidingMode.RANDOM.toString());
        SwiftDisguiseLoader.setDefaultValue("settings.name-mode", SwiftDisguiseConfig.NameMode.WEAK.toString());
        yamlConfig.setComments("settings", Collections.singletonList("The settings for SwiftDisguise"));
        yamlConfig.setComments("settings.uuid-hiding-mode", SwiftDisguiseLoader.getUUIDHidingModeComments());
        yamlConfig.setComments("settings.name-mode", SwiftDisguiseLoader.getNameModeComments());
        SwiftDisguiseLoader.saveConfig();
    }

    private static void saveConfig() {
        try {
            yamlConfig.save(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static List<String> getUUIDHidingModeComments() {
        ArrayList<String> uuidHidingComments = new ArrayList<String>();
        uuidHidingComments.add("The mode to use for hiding UUIDs");
        uuidHidingComments.add("NONE - No UUID hiding will be done");
        uuidHidingComments.add("RANDOM - Random UUIDs for each player");
        return uuidHidingComments;
    }

    @NotNull
    private static List<String> getNameModeComments() {
        ArrayList<String> nameModeComments = new ArrayList<String>();
        nameModeComments.add("The mode to use for player names");
        nameModeComments.add("WEAK - The server will think the player's name is their real name - commands will be the same as if they weren't nicked");
        nameModeComments.add("STRONG - less compatibility, can have issues as the server thinks your name is the nickname, tab completion + commands show nickname (commands sometimes work with nicknames)");
        return nameModeComments;
    }
}

