/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.onlyjordon.swiftdisguise.PlayerRefresher;
import me.onlyjordon.swiftdisguise.api.DisguiseData;
import me.onlyjordon.swiftdisguise.api.IDisguiseData;
import me.onlyjordon.swiftdisguise.api.SwiftDisguise;
import me.onlyjordon.swiftdisguise.api.SwiftDisguiseAPI;
import me.onlyjordon.swiftdisguise.api.SwiftDisguiseConfig;
import me.onlyjordon.swiftdisguise.api.TabPrefixSuffix;
import me.onlyjordon.swiftdisguise.nms.CrossVersionPlayerHelper;
import me.onlyjordon.swiftdisguise.packetevents.SpigotPacketListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;

public class SwiftDisguiseSpigot
extends SwiftDisguiseAPI {
    public HashMap<Player, IDisguiseData> oldData = new HashMap();
    private PlayerRefresher refresher;
    protected Cache<UUID, UUID> tempUniqueIdMap = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();

    public SwiftDisguiseSpigot() {
        PacketEvents.getAPI().init();
        PacketEvents.getAPI().getEventManager().registerListener((PacketListener)new SpigotPacketListener(this), PacketListenerPriority.LOW);
        this.refresher = new PlayerRefresher(this, JavaPlugin.getProvidingPlugin(this.getClass()));
    }

    public void disable() {
        PacketEvents.getAPI().terminate();
    }

    public void sendPrefixSuffix(Player sender, Player ... receiver) {
        this.refresher.refreshPrefixSuffix(sender, receiver);
    }

    @Override
    public void refreshPlayer(Object platformPlayer) {
        if (!this.validatePlatformPlayer(platformPlayer)) {
            throw new IllegalArgumentException("Invalid Player!");
        }
        Player player = (Player)platformPlayer;
        DisguiseData old = (DisguiseData)this.oldData.get(player);
        if (old == null || !old.skinAndNameAndUUIDEquals(this.getDisguiseData(player))) {
            this.refresher.refreshPlayer(player);
        }
        if (old == null || !old.skinLayersEquals(this.getDisguiseData(player))) {
            this.refresher.refreshSkinLayers(player);
        }
        if (old == null || !old.prefixSuffixEquals(this.getDisguiseData(player))) {
            this.refresher.refreshPrefixSuffix(player, Bukkit.getOnlinePlayers().toArray(new Player[0]));
        }
        this.oldData.put(player, ((DisguiseData)this.getDisguiseData(player)).copy());
    }

    @Override
    public void refreshPlayerSync(Object platformPlayer) {
        if (!this.validatePlatformPlayer(platformPlayer)) {
            throw new IllegalArgumentException("Invalid Player!");
        }
        this.refresher.refreshPlayerSync((Player)platformPlayer);
    }

    @Override
    public IDisguiseData getDisguiseData(Object platformPlayer) {
        if (!this.validatePlatformPlayer(platformPlayer)) {
            throw new IllegalArgumentException("Invalid Player!");
        }
        if (this.getDisguiseDataMap().containsKey(platformPlayer)) {
            return super.getDisguiseData(platformPlayer);
        }
        Player player = (Player)platformPlayer;
        this.getDisguiseDataMap().put(platformPlayer, new DisguiseData(player.getUniqueId(), SwiftDisguise.getConfig().hidingMode() == SwiftDisguiseConfig.UUIDHidingMode.RANDOM ? UUID.randomUUID() : player.getUniqueId(), player.getName(), player.getName(), CrossVersionPlayerHelper.skinFromBukkitPlayer(player), CrossVersionPlayerHelper.skinFromBukkitPlayer(player), null, null, new TabPrefixSuffix(), null));
        return this.getDisguiseData(platformPlayer);
    }

    @Override
    public void setDisguisePrefixSuffix(Object platformPlayer, TabPrefixSuffix prefixSuffix) {
        super.setDisguisePrefixSuffix(platformPlayer, prefixSuffix);
        this.refresher.refreshPrefixSuffix((Player)platformPlayer, Bukkit.getOnlinePlayers().toArray(new Player[0]));
    }

    @Override
    public UUID getFakeUUID(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return this.tempUniqueIdMap.getIfPresent(uuid);
        }
        return this.getDisguiseData(player).getFakeUUID();
    }

    @Override
    public boolean isRealPlayer(Object platformPlayer) {
        return platformPlayer != null && this.getDisguiseDataMap().containsKey(platformPlayer);
    }

    @Override
    protected boolean validatePlatformPlayer(Object platformPlayer) {
        return platformPlayer instanceof Player;
    }

    @ApiStatus.Internal
    public void unregisterPlayer(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        this.tempUniqueIdMap.put(((Player)platformPlayer).getUniqueId(), UUID.randomUUID());
        this.getDisguiseDataMap().remove(platformPlayer);
        this.refresher.unregisterPlayer((Player)platformPlayer);
    }
}

