/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi.commands;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.onlyjordon.nicknamingapi.commands.Command;
import me.onlyjordon.nicknamingapi.commands.CommandManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;

public class SimpleCommandManager
implements CommandManager {
    public List<Command> commands = null;
    private String prefix = "core";

    public void initialise() {
        this.commands = new ArrayList<Command>();
    }

    @Override
    public void removeCommands() {
        SimpleCommandMap map = null;
        Map knownCommands = null;
        try {
            Field cmdMap = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            cmdMap.setAccessible(true);
            map = (SimpleCommandMap)cmdMap.get(Bukkit.getPluginManager());
            Field knownCmds = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCmds.setAccessible(true);
            knownCommands = (Map)knownCmds.get(map);
            try {
                for (Command command : this.commands) {
                    command.unregister((CommandMap)map);
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
            }
            for (Command cmd : this.commands) {
                try {
                    knownCommands.remove(cmd.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            knownCmds.set(map, knownCommands);
        }
        catch (Error | Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addCommand(Command command) {
        this.commands.add(command);
    }

    @Override
    public void removeCommand(Command command) {
        this.commands.remove((Object)command);
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void updateCommandMap() {
        this.removeCommands();
        CommandMap map = null;
        try {
            Field cmdMap = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            cmdMap.setAccessible(true);
            map = (CommandMap)cmdMap.get(Bukkit.getPluginManager());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Command cmd : this.commands) {
            try {
                if (map == null) {
                    return;
                }
                map.register(cmd.getName(), this.prefix, (org.bukkit.command.Command)cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void disable() {
        this.removeCommands();
    }
}

