/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.UUID;
import me.onlyjordon.nicknamingapi.INickData;
import me.onlyjordon.nicknamingapi.NickData;
import me.onlyjordon.nicknamingapi.utils.Skin;
import me.onlyjordon.nicknamingapi.utils.SkinLayers;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class INicknamer {
    protected HashMap<UUID, NickData> data = new HashMap();

    @Nullable
    public INickData getData(Player player) {
        return this.data.get(player.getUniqueId());
    }

    public abstract void refreshPlayer(Player var1);

    public abstract void resetDisguise(Player var1);

    public abstract boolean setSkin(Player var1, Skin var2);

    public void resetSkin(@NotNull Player player) {
        NickData d = this.data.get(player.getUniqueId());
        if (d == null) {
            return;
        }
        Skin skin = d.getOriginalSkin();
        if (skin == null) {
            return;
        }
        if (this.setSkin(player, skin)) {
            d.setCurrentSkin(null);
        }
    }

    public void hide(@NotNull Player player, @NotNull SkinLayers.SkinLayer layer) {
        this.setSkinLayerVisible(player, layer, false);
    }

    public void show(@NotNull Player player, @NotNull SkinLayers.SkinLayer layer) {
        this.setSkinLayerVisible(player, layer, true);
    }

    public abstract void setSkinLayerVisible(@NotNull Player var1, @NotNull SkinLayers.SkinLayer var2, boolean var3);

    public abstract boolean isSkinLayerVisible(@NotNull Player var1, @NotNull SkinLayers.SkinLayer var2);

    public abstract SkinLayers getSkinLayers(@NotNull Player var1);

    public EnumSet<SkinLayers.SkinLayer> getVisibleSkinLayers(@NotNull Player player) {
        return this.getSkinLayers(player).getVisibleLayers();
    }

    public abstract void setNick(@NotNull Player var1, @NotNull String var2);

    public abstract void resetNick(@NotNull Player var1);

    public abstract void setPrefixSuffix(@NotNull Player var1, @NotNull TextComponent var2, @NotNull TextComponent var3, @NotNull ChatColor var4, int var5);

    public abstract void updatePrefixSuffix(@NotNull Player var1);

    @ApiStatus.Internal
    public abstract void disable();

    @ApiStatus.Internal
    public abstract void setup();

    public abstract String getNick(@NotNull Player var1);

    @Nullable
    public abstract Player getPlayerWithNick(@NotNull String var1);

    public abstract Skin getSkin(@NotNull Player var1);

    public abstract Skin getSkin(@NotNull String var1);

    public abstract void setSkinLayers(Player var1, SkinLayers var2);

    public abstract TextComponent getPrefix(Player var1);

    public abstract TextComponent getSuffix(Player var1);

    public abstract void removePrefixSuffix(Player var1);
}

