/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi;

import java.util.HashMap;
import me.onlyjordon.nicknamingapi.Nicknamer;
import me.onlyjordon.nicknamingapi.utils.Skin;
import me.onlyjordon.nicknamingapi.utils.SkinLayers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class DisguiseBuilder {
    private final Nicknamer nicknamer;
    private String nick;
    private String skinName = null;
    private Skin skin = null;
    private boolean isReset = false;
    private ChatColor prefixSuffixColor;
    private int priority;
    HashMap<SkinLayers.SkinLayer, Boolean> skinLayerVisibility = new HashMap();
    private TextComponent prefix;
    private TextComponent suffix;

    public DisguiseBuilder(Nicknamer nicknamer) {
        this.nicknamer = nicknamer;
    }

    public DisguiseBuilder setNick(String nick) {
        this.nick = nick;
        return this;
    }

    public DisguiseBuilder setSkin(String skinName) {
        this.skinName = skinName;
        this.skin = null;
        return this;
    }

    public DisguiseBuilder setSkin(Skin skin) {
        this.skin = skin;
        this.skinName = null;
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(TextComponent prefix, TextComponent suffix, ChatColor color, int priority) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.prefixSuffixColor = color;
        this.priority = priority;
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(TextComponent prefix, TextComponent suffix, ChatColor color) {
        this.setPrefixSuffix(prefix, suffix, color, 0);
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(TextComponent prefix, TextComponent suffix, int priority) {
        this.setPrefixSuffix(prefix, suffix, ChatColor.WHITE, priority);
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(TextComponent prefix, TextComponent suffix) {
        this.setPrefixSuffix(prefix, suffix, ChatColor.WHITE, 0);
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(String prefix, String suffix, ChatColor color, int priority) {
        this.prefix = Component.text(prefix);
        this.suffix = Component.text(suffix);
        this.prefixSuffixColor = color;
        this.priority = priority;
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(String prefix, String suffix, ChatColor color) {
        this.setPrefixSuffix(prefix, suffix, color, 0);
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(String prefix, String suffix, int priority) {
        this.setPrefixSuffix(prefix, suffix, ChatColor.WHITE, priority);
        return this;
    }

    public DisguiseBuilder setPrefixSuffix(String prefix, String suffix) {
        this.setPrefixSuffix(prefix, suffix, ChatColor.WHITE, 0);
        return this;
    }

    public DisguiseBuilder setSkinLayerVisible(SkinLayers.SkinLayer layer, boolean visible) {
        this.skinLayerVisibility.put(layer, visible);
        return this;
    }

    public DisguiseBuilder reset() {
        this.isReset = true;
        return this;
    }

    public void apply(Player player) {
        if (this.isReset) {
            this.nicknamer.resetDisguise(player);
            return;
        }
        if (this.nick != null) {
            this.nicknamer.setNick(player, this.nick);
        }
        if (this.skinName != null) {
            this.nicknamer.setSkin(player, this.skinName);
        }
        if (this.skin != null) {
            this.nicknamer.setSkin(player, Skin.getSkin(this.skinName));
        }
        if (this.prefix != null && this.suffix != null && this.prefixSuffixColor != null) {
            this.nicknamer.setPrefixSuffix(player, this.prefix, this.suffix, this.prefixSuffixColor, this.priority);
        }
        for (SkinLayers.SkinLayer layer : this.skinLayerVisibility.keySet()) {
            this.nicknamer.setSkinLayerVisible(player, layer, this.skinLayerVisibility.get((Object)layer));
        }
    }
}

