/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi.utils;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class SkinLayers {
    private EnumSet<SkinLayer> visibleLayers = EnumSet.noneOf(SkinLayer.class);

    private SkinLayers(byte raw) {
        for (SkinLayer layer : SkinLayer.values()) {
            if (!layer.isEnabled(raw)) continue;
            this.visibleLayers.add(layer);
        }
    }

    public byte getRawSkinLayers() {
        byte raw = 0;
        for (SkinLayer layer : this.visibleLayers) {
            raw = layer.toggleEnabled(raw, true);
        }
        return raw;
    }

    public EnumSet<SkinLayer> getVisibleLayers() {
        return this.visibleLayers;
    }

    public void setLayerVisible(SkinLayer layer, boolean shown) {
        if (shown) {
            this.visibleLayers.add(layer);
        } else {
            this.visibleLayers.remove((Object)layer);
        }
    }

    public static SkinLayers getFromRaw(byte raw) {
        return new SkinLayers(raw);
    }

    public static SkinLayers getFromVisibleLayers(EnumSet<SkinLayer> visibleLayers) {
        SkinLayers layers = new SkinLayers(0);
        layers.visibleLayers = visibleLayers;
        return layers;
    }

    public static SkinLayers getFromVisibleLayers(SkinLayer ... visibleLayers) {
        SkinLayers layers = new SkinLayers(0);
        layers.visibleLayers = EnumSet.of(visibleLayers[0], visibleLayers);
        return layers;
    }

    public boolean isLayerVisible(@NotNull SkinLayer layer) {
        return this.visibleLayers.contains((Object)layer);
    }

    public String toString() {
        return "SkinLayers{visibleLayers=" + this.visibleLayers + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinLayers)) {
            return false;
        }
        SkinLayers that = (SkinLayers)o;
        return this.visibleLayers.equals(that.visibleLayers);
    }

    public int hashCode() {
        return this.visibleLayers.hashCode();
    }

    public SkinLayers copy() {
        return SkinLayers.getFromRaw(this.getRawSkinLayers());
    }

    public static enum SkinLayer {
        CAPE(1),
        JACKET(2),
        LEFT_SLEEVE(4),
        RIGHT_SLEEVE(8),
        LEFT_PANTS(16),
        RIGHT_PANTS(32),
        HAT(64);

        private final byte value;

        private SkinLayer(byte value) {
            this.value = value;
        }

        public boolean isEnabled(byte raw) {
            return (raw & this.value) == this.value;
        }

        public byte toggleEnabled(byte raw, boolean enabled) {
            if (enabled) {
                return (byte)(raw | this.value);
            }
            return (byte)(raw & ~this.value);
        }
    }
}

