/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi.events;

import me.onlyjordon.nicknamingapi.utils.SkinLayers;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.Nullable;

public class PlayerSkinLayerChangeEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLERS_LIST = new HandlerList();
    private boolean cancelled = false;
    private final SkinLayers previousLayers;
    private SkinLayers currentLayers;
    private final Player player;
    private final Reason reason;

    public PlayerSkinLayerChangeEvent(Player who, SkinLayers prev, SkinLayers current, Reason reason) {
        super(!Bukkit.isPrimaryThread());
        this.player = who;
        this.previousLayers = prev;
        this.currentLayers = current;
        this.reason = reason;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public SkinLayers getPreviousLayers() {
        return this.previousLayers;
    }

    @Nullable
    public SkinLayers getNewLayers() {
        return this.currentLayers;
    }

    public void setNewLayers(SkinLayers newLayers) {
        this.currentLayers = newLayers;
    }

    public HandlerList getHandlers() {
        return HANDLERS_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS_LIST;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public static enum Reason {
        PLAYER,
        PLUGIN;

    }
}

