/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi.commands;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.HumanEntity;
import org.bukkit.permissions.Permission;

public abstract class Command
extends org.bukkit.command.Command
implements CommandExecutor,
TabCompleter {
    private final transient Map<String, String> usageStrings;

    protected Command(String name) {
        this(name, "");
    }

    protected Command(String name, String permission) {
        this(name, permission, new ArrayList<String>());
    }

    protected Command(String name, Permission permission) {
        this(name, permission.getName());
    }

    protected Command(String name, List<String> aliases) {
        this(name, null, aliases);
    }

    protected Command(String name, String permission, List<String> aliases) {
        super(name);
        if (!Objects.equals(permission, "")) {
            this.setPermission(permission);
        }
        if (aliases != null && aliases.isEmpty()) {
            this.setAliases(aliases);
        }
        try {
            Field activeAliases = org.bukkit.command.Command.class.getDeclaredField("activeAliases");
            activeAliases.setAccessible(true);
            activeAliases.set((Object)this, aliases);
            Field al = org.bukkit.command.Command.class.getDeclaredField("aliases");
            al.setAccessible(true);
            al.set((Object)this, aliases);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.usageStrings = new LinkedHashMap<String, String>();
    }

    protected Command(String name, String permission, String[] aliases) {
        this(name, permission, Arrays.stream(aliases).collect(Collectors.toList()));
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args2, Location location) throws IllegalArgumentException {
        return this.tabComplete(sender, args2);
    }

    public List<String> tabComplete(CommandSender sender, String[] args2) {
        return this.tabComplete(sender, this.getName(), args2);
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args2) throws IllegalArgumentException {
        List<String> tabs = null;
        try {
            tabs = this.onTabComplete(sender, this, alias, args2);
        }
        catch (Exception e) {
            System.err.println("There was an error tab-completing command " + alias + " for " + sender.getName() + ". Full command: (/" + alias + " " + String.join((CharSequence)" ", args2) + ")");
            e.printStackTrace();
        }
        if (tabs == null) {
            tabs = Bukkit.getOnlinePlayers().stream().map(HumanEntity::getName).collect(Collectors.toList());
        }
        tabs.remove(null);
        return tabs;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args2) {
        return this.onCommand(sender, this, commandLabel, args2);
    }

    public Map<String, String> getUsageStrings() {
        return this.usageStrings;
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command command, String label, String[] args2) {
        if (!this.testPermission(sender)) {
            return false;
        }
        return this.execute(sender, command, label, args2);
    }

    protected abstract boolean execute(CommandSender var1, org.bukkit.command.Command var2, String var3, String[] var4);

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command command, String alias, String[] args2) {
        if (!this.testPermission(sender)) {
            return null;
        }
        HashMap<String, Integer> allTabs = this.completeTab(sender, alias, args2);
        if (allTabs == null) {
            return null;
        }
        if (allTabs.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> currentTabs = new ArrayList<String>();
        allTabs.keySet().forEach(tab -> {
            int arg = (Integer)allTabs.get(tab);
            if (args2.length == 0 && arg == 0) {
                currentTabs.add((String)tab);
            }
            if (args2.length - 1 != arg) {
                return;
            }
            if (args2.length == 1) {
                if (tab.length() < args2[arg].length()) {
                    return;
                }
                String currentArg = args2[arg];
                int length = currentArg.length();
                if (length == 0) {
                    currentTabs.add((String)tab);
                    return;
                }
                String argument1 = tab.substring(0, length);
                if (currentArg.equalsIgnoreCase(argument1)) {
                    currentTabs.add((String)tab);
                }
            } else if (args2.length >= 1 && arg >= 1) {
                if (args2[arg].isEmpty()) {
                    currentTabs.add((String)tab);
                } else {
                    if (tab.length() < args2[arg].length()) {
                        return;
                    }
                    String currentArg = args2[arg];
                    int length = currentArg.length();
                    if (length == 0) {
                        currentTabs.add((String)tab);
                        return;
                    }
                    String argument1 = tab.substring(0, length);
                    if (currentArg.equalsIgnoreCase(argument1)) {
                        currentTabs.add((String)tab);
                    }
                }
            }
        });
        return currentTabs;
    }

    public abstract HashMap<String, Integer> completeTab(CommandSender var1, String var2, String[] var3);
}

