/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi;

import java.lang.reflect.InvocationTargetException;
import me.onlyjordon.nicknamingapi.INicknamer;
import me.onlyjordon.nicknamingapi.Nicknamer;
import me.onlyjordon.nicknamingapi.utils.NMSUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NicknamerAPI
extends JavaPlugin
implements Listener {
    private static Nicknamer disguiser;
    private static boolean isDev;
    private Object dev;

    public void onEnable() {
        if (disguiser.getImplementation() instanceof Listener) {
            this.getServer().getPluginManager().registerEvents((Listener)disguiser.getImplementation(), (Plugin)this);
        }
        if (isDev) {
            try {
                this.dev = Class.forName("me.onlyjordon.nicknamingapi.Dev").getConstructor(JavaPlugin.class).newInstance(new Object[]{this});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> disguiser.setup(), 1L);
    }

    public void onLoad() {
        this.setNicknamer();
        String env = System.getenv("NICKNAMER_DEV");
        if (env != null) {
            isDev = env.equalsIgnoreCase("true");
        }
    }

    private void setNicknamer() {
        String verAndRev = NMSUtils.getMinecraftPackage();
        try {
            Class<?> disguiserClass = Class.forName("me.onlyjordon.nicknamingapi.nms." + verAndRev + ".util.Disguiser");
            INicknamer nicknamer = (INicknamer)disguiserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            disguiser = new Nicknamer(nicknamer, this);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to load - Try updating the plugin or your server!", e);
        }
    }

    public void onDisable() {
        disguiser.disable();
        if (isDev) {
            try {
                this.dev.getClass().getDeclaredMethod("disable", new Class[0]).invoke(this.dev, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Nicknamer getNicknamer() {
        if (disguiser == null) {
            throw new NullPointerException("Null Nicknamer! NicknamerAPI hasn't loaded, check https://github.com/jordoncodes/nicknamer-api?tab=readme-ov-file#null-nicknamer on how to fix.");
        }
        return disguiser;
    }

    static {
        isDev = false;
    }
}

