/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.nicknamingapi;

import java.util.EnumSet;
import me.onlyjordon.nicknamingapi.INickData;
import me.onlyjordon.nicknamingapi.INicknamer;
import me.onlyjordon.nicknamingapi.NicknamerAPI;
import me.onlyjordon.nicknamingapi.events.PlayerNickChangeEvent;
import me.onlyjordon.nicknamingapi.events.PlayerPrefixSuffixChangeEvent;
import me.onlyjordon.nicknamingapi.events.PlayerRefreshEvent;
import me.onlyjordon.nicknamingapi.events.PlayerSkinChangeEvent;
import me.onlyjordon.nicknamingapi.events.PlayerSkinLayerChangeEvent;
import me.onlyjordon.nicknamingapi.utils.Skin;
import me.onlyjordon.nicknamingapi.utils.SkinLayers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Nicknamer {
    private final INicknamer nicknamerImpl;
    private final NicknamerAPI plugin;

    public Nicknamer(INicknamer nicknamerImpl, NicknamerAPI plugin) {
        this.nicknamerImpl = nicknamerImpl;
        this.plugin = plugin;
    }

    public void refreshPlayer(@NotNull Player player) {
        if (Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.refreshPlayer(player));
            return;
        }
        PlayerRefreshEvent event = new PlayerRefreshEvent(player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.nicknamerImpl.refreshPlayer(player);
        }
    }

    public void resetDisguise(@NotNull Player player) {
        this.nicknamerImpl.resetDisguise(player);
    }

    public boolean setSkin(@NotNull Player player, @NotNull Skin skin) {
        PlayerSkinChangeEvent event = new PlayerSkinChangeEvent(player, this.nicknamerImpl.getSkin(player), skin);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        return this.nicknamerImpl.setSkin(player, event.getNewSkin());
    }

    public void setSkin(@NotNull Player player, @NotNull String name) {
        if (Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.setSkin(player, name));
            return;
        }
        Skin skin = Skin.getSkin(name);
        PlayerSkinChangeEvent event = new PlayerSkinChangeEvent(player, this.nicknamerImpl.getSkin(player), skin);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Skin newSkin = event.getNewSkin();
        if (newSkin == null) {
            this.nicknamerImpl.resetSkin(player);
        } else {
            this.nicknamerImpl.setSkin(player, newSkin);
        }
        this.refreshPlayer(player);
    }

    public void setSkinLayerVisible(@NotNull Player player, @NotNull SkinLayers.SkinLayer layer, boolean visible) {
        SkinLayers layers = this.nicknamerImpl.getSkinLayers(player).copy();
        layers.setLayerVisible(layer, visible);
        PlayerSkinLayerChangeEvent event = new PlayerSkinLayerChangeEvent(player, this.nicknamerImpl.getSkinLayers(player), layers, PlayerSkinLayerChangeEvent.Reason.PLUGIN);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.nicknamerImpl.setSkinLayers(player, event.getNewLayers());
    }

    public boolean isSkinLayerVisible(@NotNull Player player, @NotNull SkinLayers.SkinLayer layer) {
        return this.nicknamerImpl.isSkinLayerVisible(player, layer);
    }

    public SkinLayers getSkinLayers(@NotNull Player player) {
        return this.nicknamerImpl.getSkinLayers(player);
    }

    public void hide(@NotNull Player player, @NotNull SkinLayers.SkinLayer layer) {
        this.nicknamerImpl.hide(player, layer);
    }

    public void show(@NotNull Player player, @NotNull SkinLayers.SkinLayer layer) {
        this.nicknamerImpl.show(player, layer);
    }

    public void setNick(@NotNull Player player, @NotNull String nick) {
        PlayerNickChangeEvent event = new PlayerNickChangeEvent(player, this.nicknamerImpl.getNick(player), nick);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        System.out.println("new nick: " + event.getNewNick() + " // old nick: " + event.getPreviousNick());
        if (event.getNewNick() == null) {
            this.nicknamerImpl.resetNick(player);
        } else {
            this.nicknamerImpl.setNick(player, event.getNewNick());
        }
    }

    public void resetNick(@NotNull Player player) {
        PlayerNickChangeEvent event = new PlayerNickChangeEvent(player, this.nicknamerImpl.getNick(player), null);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (event.getNewNick() == null) {
            this.nicknamerImpl.resetNick(player);
        } else {
            this.nicknamerImpl.setNick(player, event.getNewNick());
        }
    }

    public void setPrefixSuffix(@NotNull Player player, @NotNull TextComponent prefix, @NotNull TextComponent suffix, @NotNull ChatColor color, int priority) {
        PlayerPrefixSuffixChangeEvent event = new PlayerPrefixSuffixChangeEvent(player, this.getPrefix(player), this.getSuffix(player), prefix, suffix, color, priority);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        TextComponent pref = event.getNewPrefix();
        TextComponent suff = event.getNewSuffix();
        if (pref == null) {
            pref = Component.text("");
        }
        if (suff == null) {
            suff = Component.text("");
        }
        this.nicknamerImpl.setPrefixSuffix(player, pref, suff, event.getColor(), event.getPriority());
    }

    public TextComponent getPrefix(@NotNull Player player) {
        return this.nicknamerImpl.getPrefix(player);
    }

    public TextComponent getSuffix(@NotNull Player player) {
        return this.nicknamerImpl.getSuffix(player);
    }

    public void updatePrefixSuffix(@NotNull Player player) {
        this.nicknamerImpl.updatePrefixSuffix(player);
    }

    public void disable() {
        this.nicknamerImpl.disable();
    }

    public void setup() {
        this.nicknamerImpl.setup();
    }

    public String getNick(@NotNull Player player) {
        return this.nicknamerImpl.getNick(player);
    }

    @Nullable
    public Player getPlayerWithNick(@NotNull String nick) {
        return this.nicknamerImpl.getPlayerWithNick(nick);
    }

    public Skin getSkin(@NotNull Player player) {
        return this.nicknamerImpl.getSkin(player);
    }

    public Skin getSkin(@NotNull String skinName) {
        return this.nicknamerImpl.getSkin(skinName);
    }

    public void resetSkin(@NotNull Player player) {
        PlayerSkinChangeEvent event = new PlayerSkinChangeEvent(player, this.nicknamerImpl.getSkin(player), null);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (event.getNewSkin() == null) {
            this.nicknamerImpl.resetSkin(player);
        } else {
            this.nicknamerImpl.setSkin(player, event.getNewSkin());
        }
    }

    public EnumSet<SkinLayers.SkinLayer> getVisibleSkinLayers(@NotNull Player player) {
        return this.nicknamerImpl.getVisibleSkinLayers(player);
    }

    @Nullable
    public INickData getData(Player player) {
        return this.nicknamerImpl.getData(player);
    }

    protected INicknamer getImplementation() {
        return this.nicknamerImpl;
    }
}

