/*
 * Decompiled with CFR 0.152.
 */
package org.bspfsystems.yamlconfiguration.file;

import java.util.LinkedHashMap;
import java.util.Map;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.LoaderOptions;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.constructor.SafeConstructor;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.error.YAMLException;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.nodes.MappingNode;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.nodes.Node;
import me.onlyjordon.swiftdisguise.libs.yaml.snakeyaml.nodes.Tag;
import org.bspfsystems.yamlconfiguration.serialization.ConfigurationSerialization;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class YamlConstructor
extends SafeConstructor {
    YamlConstructor(@NotNull LoaderOptions loaderOptions) {
        super(loaderOptions);
        this.yamlConstructors.put(Tag.MAP, new ConstructCustomObject());
    }

    @Nullable
    Object construct(@NotNull Node node) {
        return this.constructObject(node);
    }

    @Override
    protected void flattenMapping(@NotNull MappingNode mappingNode) {
        super.flattenMapping(mappingNode);
    }

    private final class ConstructCustomObject
    extends SafeConstructor.ConstructYamlMap {
        private ConstructCustomObject() {
            super(YamlConstructor.this);
        }

        @Override
        @Nullable
        public Object construct(@NotNull Node node) {
            if (node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
            }
            Map raw = (Map)super.construct(node);
            if (raw.containsKey("==")) {
                LinkedHashMap typed = new LinkedHashMap(raw.size());
                for (Map.Entry entry : raw.entrySet()) {
                    typed.put(entry.getKey().toString(), entry.getValue());
                }
                try {
                    return ConfigurationSerialization.deserializeObject(typed);
                }
                catch (IllegalArgumentException e) {
                    throw new YAMLException("Could not deserialize object.", e);
                }
            }
            return raw;
        }

        @Override
        public void construct2ndStep(@NotNull Node node, @NotNull Object object) {
            throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
        }
    }
}

