/*
 * Decompiled with CFR 0.152.
 */
package me.onlyjordon.swiftdisguise.api;

import java.io.File;
import java.net.URL;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.onlyjordon.swiftdisguise.api.DisguiseData;
import me.onlyjordon.swiftdisguise.api.IDisguiseData;
import me.onlyjordon.swiftdisguise.api.ISwiftDisguiseAPI;
import me.onlyjordon.swiftdisguise.api.TabPrefixSuffix;
import me.onlyjordon.swiftdisguise.utils.Skin;
import me.onlyjordon.swiftdisguise.utils.SkinLayers;

public abstract class SwiftDisguiseAPI
implements ISwiftDisguiseAPI {
    private final Map<Object, IDisguiseData> disguiseDataMap = new ConcurrentHashMap<Object, IDisguiseData>();

    @Override
    public IDisguiseData getDisguiseData(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.disguiseDataMap.get(platformPlayer);
    }

    @Override
    public void setDisguiseUniqueId(Object platformPlayer, UUID uuid) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeUUID(uuid);
    }

    @Override
    public UUID getDisguiseUniqueId(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseData(platformPlayer).getFakeUUID();
    }

    @Override
    public void setDisguiseData(Object platformPlayer, IDisguiseData disguiseData) {
        this.checkPlayer(platformPlayer);
        this.disguiseDataMap.put(platformPlayer, disguiseData);
    }

    private DisguiseData getDisguiseDataImpl(Object platformPlayer) {
        return (DisguiseData)this.getDisguiseData(platformPlayer);
    }

    @Override
    public UUID getRealUUID(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseDataImpl(platformPlayer).getRealUUID();
    }

    @Override
    public String getRealName(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseDataImpl(platformPlayer).getRealName();
    }

    @Override
    public TabPrefixSuffix getDisguisePrefixSuffix(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return (TabPrefixSuffix)this.getDisguiseDataImpl(platformPlayer).getPrefixSuffix();
    }

    @Override
    public void setDisguisePrefixSuffix(Object platformPlayer, TabPrefixSuffix prefixSuffix) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setPrefixSuffix(prefixSuffix);
    }

    @Override
    public void resetDisguisePrefixSuffix(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setPrefixSuffix(new TabPrefixSuffix());
    }

    protected Map<Object, IDisguiseData> getDisguiseDataMap() {
        return this.disguiseDataMap;
    }

    @Override
    public void setDisguiseName(Object platformPlayer, String nick) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeName(nick);
    }

    @Override
    public void setDisguiseSkin(Object platformPlayer, Skin skin) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkin(skin);
    }

    @Override
    public void setDisguise(Object platformPlayer, String nick, Skin skin) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeName(nick);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkin(skin);
    }

    @Override
    public void resetDisguise(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        this.resetDisguiseName(platformPlayer);
        this.resetDisguiseSkin(platformPlayer);
        this.resetDisguiseSkinLayers(platformPlayer);
        this.resetDisguisePrefixSuffix(platformPlayer);
    }

    @Override
    public void resetDisguiseSkinLayers(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkinLayers(this.getDisguiseDataImpl(platformPlayer).getRealSkinLayers());
    }

    @Override
    public SkinLayers getDisguiseSkinLayers(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseDataImpl(platformPlayer).getFakeSkinLayers();
    }

    @Override
    public void setDisguiseSkinLayers(Object platformPlayer, SkinLayers skinLayers) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkinLayers(skinLayers);
    }

    @Override
    public void setDisguiseSkinLayers(Object platformPlayer, EnumSet<SkinLayers.SkinLayer> layers) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkinLayers(SkinLayers.getFromVisibleLayers(layers));
    }

    @Override
    public void setDisguiseSkinLayers(Object platformPlayer, SkinLayers.SkinLayer ... layers) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkinLayers(SkinLayers.getFromVisibleLayers(layers));
    }

    @Override
    public void setSkinLayerVisible(Object platformPlayer, SkinLayers.SkinLayer skinLayer, boolean visible) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).getFakeSkinLayers().setLayerVisible(skinLayer, visible);
    }

    @Override
    public boolean isSkinLayerVisible(Object platformPlayer, SkinLayers.SkinLayer skinLayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseDataImpl(platformPlayer).getFakeSkinLayers().isLayerVisible(skinLayer);
    }

    @Override
    public void show(Object platformPlayer, SkinLayers.SkinLayer layer) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).getFakeSkinLayers().setLayerVisible(layer, true);
    }

    @Override
    public void hide(Object platformPlayer, SkinLayers.SkinLayer layer) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).getFakeSkinLayers().setLayerVisible(layer, false);
    }

    @Override
    public void disguiseAs(Object platformPlayer, Object platformEntity) {
        this.checkPlayer(platformPlayer);
        this.setDisguiseName(platformPlayer, this.getRealName(platformEntity));
        this.setDisguiseSkin(platformPlayer, this.getRealSkin(platformEntity));
    }

    @Override
    public void resetDisguiseName(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        this.setDisguiseName(platformPlayer, this.getRealName(platformPlayer));
    }

    @Override
    public void resetDisguiseSkin(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        this.setDisguiseSkin(platformPlayer, this.getRealSkin(platformPlayer));
    }

    @Override
    public void setDisguiseSkin(Object platformPlayer, String skin) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkin(Skin.getSkin(skin));
    }

    @Override
    public void setDisguiseSkin(Object platformPlayer, File file) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkin(Skin.getSkin(file));
    }

    @Override
    public void setDisguiseSkin(Object platformPlayer, URL url) {
        this.checkPlayer(platformPlayer);
        this.getDisguiseDataImpl(platformPlayer).setFakeSkin(Skin.getSkin(url));
    }

    @Override
    public Skin getDisguiseSkin(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseData(platformPlayer).getFakeSkin();
    }

    @Override
    public Skin getRealSkin(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseData(platformPlayer).getRealSkin();
    }

    @Override
    public String getDisguiseName(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseData(platformPlayer).getFakeName();
    }

    @Override
    public EnumSet<SkinLayers.SkinLayer> getVisibleSkinLayers(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseData(platformPlayer).getFakeSkinLayers().getVisibleLayers();
    }

    @Override
    public SkinLayers getRealSkinLayers(Object platformPlayer) {
        this.checkPlayer(platformPlayer);
        return this.getDisguiseData(platformPlayer).getRealSkinLayers();
    }

    @Override
    public Object getPlayerByDisguiseName(String name) {
        for (Map.Entry<Object, IDisguiseData> entry : this.disguiseDataMap.entrySet()) {
            if (!entry.getValue().getFakeName().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Object getPlayerByRealName(String name) {
        for (Map.Entry<Object, IDisguiseData> entry : this.disguiseDataMap.entrySet()) {
            if (!entry.getValue().getRealName().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean isDisguiseNameTaken(String name) {
        for (Map.Entry<Object, IDisguiseData> entry : this.disguiseDataMap.entrySet()) {
            if (!entry.getValue().getFakeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected void checkPlayer(Object platformPlayer) {
        if (!this.validatePlatformPlayer(platformPlayer)) {
            throw new IllegalArgumentException("Invalid Player");
        }
    }

    protected abstract boolean validatePlatformPlayer(Object var1);
}

