/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.ArrayIterator;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.mask.Mask;
import org.ipvp.canvas.slot.DefaultSlot;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.type.MenuHolder;

public abstract class AbstractMenu
implements Menu {
    private Menu parent;
    private boolean redraw;
    private DefaultSlot[] slots;
    private Menu.CloseHandler handler;
    private Menu.CursorDropHandler cursorDropHandler;
    private final Set<MenuHolder> holders = new HashSet<MenuHolder>();
    protected String inventoryTitle;
    protected int inventorySlots;
    protected InventoryType inventoryType;

    protected AbstractMenu(String title, int inventorySlots, Menu parent, boolean redraw) {
        if (title == null) {
            title = InventoryType.CHEST.getDefaultTitle();
        }
        this.inventoryTitle = title;
        this.inventorySlots = inventorySlots;
        this.parent = parent;
        this.redraw = redraw;
        this.generateSlots();
    }

    protected AbstractMenu(String title, InventoryType type, Menu parent, boolean redraw) {
        Objects.requireNonNull(type, "type cannot be null");
        if (title == null) {
            title = type.getDefaultTitle();
        }
        this.inventoryTitle = title;
        this.inventoryType = type;
        this.parent = parent;
        this.redraw = redraw;
        this.generateSlots();
    }

    protected void generateSlots() {
        this.slots = new DefaultSlot[this.getDimensions().getArea()];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = new DefaultSlot(this, i);
        }
    }

    @Override
    public Optional<Menu> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public boolean isRedraw() {
        return this.redraw;
    }

    @Override
    public void open(Player viewer) {
        InventoryHolder currentInventory = viewer.getOpenInventory().getTopInventory().getHolder();
        if (currentInventory instanceof MenuHolder) {
            Inventory inventory;
            MenuHolder holder = (MenuHolder)currentInventory;
            Menu open = holder.getMenu();
            if (open == this) {
                return;
            }
            if (this.isRedraw() && open.getDimensions().equals(this.getDimensions())) {
                inventory = holder.getInventory();
                ((AbstractMenu)open).closedByPlayer(viewer, false);
            } else {
                open.close(viewer);
                inventory = this.createInventory(holder);
                holder.setInventory(inventory);
                viewer.openInventory(inventory);
            }
            this.updateInventoryContents(viewer, inventory);
            holder.setMenu(this);
            this.holders.add(holder);
        } else {
            MenuHolder holder = new MenuHolder(viewer, this);
            Inventory inventory = this.createInventory(holder);
            this.updateInventoryContents(viewer, inventory);
            holder.setInventory(inventory);
            viewer.openInventory(inventory);
            this.holders.add(holder);
        }
    }

    private Inventory createInventory(InventoryHolder holder) {
        return this.inventoryType == null ? Bukkit.createInventory((InventoryHolder)holder, (int)this.inventorySlots, (String)this.inventoryTitle) : Bukkit.createInventory((InventoryHolder)holder, (InventoryType)this.inventoryType, (String)this.inventoryTitle);
    }

    private void updateInventoryContents(Player viewer, Inventory inventory) {
        for (DefaultSlot slot : this.slots) {
            inventory.setItem(slot.getIndex(), slot.getItem(viewer));
        }
        viewer.updateInventory();
    }

    @Override
    public Collection<Player> getViewers() {
        return this.getHolders().stream().map(MenuHolder::getViewer).collect(Collectors.toSet());
    }

    @Override
    public boolean isOpen(Player viewer) {
        InventoryHolder currentInventory = viewer.getOpenInventory().getTopInventory().getHolder();
        return currentInventory instanceof MenuHolder && ((MenuHolder)currentInventory).getMenu() == this;
    }

    @Override
    public void close() {
        this.getViewers().forEach(this::close);
    }

    @Override
    public void close(Player viewer) {
        this.closedByPlayer(viewer, true);
        viewer.closeInventory();
    }

    @Override
    public void update() {
        this.getViewers().forEach(this::update);
    }

    @Override
    public void update(Player viewer) throws IllegalStateException {
        if (!this.isOpen(viewer)) {
            return;
        }
        InventoryHolder openInventory = viewer.getOpenInventory().getTopInventory().getHolder();
        this.updateInventoryContents(viewer, openInventory.getInventory());
    }

    public void closedByPlayer(Player viewer, boolean triggerCloseHandler) {
        if (!this.isOpen(viewer)) {
            return;
        }
        MenuHolder holder = (MenuHolder)viewer.getOpenInventory().getTopInventory().getHolder();
        this.holders.remove(holder);
        if (triggerCloseHandler) {
            this.getCloseHandler().ifPresent(h -> h.close(viewer, this));
        }
    }

    public Set<MenuHolder> getHolders() {
        return Collections.unmodifiableSet(this.holders);
    }

    @Override
    public List<Slot> getSlots() {
        return Arrays.asList(this.slots);
    }

    @Override
    public List<Slot> getSlots(Mask mask) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        mask.getSlots().forEach(idx -> slots.add(this.getSlot((int)idx)));
        return slots;
    }

    @Override
    public Slot getSlot(int index) {
        return this.slots[index];
    }

    @Override
    public Slot getSlot(int row, int column) {
        int columns = this.getDimensions().getColumns();
        int firstRowIndex = (row - 1) * columns;
        int index = firstRowIndex + column - 1;
        return this.getSlot(index);
    }

    @Override
    public Iterator<Slot> iterator() {
        return new ArrayIterator<Slot>(this.slots);
    }

    @Override
    public void clear() {
        for (DefaultSlot slot : this.slots) {
            slot.setItem((ItemStack)null);
        }
    }

    @Override
    public void clear(int index) {
        Slot slot = this.getSlot(index);
        slot.setItem((ItemStack)null);
    }

    @Override
    public void setCloseHandler(Menu.CloseHandler handler) {
        this.handler = handler;
    }

    @Override
    public Optional<Menu.CloseHandler> getCloseHandler() {
        return Optional.ofNullable(this.handler);
    }

    @Override
    public Optional<Menu.CursorDropHandler> getCursorDropHandler() {
        return Optional.ofNullable(this.cursorDropHandler);
    }

    @Override
    public void setCursorDropHandler(Menu.CursorDropHandler handler) {
        this.cursorDropHandler = handler;
    }

    public static abstract class Builder<T extends Builder<T>>
    implements Menu.Builder<T> {
        private final Menu.Dimension dimensions;
        private String title;
        private Menu parent;
        private boolean redraw;

        public Builder(Menu.Dimension dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public Menu.Dimension getDimensions() {
            return this.dimensions;
        }

        @Override
        public T title(String title) {
            this.title = title;
            return (T)this;
        }

        @Override
        public T parent(Menu parent) {
            this.parent = parent;
            return (T)this;
        }

        @Override
        public T redraw(boolean redraw) {
            this.redraw = redraw;
            return (T)this;
        }

        public String getTitle() {
            return this.title;
        }

        public Menu getParent() {
            return this.parent;
        }

        public boolean isRedraw() {
            return this.redraw;
        }
    }
}

