/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.slot;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.slot.ClickOptions;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.slot.SlotSettings;
import org.ipvp.canvas.template.ItemStackTemplate;
import org.ipvp.canvas.template.StaticItemTemplate;
import org.ipvp.canvas.type.AbstractMenu;
import org.ipvp.canvas.type.MenuHolder;

public class DefaultSlot
implements Slot {
    private final AbstractMenu handle;
    private final int index;
    private ItemStackTemplate item;
    private ClickOptions options;
    private Slot.ClickHandler handler;

    public DefaultSlot(AbstractMenu handle, int index) {
        this(handle, index, ClickOptions.DENY_ALL);
    }

    public DefaultSlot(AbstractMenu handle, int index, ClickOptions options) {
        this(handle, index, options, null);
    }

    private DefaultSlot(AbstractMenu handle, int index, ClickOptions options, Slot.ClickHandler handler) {
        Objects.requireNonNull(handle);
        this.handle = handle;
        this.index = index;
        this.setClickOptions(options);
        this.handler = handler;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public ClickOptions getClickOptions() {
        return this.options;
    }

    @Override
    public void setClickOptions(ClickOptions options) {
        Objects.requireNonNull(options);
        this.options = options;
    }

    @Override
    public ItemStack getItem() {
        if (this.item instanceof StaticItemTemplate) {
            return ((StaticItemTemplate)this.item).getItem();
        }
        throw new UnsupportedOperationException("Cannot get item from template");
    }

    @Override
    public ItemStack getItem(Player viewer) {
        return this.item == null ? null : this.item.getItem(viewer);
    }

    @Override
    public void setItem(ItemStack item) {
        this.setItemTemplate(new StaticItemTemplate(item));
    }

    @Override
    public void setItem(Supplier<ItemStack> item) {
        this.setItem(item.get());
    }

    @Override
    public void setItemTemplate(ItemStackTemplate item) {
        this.item = item;
        this.handle.getHolders().forEach(v -> {
            Inventory inventory = v.getInventory();
            inventory.setItem(this.index, this.getItem(v.getViewer()));
        });
    }

    @Override
    public ItemStack getRawItem(Player viewer) {
        if (!this.handle.isOpen(viewer)) {
            throw new IllegalStateException("Player not viewing parent menu");
        }
        MenuHolder menu = (MenuHolder)viewer.getOpenInventory().getTopInventory().getHolder();
        return menu.getInventory().getItem(this.getIndex());
    }

    @Override
    public void setRawItem(Player viewer, ItemStack item) {
        Optional<MenuHolder> menu = this.handle.getHolders().stream().filter(v -> v.getViewer().equals(viewer)).findFirst();
        if (!menu.isPresent()) {
            throw new IllegalStateException("Player not viewing parent menu");
        }
        menu.get().getInventory().setItem(this.getIndex(), item);
    }

    @Override
    public Optional<Slot.ClickHandler> getClickHandler() {
        return Optional.ofNullable(this.handler);
    }

    @Override
    public void setClickHandler(Slot.ClickHandler handler) {
        this.handler = handler;
    }

    @Override
    public SlotSettings getSettings() {
        return new SlotSettings(this.options, this.handler, this.item);
    }

    @Override
    public void setSettings(SlotSettings settings) {
        this.setItemTemplate(settings.getItemTemplate());
        this.setClickHandler(settings.getClickHandler());
        if (settings.getClickOptions() != null) {
            this.setClickOptions(settings.getClickOptions());
        }
    }
}

