/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.slot;

import java.util.EnumSet;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;

public class ClickOptions {
    public static ClickOptions ALLOW_ALL = ClickOptions.builder().allActions().allClickTypes().build();
    public static ClickOptions DENY_ALL = ClickOptions.builder().build();
    private EnumSet<InventoryAction> allowedActions;
    private EnumSet<ClickType> allowedClickTypes;

    private ClickOptions() {
    }

    public boolean isAllowedAction(InventoryAction action) {
        return this.allowedActions.contains(action);
    }

    public boolean isAllowedClickType(ClickType clickType) {
        return this.allowedClickTypes.contains(clickType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private EnumSet<InventoryAction> allowedActions = EnumSet.noneOf(InventoryAction.class);
        private EnumSet<ClickType> allowedClickTypes = EnumSet.noneOf(ClickType.class);

        private Builder() {
        }

        public Builder allActions() {
            this.allowedActions = EnumSet.allOf(InventoryAction.class);
            return this;
        }

        public Builder allClickTypes() {
            this.allowedClickTypes = EnumSet.allOf(ClickType.class);
            return this;
        }

        public Builder allow(InventoryAction action) {
            this.allowedActions.add(action);
            return this;
        }

        public Builder allow(InventoryAction ... actions) {
            for (InventoryAction action : actions) {
                this.allow(action);
            }
            return this;
        }

        public Builder allow(ClickType clickType) {
            this.allowedClickTypes.add(clickType);
            return this;
        }

        public Builder allow(ClickType ... clickTypes) {
            for (ClickType type : clickTypes) {
                this.allow(type);
            }
            return this;
        }

        public ClickOptions build() {
            ClickOptions options = new ClickOptions();
            options.allowedActions = this.allowedActions;
            options.allowedClickTypes = this.allowedClickTypes;
            return options;
        }
    }
}

