/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.paginate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.mask.Mask;
import org.ipvp.canvas.paginate.AbstractPaginatedMenuBuilder;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.slot.SlotSettings;
import org.ipvp.canvas.template.ItemStackTemplate;
import org.ipvp.canvas.template.StaticItemTemplate;

public class PaginatedMenuBuilder
extends AbstractPaginatedMenuBuilder<PaginatedMenuBuilder> {
    private Mask slots;
    private List<SlotSettings> items = new ArrayList<SlotSettings>();

    private PaginatedMenuBuilder(Menu.Builder<?> pageBuilder) {
        super(pageBuilder);
    }

    public PaginatedMenuBuilder slots(Mask slots) {
        this.slots = slots;
        return this;
    }

    public PaginatedMenuBuilder addItem(ItemStack item) {
        return this.addItem(new StaticItemTemplate(item));
    }

    public PaginatedMenuBuilder addItem(ItemStackTemplate item) {
        return this.addItem(SlotSettings.builder().itemTemplate(item).build());
    }

    public PaginatedMenuBuilder addItem(SlotSettings item) {
        this.items.add(item);
        return this;
    }

    public PaginatedMenuBuilder addItems(Collection<ItemStack> items) {
        items.forEach(this::addItem);
        return this;
    }

    public PaginatedMenuBuilder addItemTemplates(Collection<ItemStackTemplate> items) {
        items.forEach(this::addItem);
        return this;
    }

    public PaginatedMenuBuilder addSlotSettings(Collection<SlotSettings> slotSettings) {
        slotSettings.forEach(this::addItem);
        return this;
    }

    public List<Menu> build() {
        ArrayList<Menu> pages = new ArrayList<Menu>();
        ArrayList<SlotSettings> items = new ArrayList<SlotSettings>(this.items);
        do {
            Menu page = this.getPageBuilder().build();
            if (!this.getNewMenuModifiers().isEmpty()) {
                for (Consumer<Menu> menuModifier : this.getNewMenuModifiers()) {
                    menuModifier.accept(page);
                }
            }
            List<Integer> validSlots = this.getValidSlots(page);
            this.setPaginationIcon(page, this.getPreviousButtonSlot(), this.getPreviousButtonEmpty());
            this.setPaginationIcon(page, this.getNextButtonSlot(), this.getNextButtonEmpty());
            Iterator<Integer> slotIterator = validSlots.iterator();
            while (!items.isEmpty() && slotIterator.hasNext()) {
                int slotIndex = slotIterator.next();
                if (page.getDimensions().getArea() <= slotIndex) continue;
                SlotSettings item = (SlotSettings)items.remove(0);
                Slot slot = page.getSlot(slotIndex);
                slot.setSettings(item);
            }
            pages.add(page);
        } while (!items.isEmpty());
        this.linkPages(pages);
        return pages;
    }

    private List<Integer> getValidSlots(Menu menu) {
        ArrayList<Integer> valid = new ArrayList<Integer>();
        if (this.slots != null) {
            Iterator iterator = this.slots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= menu.getDimensions().getArea()) continue;
                valid.add(slot);
            }
        }
        return valid;
    }

    public static PaginatedMenuBuilder builder(Menu.Builder<?> pageBuilder) {
        if (pageBuilder == null) {
            throw new IllegalArgumentException("Menu builder cannot be null");
        }
        return new PaginatedMenuBuilder(pageBuilder);
    }
}

