/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.paginate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.mask.Mask;
import org.ipvp.canvas.paginate.AbstractPaginatedMenuBuilder;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.slot.SlotSettings;
import org.ipvp.canvas.template.ItemStackTemplate;
import org.ipvp.canvas.template.StaticItemTemplate;

public class MultiSectionPaginatedMenuBuilder
extends AbstractPaginatedMenuBuilder<MultiSectionPaginatedMenuBuilder> {
    private Map<Character, Mask> sectionSlots = new HashMap<Character, Mask>();
    private Map<Character, List<SlotSettings>> sectionItems = new HashMap<Character, List<SlotSettings>>();

    private MultiSectionPaginatedMenuBuilder(Menu.Builder<?> pageBuilder) {
        super(pageBuilder);
    }

    public MultiSectionPaginatedMenuBuilder slots(char character, Mask slots) {
        this.sectionSlots.put(Character.valueOf(character), slots);
        return this;
    }

    public MultiSectionPaginatedMenuBuilder addItem(char character, ItemStack item) {
        return this.addItem(character, new StaticItemTemplate(item));
    }

    public MultiSectionPaginatedMenuBuilder addItem(char character, ItemStackTemplate item) {
        return this.addItem(character, SlotSettings.builder().itemTemplate(item).build());
    }

    public MultiSectionPaginatedMenuBuilder addItem(char character, SlotSettings item) {
        List currentItems = this.sectionItems.compute(Character.valueOf(character), (k, v) -> v == null ? new ArrayList() : v);
        currentItems.add(item);
        return this;
    }

    public MultiSectionPaginatedMenuBuilder addItems(char character, Collection<ItemStack> items) {
        items.forEach(i -> this.addItem(character, (ItemStack)i));
        return this;
    }

    public MultiSectionPaginatedMenuBuilder addItemTemplates(char character, Collection<ItemStackTemplate> items) {
        items.forEach(i -> this.addItem(character, (ItemStackTemplate)i));
        return this;
    }

    public MultiSectionPaginatedMenuBuilder addSlotSettings(char character, Collection<SlotSettings> slotSettings) {
        slotSettings.forEach(s -> this.addItem(character, (SlotSettings)s));
        return this;
    }

    public List<Menu> build() {
        ArrayList<Menu> pages = new ArrayList<Menu>();
        HashMap sectionItems = new HashMap();
        this.sectionItems.forEach((c, l) -> {
            List cfr_ignored_0 = sectionItems.put(c, new ArrayList(l));
        });
        boolean requiresPage = false;
        do {
            Menu page = this.getPageBuilder().build();
            if (!this.getNewMenuModifiers().isEmpty()) {
                for (Consumer<Menu> consumer : this.getNewMenuModifiers()) {
                    consumer.accept(page);
                }
            }
            this.setPaginationIcon(page, this.getPreviousButtonSlot(), this.getPreviousButtonEmpty());
            this.setPaginationIcon(page, this.getNextButtonSlot(), this.getNextButtonEmpty());
            for (Map.Entry entry : sectionItems.entrySet()) {
                List items = (List)entry.getValue();
                Mask slots = this.sectionSlots.get(entry.getKey());
                Iterator slotIterator = slots.iterator();
                while (!items.isEmpty() && slotIterator.hasNext()) {
                    int slotIndex = (Integer)slotIterator.next();
                    if (slotIndex < 0 || page.getDimensions().getArea() <= slotIndex) continue;
                    SlotSettings item = (SlotSettings)items.remove(0);
                    Slot slot = page.getSlot(slotIndex);
                    slot.setSettings(item);
                }
                requiresPage = requiresPage || !items.isEmpty();
            }
            pages.add(page);
        } while (requiresPage);
        this.linkPages(pages);
        return pages;
    }

    public static MultiSectionPaginatedMenuBuilder builder(Menu.Builder<?> pageBuilder) {
        if (pageBuilder == null) {
            throw new IllegalArgumentException("Menu builder cannot be null");
        }
        return new MultiSectionPaginatedMenuBuilder(pageBuilder);
    }
}

