/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.mask;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.mask.Mask;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.slot.SlotSettings;
import org.ipvp.canvas.template.ItemStackTemplate;
import org.ipvp.canvas.template.StaticItemTemplate;

public class RecipeMask
implements Mask {
    private final Menu.Dimension dimension;
    private Map<Integer, Character> mask;
    private Map<Character, SlotSettings> settings;

    protected RecipeMask(Menu.Dimension dimension, Map<Integer, Character> mask, Map<Character, SlotSettings> settings) {
        this.dimension = dimension;
        this.mask = Collections.unmodifiableMap(mask);
        this.settings = Collections.unmodifiableMap(settings);
    }

    @Override
    public Collection<Integer> getSlots() {
        return this.mask.keySet();
    }

    @Override
    public Menu.Dimension getDimensions() {
        return this.dimension;
    }

    @Override
    public boolean contains(int index) {
        return this.mask.containsKey(index);
    }

    @Override
    public boolean contains(int row, int column) {
        int columns = this.getDimensions().getColumns();
        int firstRowIndex = (row - 1) * columns;
        int index = firstRowIndex + column - 1;
        return this.contains(index);
    }

    @Override
    public void apply(Menu menu) {
        this.mask.forEach((? super K slot, ? super V character) -> {
            SlotSettings settings = this.settings.get(character);
            if (settings != null) {
                Slot affected = menu.getSlot((int)slot);
                affected.setSettings(settings);
            }
        });
    }

    @Override
    public boolean test(int index) {
        return this.contains(index);
    }

    @Override
    public boolean test(int row, int col) {
        return this.contains(row, col);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.mask.keySet().iterator();
    }

    public static RecipeMaskBuilder builder(Menu menu) {
        return RecipeMask.builder(menu.getDimensions());
    }

    public static RecipeMaskBuilder builder(Menu.Dimension dimensions) {
        return new RecipeMaskBuilder(dimensions);
    }

    public static RecipeMaskBuilder builder(int rows, int cols) {
        return RecipeMask.builder(new Menu.Dimension(rows, cols));
    }

    public static class RecipeMaskBuilder
    implements Mask.Builder {
        private Menu.Dimension dimensions;
        private int row;
        private char[][] mask;
        private Map<Character, SlotSettings> settings = new HashMap<Character, SlotSettings>();

        protected RecipeMaskBuilder(Menu.Dimension dimensions) {
            this.dimensions = dimensions;
            this.mask = new char[dimensions.getRows()][dimensions.getColumns()];
        }

        @Override
        public int currentLine() {
            return this.row;
        }

        @Override
        public int rows() {
            return this.dimensions.getRows();
        }

        @Override
        public int columns() {
            return this.dimensions.getColumns();
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public RecipeMaskBuilder row(int row) throws IllegalStateException {
            if (row < 1 || row > this.dimensions.getRows()) {
                throw new IllegalStateException("Row must be a value from 1 to " + this.rows());
            }
            this.row = row - 1;
            return this;
        }

        public RecipeMaskBuilder item(char character, ItemStack item) {
            return this.item(character, item == null ? null : new StaticItemTemplate(item));
        }

        public RecipeMaskBuilder item(char character, ItemStackTemplate item) {
            return this.item(character, SlotSettings.builder().itemTemplate(item).build());
        }

        public RecipeMaskBuilder item(char character, SlotSettings settings) {
            if (settings == null) {
                this.settings.remove(Character.valueOf(character));
            } else {
                this.settings.put(Character.valueOf(character), settings);
            }
            return this;
        }

        @Override
        public RecipeMaskBuilder nextRow() throws IllegalStateException {
            if (this.row == this.mask.length) {
                throw new IllegalStateException("Current line is the last row");
            }
            ++this.row;
            return this;
        }

        @Override
        public RecipeMaskBuilder previousRow() throws IllegalStateException {
            if (this.row == 0) {
                throw new IllegalStateException("Current line is the first row");
            }
            --this.row;
            return this;
        }

        @Override
        public RecipeMaskBuilder apply(String pattern) {
            char[] chars = pattern.toCharArray();
            for (int i = 0; i < this.dimensions.getColumns() && i < chars.length; ++i) {
                this.mask[this.row][i] = chars[i];
            }
            return this;
        }

        @Override
        public RecipeMaskBuilder pattern(String pattern) {
            this.apply(pattern);
            if (this.row() != this.mask.length) {
                this.nextRow();
            }
            return this;
        }

        @Override
        public RecipeMask build() {
            HashMap<Integer, Character> slots = new HashMap<Integer, Character>();
            for (int r = 0; r < this.dimensions.getRows(); ++r) {
                for (int c = 0; c < this.dimensions.getColumns(); ++c) {
                    char character = this.mask[r][c];
                    slots.put(r * this.columns() + c, Character.valueOf(character));
                }
            }
            return new RecipeMask(this.dimensions, slots, this.settings);
        }
    }
}

