/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.ipvp.canvas.CursorDropInformation;
import org.ipvp.canvas.mask.Mask;
import org.ipvp.canvas.slot.Slot;

public interface Menu
extends Iterable<Slot> {
    public static final CursorDropHandler ALLOW_CURSOR_DROPPING = (p, c) -> c.setResult(Event.Result.ALLOW);

    public Optional<Menu> getParent();

    public boolean isRedraw();

    public Collection<Player> getViewers();

    public boolean isOpen(Player var1);

    public void open(Player var1);

    public void close();

    public void close(Player var1) throws IllegalStateException;

    public void update();

    public void update(Player var1) throws IllegalStateException;

    public List<Slot> getSlots();

    public List<Slot> getSlots(Mask var1);

    public Slot getSlot(int var1);

    public Slot getSlot(int var1, int var2);

    public void clear();

    public void clear(int var1);

    public Dimension getDimensions();

    public Optional<CloseHandler> getCloseHandler();

    public void setCloseHandler(CloseHandler var1);

    public Optional<CursorDropHandler> getCursorDropHandler();

    public void setCursorDropHandler(CursorDropHandler var1);

    public static class Dimension {
        private final int rows;
        private final int columns;

        public Dimension(int rows, int columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public int getRows() {
            return this.rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getArea() {
            return this.rows * this.columns;
        }

        public int hashCode() {
            return this.rows * 31 + this.columns * 31;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Dimension)) {
                return false;
            }
            Dimension o = (Dimension)other;
            return o.rows == this.rows && o.columns == this.columns;
        }
    }

    public static interface Builder<T extends Builder<T>> {
        public Dimension getDimensions();

        public T title(String var1);

        public T parent(Menu var1);

        public T redraw(boolean var1);

        public Menu build();
    }

    @FunctionalInterface
    public static interface CursorDropHandler {
        public void click(Player var1, CursorDropInformation var2);
    }

    @FunctionalInterface
    public static interface CloseHandler {
        public void close(Player var1, Menu var2);
    }
}

