/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas;

import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.slot.Slot;

public class ClickInformation {
    private final InventoryInteractEvent handle;
    private final InventoryAction inventoryAction;
    private final ClickType clickType;
    private final Inventory clicked;
    private final Menu clickedMenu;
    private final Slot clickedSlot;
    private final ItemStack addingItem;
    private Event.Result result;

    ClickInformation(InventoryInteractEvent handle, InventoryAction inventoryAction, ClickType clickType, Inventory clicked, Menu clickedMenu, Slot clickedSlot, Event.Result result) {
        this(handle, inventoryAction, clickType, clicked, clickedMenu, clickedSlot, result, null);
    }

    ClickInformation(InventoryInteractEvent handle, InventoryAction inventoryAction, ClickType clickType, Inventory clicked, Menu clickedMenu, Slot clickedSlot, Event.Result result, ItemStack addingItem) {
        this.handle = handle;
        this.inventoryAction = inventoryAction;
        this.clickType = clickType;
        this.clicked = clicked;
        this.clickedMenu = clickedMenu;
        this.clickedSlot = clickedSlot;
        this.result = result;
        this.addingItem = addingItem;
    }

    public Menu getClickedMenu() {
        return this.clickedMenu;
    }

    public Slot getClickedSlot() {
        return this.clickedSlot;
    }

    public InventoryAction getAction() {
        return this.inventoryAction;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    public Event.Result getResult() {
        return this.result;
    }

    public void setResult(Event.Result result) {
        Objects.requireNonNull(result);
        this.result = result;
    }

    public boolean isAddingItem() {
        switch (this.getAction()) {
            case PLACE_ALL: 
            case PLACE_SOME: 
            case PLACE_ONE: 
            case SWAP_WITH_CURSOR: 
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: {
                return true;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                return this.handle.getView().getBottomInventory() == this.clicked;
            }
        }
        return false;
    }

    public ItemStack getAddingItem() {
        if (!this.isAddingItem()) {
            throw new IllegalStateException("Not adding item");
        }
        if (this.addingItem != null) {
            return new ItemStack(this.addingItem);
        }
        if (this.handle instanceof InventoryDragEvent) {
            InventoryDragEvent event = (InventoryDragEvent)this.handle;
            return (ItemStack)event.getNewItems().get(this.clickedSlot.getIndex());
        }
        InventoryClickEvent clickEvent = (InventoryClickEvent)this.handle;
        switch (clickEvent.getAction()) {
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: {
                int hotbarSlot = clickEvent.getHotbarButton();
                return clickEvent.getView().getBottomInventory().getItem(hotbarSlot);
            }
            case MOVE_TO_OTHER_INVENTORY: {
                return clickEvent.getCurrentItem();
            }
        }
        return clickEvent.getCursor();
    }

    public int getAddingItemAmount() {
        if (!this.isAddingItem()) {
            return -1;
        }
        switch (this.getAction()) {
            case PLACE_ONE: {
                return 1;
            }
            case PLACE_SOME: {
                ItemStack current = this.getRawItem();
                int limit = current == null ? 64 : current.getType().getMaxStackSize();
                return Math.min(limit, this.getAddingItem().getAmount());
            }
            case PLACE_ALL: 
            case SWAP_WITH_CURSOR: 
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: 
            case MOVE_TO_OTHER_INVENTORY: {
                return this.getAddingItem().getAmount();
            }
        }
        return -1;
    }

    public boolean isTakingItem() {
        switch (this.getAction()) {
            case SWAP_WITH_CURSOR: 
            case PICKUP_ALL: 
            case PICKUP_HALF: 
            case PICKUP_ONE: 
            case PICKUP_SOME: {
                return true;
            }
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: 
            case MOVE_TO_OTHER_INVENTORY: {
                return this.handle.getView().getTopInventory() == this.clicked;
            }
        }
        return this.isDroppingItem();
    }

    public ItemStack getTakingItem() {
        if (!this.isTakingItem()) {
            throw new IllegalStateException("An item is not being taken");
        }
        InventoryClickEvent clickEvent = (InventoryClickEvent)this.handle;
        return clickEvent.getCurrentItem();
    }

    public int getTakingItemAmount() {
        if (!this.isTakingItem()) {
            return -1;
        }
        switch (this.getAction()) {
            case PICKUP_ONE: 
            case DROP_ONE_SLOT: {
                return 1;
            }
            case PICKUP_HALF: {
                return (int)Math.ceil((double)this.getRawItem().getAmount() / 2.0);
            }
            case PICKUP_SOME: {
                return this.getRawItem().getMaxStackSize();
            }
            case SWAP_WITH_CURSOR: 
            case HOTBAR_SWAP: 
            case HOTBAR_MOVE_AND_READD: 
            case MOVE_TO_OTHER_INVENTORY: 
            case PICKUP_ALL: 
            case DROP_ALL_SLOT: {
                return this.getRawItem().getAmount();
            }
        }
        return -1;
    }

    @Deprecated
    public int getItemAmount() {
        switch (this.getAction()) {
            case PLACE_ALL: {
                return this.getAddingItem().getAmount();
            }
            case PLACE_SOME: {
                ItemStack current = this.getRawItem();
                int limit = current == null ? 64 : current.getType().getMaxStackSize();
                return Math.min(limit, this.getAddingItem().getAmount());
            }
            case PLACE_ONE: 
            case PICKUP_ONE: 
            case DROP_ONE_SLOT: {
                return 1;
            }
            case PICKUP_HALF: {
                return (int)Math.ceil((double)this.getRawItem().getAmount() / 2.0);
            }
            case PICKUP_ALL: 
            case DROP_ALL_SLOT: {
                return this.getRawItem().getAmount();
            }
            case MOVE_TO_OTHER_INVENTORY: {
                return this.isAddingItem() ? this.getAddingItem().getAmount() : this.getRawItem().getAmount();
            }
        }
        throw new UnsupportedOperationException();
    }

    private ItemStack getRawItem() {
        return this.getClickedSlot().getRawItem((Player)this.handle.getWhoClicked());
    }

    public boolean isDroppingItem() {
        switch (this.getAction()) {
            case DROP_ONE_SLOT: 
            case DROP_ALL_SLOT: {
                return true;
            }
        }
        return false;
    }
}

