/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.type;

import org.bukkit.event.inventory.InventoryType;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.type.AbstractMenu;

public class BoxMenu
extends AbstractMenu {
    protected BoxMenu(String title, InventoryType type, Menu menu, boolean redraw) {
        super(title, type, menu, redraw);
    }

    public static Builder builder(InventoryType type) {
        switch (type) {
            case WORKBENCH: 
            case DISPENSER: 
            case DROPPER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("box menu must have a 3x3 inventory type");
            }
        }
        return new Builder(type);
    }

    @Override
    public Menu.Dimension getDimensions() {
        return new Menu.Dimension(3, 3);
    }

    public static class Builder
    extends AbstractMenu.Builder<Builder> {
        private InventoryType type;

        Builder(InventoryType type) {
            super(new Menu.Dimension(3, 3));
            this.type = type;
        }

        @Override
        public BoxMenu build() {
            return new BoxMenu(this.getTitle(), this.type, this.getParent(), this.isRedraw());
        }
    }
}

