/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.mask;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.mask.Mask;

@Deprecated
public class Mask2D
implements Mask {
    private final Menu.Dimension dimension;
    private List<Integer> mask;

    Mask2D(Menu.Dimension dimension, List<Integer> mask) {
        this.dimension = dimension;
        this.mask = Collections.unmodifiableList(mask);
    }

    public List<Integer> getSlots() {
        return this.mask;
    }

    @Override
    public Menu.Dimension getDimensions() {
        return this.dimension;
    }

    @Override
    public boolean contains(int index) {
        return this.mask.contains(index);
    }

    @Override
    public boolean contains(int row, int column) {
        int columns = this.getDimensions().getColumns();
        int firstRowIndex = (row - 1) * columns;
        int index = firstRowIndex + column - 1;
        return this.contains(index);
    }

    @Override
    public void apply(Menu menu) {
    }

    @Override
    public boolean test(int index) {
        return this.contains(index);
    }

    @Override
    public boolean test(int row, int col) {
        return this.test(row * 9 + col);
    }

    public List<Integer> getMask() {
        return this.getSlots();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.mask.iterator();
    }

    public static Builder builder(Menu menu) {
        return Mask2D.builder(menu.getDimensions());
    }

    public static Builder builder(Menu.Dimension dimensions) {
        return new Builder(dimensions);
    }

    public static Builder builder(int rows, int cols) {
        return Mask2D.builder(new Menu.Dimension(rows, cols));
    }

    public static class Builder
    implements Mask.Builder {
        private Menu.Dimension dimensions;
        private int currentLine;
        private int rows;
        private int cols;
        private int[][] mask;

        public Builder(Menu.Dimension dimensions) {
            this.dimensions = dimensions;
            this.rows = dimensions.getRows();
            this.cols = dimensions.getColumns();
            this.mask = new int[this.rows][this.cols];
        }

        @Override
        public int currentLine() {
            return this.currentLine;
        }

        @Override
        public int rows() {
            return this.rows;
        }

        @Override
        public int columns() {
            return this.cols;
        }

        @Override
        public int row() {
            return this.currentLine;
        }

        @Override
        public Builder row(int row) throws IllegalStateException {
            if (row < 0 || row >= this.rows) {
                throw new IllegalStateException("row not between 0 and " + this.rows());
            }
            this.currentLine = row;
            return this;
        }

        @Override
        public Builder nextRow() throws IllegalStateException {
            if (this.currentLine == this.mask.length) {
                throw new IllegalStateException("already at end");
            }
            ++this.currentLine;
            return this;
        }

        @Override
        public Builder previousRow() throws IllegalStateException {
            if (this.currentLine == 0) {
                throw new IllegalStateException("already at start");
            }
            --this.currentLine;
            return this;
        }

        @Override
        public Builder apply(String pattern) {
            char[] chars = pattern.toCharArray();
            for (int i = 0; i < 9 && i < chars.length; ++i) {
                String ch = String.valueOf(chars[i]);
                int c = Integer.parseInt(ch);
                this.mask[this.currentLine][i] = Math.min(c, 1);
            }
            return this;
        }

        @Override
        public Mask.Builder pattern(String pattern) {
            this.apply(pattern);
            if (this.row() != this.mask.length) {
                this.nextRow();
            }
            return this;
        }

        @Override
        public Mask2D build() {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int r = 0; r < this.mask.length; ++r) {
                int[] col = this.mask[r];
                for (int c = 0; c < col.length; ++c) {
                    int state = col[c];
                    if (state != 1) continue;
                    slots.add(r * this.columns() + c);
                }
            }
            return new Mask2D(this.dimensions, slots);
        }
    }
}

