/*
 * Decompiled with CFR 0.152.
 */
package org.ipvp.canvas.mask;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.ipvp.canvas.Menu;
import org.ipvp.canvas.mask.Mask;
import org.ipvp.canvas.slot.Slot;
import org.ipvp.canvas.slot.SlotSettings;
import org.ipvp.canvas.template.ItemStackTemplate;
import org.ipvp.canvas.template.StaticItemTemplate;

public class BinaryMask
implements Mask {
    private final Menu.Dimension dimension;
    private List<Integer> mask;
    private SlotSettings settings;

    protected BinaryMask(Menu.Dimension dimension, List<Integer> mask, SlotSettings settings) {
        this.dimension = dimension;
        this.mask = Collections.unmodifiableList(mask);
        this.settings = settings;
    }

    public List<Integer> getSlots() {
        return this.mask;
    }

    @Override
    public Menu.Dimension getDimensions() {
        return this.dimension;
    }

    @Override
    public boolean contains(int index) {
        return this.mask.contains(index);
    }

    @Override
    public boolean contains(int row, int column) {
        int columns = this.getDimensions().getColumns();
        int firstRowIndex = (row - 1) * columns;
        int index = firstRowIndex + column - 1;
        return this.contains(index);
    }

    @Override
    public void apply(Menu menu) {
        Iterator iterator = this.getSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            Slot affected = menu.getSlot(slot);
            affected.setSettings(this.settings);
        }
    }

    @Override
    public boolean test(int index) {
        return this.contains(index);
    }

    @Override
    public boolean test(int row, int col) {
        return this.contains(row, col);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.mask.iterator();
    }

    public static BinaryMaskBuilder builder(Menu menu) {
        return BinaryMask.builder(menu.getDimensions());
    }

    public static BinaryMaskBuilder builder(Menu.Dimension dimensions) {
        return new BinaryMaskBuilder(dimensions);
    }

    public static BinaryMaskBuilder builder(int rows, int cols) {
        return BinaryMask.builder(new Menu.Dimension(rows, cols));
    }

    public static class BinaryMaskBuilder
    implements Mask.Builder {
        private Menu.Dimension dimensions;
        private int row;
        private int[][] mask;
        private SlotSettings settings;

        protected BinaryMaskBuilder(Menu.Dimension dimensions) {
            this.dimensions = dimensions;
            this.mask = new int[dimensions.getRows()][dimensions.getColumns()];
        }

        @Override
        public int currentLine() {
            return this.row;
        }

        @Override
        public int rows() {
            return this.dimensions.getRows();
        }

        @Override
        public int columns() {
            return this.dimensions.getColumns();
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public BinaryMaskBuilder row(int row) throws IllegalStateException {
            if (row < 1 || row > this.dimensions.getRows()) {
                throw new IllegalStateException("Row must be a value from 1 to " + this.rows());
            }
            this.row = row - 1;
            return this;
        }

        public BinaryMaskBuilder item(ItemStack item) {
            return this.item(item == null ? null : new StaticItemTemplate(item));
        }

        public BinaryMaskBuilder item(ItemStackTemplate item) {
            return this.item(SlotSettings.builder().itemTemplate(item).build());
        }

        public BinaryMaskBuilder item(SlotSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public BinaryMaskBuilder nextRow() throws IllegalStateException {
            if (this.row == this.mask.length) {
                throw new IllegalStateException("Current line is the last row");
            }
            ++this.row;
            return this;
        }

        @Override
        public BinaryMaskBuilder previousRow() throws IllegalStateException {
            if (this.row == 0) {
                throw new IllegalStateException("Current line is the first row");
            }
            --this.row;
            return this;
        }

        @Override
        public BinaryMaskBuilder apply(String pattern) {
            char[] chars = pattern.toCharArray();
            for (int i = 0; i < this.dimensions.getColumns() && i < chars.length; ++i) {
                char c = chars[i];
                this.mask[this.row][i] = c == '1' ? 1 : 0;
            }
            return this;
        }

        @Override
        public BinaryMaskBuilder pattern(String pattern) {
            this.apply(pattern);
            if (this.row() != this.mask.length) {
                this.nextRow();
            }
            return this;
        }

        @Override
        public BinaryMask build() {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int r = 0; r < this.dimensions.getRows(); ++r) {
                for (int c = 0; c < this.dimensions.getColumns(); ++c) {
                    int state = this.mask[r][c];
                    if (state != 1) continue;
                    slots.add(r * this.columns() + c);
                }
            }
            return new BinaryMask(this.dimensions, slots, this.settings);
        }
    }
}

