/*
 * Decompiled with CFR 0.152.
 */
package dev.noah.perplayerkit.commands;

import dev.noah.perplayerkit.KitManager;
import dev.noah.perplayerkit.gui.GUI;
import dev.noah.perplayerkit.util.BroadcastManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectEcCommand
implements CommandExecutor,
TabCompleter {
    private static final int MIN_SLOT = 1;
    private static final int MAX_SLOT = 9;
    private static final MiniMessage mm = MiniMessage.miniMessage();
    private static final Component ERROR_PREFIX = mm.deserialize("<red>Error:</red> ");
    private final Plugin plugin;

    public InspectEcCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        int slot;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ERROR_PREFIX.append((Component)mm.deserialize("<red>This command can only be executed by players.</red>")).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("perplayerkit.inspect")) {
            BroadcastManager.get().sendComponentMessage(player, ERROR_PREFIX.append((Component)mm.deserialize("<red>You don't have permission to use this command.</red>")));
            return true;
        }
        if (args.length < 2) {
            this.showUsage(player);
            return true;
        }
        UUID targetUuid = this.resolvePlayerIdentifier(args[0]);
        if (targetUuid == null) {
            BroadcastManager.get().sendComponentMessage(player, ERROR_PREFIX.append((Component)mm.deserialize("<red>Could not find a player with that name or UUID.</red>")));
            return true;
        }
        try {
            slot = Integer.parseInt(args[1]);
            if (slot < 1 || slot > 9) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            BroadcastManager.get().sendComponentMessage(player, ERROR_PREFIX.append((Component)mm.deserialize("<red>Slot must be a number between 1 and 9.</red>")));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((UUID)targetUuid);
        CompletionStage future = CompletableFuture.runAsync(() -> {
            if (targetPlayer == null) {
                KitManager.get().loadPlayerDataFromDB(targetUuid);
            }
        }).thenRun(() -> Bukkit.getScheduler().runTask(this.plugin, () -> {
            if (KitManager.get().hasEC(targetUuid, slot)) {
                GUI gui = new GUI(this.plugin);
                gui.InspectEc(player, targetUuid, slot);
            } else {
                String targetName = this.getPlayerName(targetUuid);
                BroadcastManager.get().sendComponentMessage(player, ERROR_PREFIX.append((Component)mm.deserialize("<red>" + targetName + " does not have an enderchest in slot " + slot + "</red>")));
            }
        }));
        ((CompletableFuture)future).exceptionally(ex -> {
            Bukkit.getScheduler().runTask(this.plugin, () -> {
                this.plugin.getLogger().severe("Error loading enderchest data: " + ex.getMessage());
                BroadcastManager.get().sendComponentMessage(player, ERROR_PREFIX.append((Component)mm.deserialize("<red>An error occurred while loading enderchest data. See console for details.</red>")));
            });
            return null;
        });
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player) || !sender.hasPermission("perplayerkit.inspect")) {
            return List.of();
        }
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>(Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).filter(name -> name.toLowerCase().startsWith(input)).toList());
            if (input.length() >= 4 && input.contains("-")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getUniqueId).map(UUID::toString).filter(uuid -> uuid.startsWith(input)).toList());
            }
            return completions;
        }
        if (args.length == 2) {
            return IntStream.rangeClosed(1, 9).mapToObj(String::valueOf).filter(slot -> slot.startsWith(args[1])).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private UUID resolvePlayerIdentifier(String identifier) {
        try {
            return UUID.fromString(identifier);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Player onlinePlayer = Bukkit.getPlayerExact((String)identifier);
            if (onlinePlayer != null) {
                return onlinePlayer.getUniqueId();
            }
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                if (!identifier.equalsIgnoreCase(offlinePlayer.getName())) continue;
                return offlinePlayer.getUniqueId();
            }
            return null;
        }
    }

    private String getPlayerName(UUID uuid) {
        Player onlinePlayer = Bukkit.getPlayer((UUID)uuid);
        if (onlinePlayer != null) {
            return onlinePlayer.getName();
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
        String name = offlinePlayer.getName();
        return name != null ? name : uuid.toString();
    }

    private void showUsage(Player player) {
        BroadcastManager.get().sendComponentMessage(player, ERROR_PREFIX.append((Component)mm.deserialize("<red>Usage: /inspectec <player|uuid> <slot></red>")));
    }
}

