/*
 * Decompiled with CFR 0.152.
 */
package net.nando256.whiteboard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.nando256.whiteboard.TextEntry;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

final class WhiteboardRenderer
extends MapRenderer {
    private final BufferedImage buffer = new BufferedImage(128, 128, 2);
    private final List<TextEntry> texts = new ArrayList<TextEntry>();
    private Color background = Color.WHITE;
    private boolean border = true;
    private volatile boolean dirty = true;
    private Font baseFont = new Font("Noto Sans CJK JP", 0, 16);

    WhiteboardRenderer() {
        super(true);
    }

    void setBackground(Color c) {
        this.background = c;
        this.dirty = true;
    }

    void setBorderVisible(boolean v) {
        this.border = v;
        this.dirty = true;
    }

    void addText(TextEntry te) {
        this.texts.add(te);
        this.dirty = true;
    }

    void clearTexts() {
        this.texts.clear();
        this.dirty = true;
    }

    void resetToDefaults() {
        this.background = Color.WHITE;
        this.border = true;
        this.texts.clear();
        this.dirty = true;
    }

    void setBaseFont(Font f) {
        if (f != null) {
            this.baseFont = f;
        }
        this.dirty = true;
    }

    Font getBaseFont() {
        return this.baseFont;
    }

    void requestRedraw() {
        this.dirty = true;
    }

    void removeByActionId(UUID id) {
        if (id == null) {
            return;
        }
        this.texts.removeIf(te -> id.equals(te.actionId));
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(MapView view, MapCanvas canvas, Player player) {
        if (this.dirty) {
            Graphics2D g = (Graphics2D)this.buffer.getGraphics();
            try {
                g.setColor(this.background);
                g.fillRect(0, 0, 128, 128);
                if (this.border) {
                    g.setColor(new Color(0x404040));
                    g.fillRect(0, 0, 128, 2);
                    g.fillRect(0, 126, 128, 2);
                    g.fillRect(0, 0, 2, 128);
                    g.fillRect(126, 0, 2, 128);
                }
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                for (TextEntry te : this.texts) {
                    g.setFont(this.baseFont.deriveFont((float)te.size));
                    g.setColor(te.color);
                    g.drawString(te.text, te.x, te.y);
                }
            }
            finally {
                g.dispose();
            }
            this.dirty = false;
        }
        canvas.drawImage(0, 0, (Image)this.buffer);
    }
}

