/*
 * Decompiled with CFR 0.152.
 */
package net.nando256.whiteboard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

final class Messages {
    private static final Map<String, String> DEFAULT_MESSAGES = Map.ofEntries(Map.entry("error.generic", "&cError: check the server log."), Map.entry("cmd.grid.usage", "&e/whiteboard grid <WxH>"), Map.entry("cmd.grid.tip", "&7Look at the top-left frame when running the command (it becomes [1,1])."), Map.entry("error.targetFrame", "&cAim at the top-left frame."), Map.entry("error.noFrames", "&cCould not find enough item frames nearby."), Map.entry("error.missingFrames", "&cNot enough frames at the required positions."), Map.entry("error.autoPlace", "&cFailed to place a frame at ({0},{1}). You need a solid block behind it."), Map.entry("board.init.book", "&aInitialised board via book: {0}x{1}."), Map.entry("board.init.command", "&aCreated board: {0}x{1} (top-left is [1,1], lock=ON)."), Map.entry("board.help.commands", "&7Text: /whiteboard text, HTML: /whiteboard htext, BG: /whiteboard bg, Clear: /whiteboard clear"), Map.entry("board.autoPlaced", "&7Automatically placed {0} missing frames."), Map.entry("book.extraTokens", "&eIgnored unknown arguments: {0}"), Map.entry("book.html.defaultMode", "&7Rendering the book as HTML. Add [text] at the beginning to force plain mode."), Map.entry("book.clear", "&7Cleared the board as instructed in the book ({0} tiles)."), Map.entry("book.noText", "&eNo renderable text found."), Map.entry("book.added", "&aAdded {0} items. (/whiteboard undo to revert)"), Map.entry("book.html.empty", "&eHTML parsing produced no drawable content."), Map.entry("book.html.added", "&aAdded HTML content. (/whiteboard undo to revert)"), Map.entry("book.text.added", "&aAdded text. (/whiteboard undo to revert)"), Map.entry("usage.htext", "&e/whiteboard htext <html> <size> <#RRGGBB> <x> <y> [lineH]"), Map.entry("usage.htext.book", "&e/whiteboard htext book <size> <x> <y> [lineH]"), Map.entry("usage.htext.colorTip", "&7Use <font color=...> or style=\"color:\" in HTML to set colours."), Map.entry("usage.htext.bookTip", "&7Book variant allows omitting size/color/coords (defaults 16, black, 0,0)."), Map.entry("usage.book.modeTip", "&7Add [text] / [plain] to force plain rendering at the top of the book."), Map.entry("usage.text", "&e/whiteboard text <msg> <size> <#RRGGBB> <x> <y>"), Map.entry("usage.text.book", "&e/whiteboard text book <size> <#RRGGBB> <x> <y> [lineH]"), Map.entry("usage.text.modeTip", "&7Use [text]/[plain] or [html]/[htext] to choose book render mode."), Map.entry("usage.text.defaults", "&7Book variant defaults to 16, black, 0,0 if omitted."), Map.entry("usage.bg", "&e/whiteboard bg <#RRGGBB>"), Map.entry("bg.changed", "&aChanged background to {0} ({1} tiles)."), Map.entry("board.cleared", "&aCleared all text ({0} tiles). Background is kept."), Map.entry("undo.none", "&eNothing to undo."), Map.entry("undo.done", "&aUndid the last draw action."), Map.entry("redo.none", "&eNothing to redo."), Map.entry("redo.done", "&aRedid the previous undo."), Map.entry("cmd.lock.usage", "&e/whiteboard lock <on|off>"), Map.entry("lock.state", "&aLock set to {0}."), Map.entry("password.set", "&aSet board password."), Map.entry("password.changed", "&aUpdated board password."), Map.entry("password.cleared", "&aRemoved board password."), Map.entry("password.required", "&cBoard is locked with a password. Include [pass <password>] in the book."), Map.entry("password.mismatch", "&cPassword mismatch."), Map.entry("password.locked", "&cBoard is locked with a password. Use a book with [pass <password>] to edit."), Map.entry("destroy.denied", "&cYou must be OP or have whiteboard.admin to destroy a board."), Map.entry("destroy.done", "&aRemoved the board ({0} frames)."), Map.entry("destroy.none", "&eNo frames were removed."), Map.entry("usage.font", "&e/whiteboard font <family> [PLAIN|BOLD|ITALIC]"), Map.entry("font.warn", "&eWarning: \"{0}\" might not exist on this server."), Map.entry("font.changed", "&aBase font changed to \"{0}\"."), Map.entry("help.grid", "&e/whiteboard grid <WxH> &7\u2026turn frames into a linked board"), Map.entry("help.text", "&e/whiteboard text <msg> <size> <#RRGGBB> <x> <y>"), Map.entry("help.text.book", "&e/whiteboard text book <size> <#RRGGBB> <x> <y> [lineH]"), Map.entry("help.htext", "&e/whiteboard htext <html> <size> <#RRGGBB> <x> <y> [lineH]"), Map.entry("help.htext.book", "&e/whiteboard htext book <size> <#RRGGBB> <x> <y> [lineH]"), Map.entry("help.bg", "&e/whiteboard bg <#RRGGBB> &7\u2026change background"), Map.entry("help.clear", "&e/whiteboard clear &7\u2026remove all text"), Map.entry("help.undo", "&e/whiteboard undo / redo &7\u2026undo/redo last action"), Map.entry("help.lock", "&e/whiteboard lock <on|off>"), Map.entry("help.font", "&e/whiteboard font <family> [style]"), Map.entry("help.tip.quick", "&7Right-click the board while holding a book to apply instantly."), Map.entry("help.tip.directives", "&7Add [size 20], [color #ff0], [pos 10 40], [line 18], [clear], etc."), Map.entry("error.noBook", "&cHold a book or place one in a nearby lectern."), Map.entry("error.emptyBook", "&eThe book has no content."), Map.entry("info.lecternLoaded", "&7Loaded book from lectern ({0}m)."), Map.entry("error.notBoard", "&cThis frame isn\u2019t part of a board. Run /whiteboard grid first."), Map.entry("error.groupMissing", "&cBoard data could not be found."), Map.entry("error.targetMap", "&cAim at a frame containing a filled map."), Map.entry("error.mapView", "&cCould not access MapView."), Map.entry("book.noneRendered", "&eNothing could be rendered from the book."), Map.entry("book.applied", "&aApplied book content to the board. (/whiteboard undo to revert)"), Map.entry("lectern.placed", "&7Placed the book onto a nearby lectern."), Map.entry("lectern.notFound", "&eNo empty lectern nearby."));
    private final JavaPlugin plugin;
    private final Map<String, Map<String, String>> cache = new HashMap<String, Map<String, String>>();
    private final Set<String> announcedBundles = new HashSet<String>();
    private final Set<String> announcedLocales = new HashSet<String>();
    private final Map<UUID, String> playerLocales = new HashMap<UUID, String>();
    private final Set<String> debugMessages = new HashSet<String>();
    private String defaultLanguage = "auto";

    Messages(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    void load(String languageCode) {
        this.defaultLanguage = this.normalize(languageCode);
        this.cache.clear();
        this.ensureResource("en_us");
        this.ensureResource("ja_jp");
        if (!"auto".equals(this.defaultLanguage)) {
            this.ensureResource(this.defaultLanguage);
        }
    }

    void send(CommandSender sender, String key, Object ... args) {
        Map<String, String> bundle = this.resolveBundle(sender);
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)this.format(bundle, key, args));
        sender.sendMessage(message);
    }

    String format(String key, Object ... args) {
        Map<String, String> bundle = this.getBundle("auto".equals(this.defaultLanguage) ? "en_us" : this.defaultLanguage);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.format(bundle, key, args));
    }

    private String format(Map<String, String> bundle, String key, Object ... args) {
        String pattern = bundle.getOrDefault(key, DEFAULT_MESSAGES.getOrDefault(key, key));
        if (pattern == null) {
            pattern = key;
        }
        return new MessageFormat(pattern, Locale.ROOT).format(args);
    }

    private Map<String, String> resolveBundle(CommandSender sender) {
        ArrayList<String> candidates = new ArrayList<String>();
        String lang = this.defaultLanguage;
        if ("auto".equals(lang) && sender instanceof Player) {
            Player player = (Player)sender;
            String locale = this.normalize(player.getLocale());
            lang = !"auto".equals(locale) ? locale : "en_us";
        }
        if (!"auto".equals(lang)) {
            candidates.add(lang);
            int idx = lang.indexOf(95);
            if (idx > 0) {
                candidates.add(lang.substring(0, idx));
            }
        }
        if (!"auto".equals(this.defaultLanguage) && !this.defaultLanguage.equals(lang)) {
            candidates.add(this.defaultLanguage);
        }
        candidates.add("en_us");
        for (String candidate : candidates) {
            Map<String, String> bundle = this.getBundle(candidate);
            if (bundle == null) continue;
            return bundle;
        }
        return DEFAULT_MESSAGES;
    }

    private Map<String, String> getBundle(String languageCode) {
        if (languageCode == null || languageCode.isBlank()) {
            return DEFAULT_MESSAGES;
        }
        if (languageCode.equals("auto")) {
            return DEFAULT_MESSAGES;
        }
        return this.cache.computeIfAbsent(languageCode, this::loadBundleSafely);
    }

    private Map<String, String> loadBundleSafely(String languageCode) {
        try {
            return this.loadBundle(languageCode);
        }
        catch (Exception ex) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load language " + languageCode + ", falling back to en_us", ex);
            if (!"en_us".equals(languageCode)) {
                return this.loadBundleSafely("en_us");
            }
            return DEFAULT_MESSAGES;
        }
    }

    private Map<String, String> loadBundle(String languageCode) throws IOException {
        HashMap<String, String> merged = new HashMap<String, String>(DEFAULT_MESSAGES);
        YamlConfiguration resourceYaml = this.loadFromResource(languageCode);
        if (resourceYaml == null && !"en_us".equals(languageCode)) {
            this.plugin.getLogger().warning("Language bundle " + languageCode + " not found. Falling back to en_us.");
            return this.loadBundle("en_us");
        }
        if (resourceYaml != null) {
            this.mergeInto(merged, resourceYaml);
        }
        File file = this.dataFile(languageCode);
        if (resourceYaml != null) {
            this.saveDefaults(file, resourceYaml, languageCode);
        }
        if (file.exists()) {
            this.mergeInto(merged, YamlConfiguration.loadConfiguration((File)file));
        }
        if (this.announcedBundles.add(languageCode)) {
            this.plugin.getLogger().info("[Whiteboard] loaded " + merged.size() + " messages for " + languageCode);
        }
        return merged;
    }

    private File dataFile(String languageCode) throws IOException {
        File langDir = new File(this.plugin.getDataFolder(), "lang");
        if (!langDir.exists() && !langDir.mkdirs()) {
            throw new IOException("Could not create lang directory " + langDir.getAbsolutePath());
        }
        return new File(langDir, languageCode + ".yml");
    }

    private YamlConfiguration loadFromResource(String languageCode) throws IOException {
        String resourcePath = "lang/" + languageCode + ".yml";
        try (InputStream stream = this.plugin.getResource(resourcePath);){
            if (stream == null) {
                YamlConfiguration yamlConfiguration = null;
                return yamlConfiguration;
            }
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
            return yamlConfiguration;
        }
    }

    private void ensureResource(String languageCode) {
        if (languageCode == null || languageCode.isBlank() || languageCode.equals("auto")) {
            return;
        }
        try {
            this.loadBundle(languageCode);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to prepare language file " + languageCode + ".yml", ex);
        }
    }

    private String normalize(String code) {
        if (code == null || code.isBlank()) {
            return "auto";
        }
        return code.toLowerCase(Locale.ROOT).replace('-', '_');
    }

    private void mergeInto(Map<String, String> target, YamlConfiguration yaml) {
        if (yaml == null) {
            return;
        }
        ConfigurationSection base = yaml.getConfigurationSection("messages");
        if (base == null) {
            return;
        }
        for (String rel : base.getKeys(true)) {
            String val;
            if (base.isConfigurationSection(rel)) continue;
            if (base.isList(rel)) {
                val = String.join((CharSequence)"\n", base.getStringList(rel));
            } else {
                Object obj = base.get(rel);
                if (obj == null) continue;
                val = String.valueOf(obj);
            }
            target.put(rel, val);
        }
    }

    private void saveDefaults(File file, YamlConfiguration yaml, String languageCode) throws IOException {
        if (!yaml.contains("language")) {
            yaml.set("language", (Object)languageCode);
        }
        yaml.save(file);
    }
}

