/*
 * Decompiled with CFR 0.152.
 */
package net.nando256.whiteboard;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.nando256.whiteboard.Messages;
import net.nando256.whiteboard.TextEntry;
import net.nando256.whiteboard.WhiteboardRenderer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Lectern;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public final class WhiteboardPlugin
extends JavaPlugin
implements Listener {
    private static final FontRenderContext FONT_CONTEXT = new FontRenderContext(new AffineTransform(), true, true);
    private static final Pattern GRID_SIZE_PATTERN = Pattern.compile("^\\d+x\\d+$");
    private static final Map<String, Color> CSS_COLOR_MAP = WhiteboardPlugin.createCssColorMap();
    private static final Pattern BOOK_MODE_PREFIX = Pattern.compile("^\\s*(?:\\[(plain|text|html|htext)\\]|(plain|text|html|htext)\\s*:)", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("-?\\d+");
    private final Map<Integer, WhiteboardRenderer> boards = new HashMap<Integer, WhiteboardRenderer>();
    private final Map<String, BoardGroup> groups = new HashMap<String, BoardGroup>();
    private final Map<Integer, String> mapToGroup = new HashMap<Integer, String>();
    private final Map<UUID, String> frameToGroup = new HashMap<UUID, String>();
    private final Set<UUID> protectedFrames = new HashSet<UUID>();
    private Messages messages;

    public void onEnable() {
        this.getLogger().info("Whiteboard enabled (Grid, Wrap, Undo/Redo, Lock/Destroy)");
        this.messages = new Messages(this);
        this.messages.load("auto");
        File fontsDir = new File(this.getDataFolder(), "fonts");
        if (!fontsDir.exists()) {
            fontsDir.mkdirs();
        }
        this.loadCustomFonts(fontsDir);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        if (!this.protectedFrames.contains(frame.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent e) {
        Hanging hanging = e.getEntity();
        if (!(hanging instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)hanging;
        if (!this.protectedFrames.contains(frame.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        Entity entity = e.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        Player player = e.getPlayer();
        if (this.handleBookInteract(player, frame)) {
            e.setCancelled(true);
            return;
        }
        if (this.protectedFrames.contains(frame.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnyDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        ItemFrame frame = (ItemFrame)entity;
        if (!this.protectedFrames.contains(frame.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        String sub = args.length == 0 ? "help" : args[0].toLowerCase(Locale.ROOT);
        try {
            switch (sub) {
                case "grid": {
                    return this.handleGridCommand(p, Arrays.copyOfRange(args, 1, args.length));
                }
                case "text": {
                    return this.handleTextCommand(p, Arrays.copyOfRange(args, 1, args.length), false);
                }
                case "htext": {
                    return this.handleTextCommand(p, Arrays.copyOfRange(args, 1, args.length), true);
                }
                case "bg": {
                    return this.handleBackgroundCommand(p, Arrays.copyOfRange(args, 1, args.length));
                }
                case "clear": {
                    return this.handleClearCommand(p);
                }
                case "undo": {
                    return this.handleUndoCommand(p);
                }
                case "redo": {
                    return this.handleRedoCommand(p);
                }
                case "lock": {
                    return this.handleLockCommand(p, Arrays.copyOfRange(args, 1, args.length));
                }
                case "gdestroy": {
                    return this.handleDestroyCommand(p);
                }
                case "font": {
                    return this.handleFontCommand(p, Arrays.copyOfRange(args, 1, args.length));
                }
            }
            this.sendHelp(p);
            return true;
        }
        catch (Throwable t) {
            this.messages.send((CommandSender)p, "error.generic", new Object[0]);
            t.printStackTrace();
            return true;
        }
    }

    private boolean handleGridCommand(Player p, String[] subArgs) {
        if (subArgs.length < 1 || !GRID_SIZE_PATTERN.matcher(subArgs[0].toLowerCase(Locale.ROOT)).matches()) {
            this.messages.send((CommandSender)p, "cmd.grid.usage", new Object[0]);
            this.messages.send((CommandSender)p, "cmd.grid.tip", new Object[0]);
            return true;
        }
        String[] wh = subArgs[0].toLowerCase(Locale.ROOT).split("x");
        int width = Math.max(1, WhiteboardPlugin.parseIntSafe(wh[0], 1));
        int height = Math.max(1, WhiteboardPlugin.parseIntSafe(wh[1], 1));
        ItemFrame topLeft = this.rayItemFrame(p, 5.0);
        if (topLeft == null) {
            this.messages.send((CommandSender)p, "error.targetFrame", new Object[0]);
            return true;
        }
        this.createBoardFromFrame(p, topLeft, width, height, false);
        return true;
    }

    private BoardGroup createBoardFromFrame(Player p, ItemFrame topLeft, int width, int height, boolean fromBook) {
        if (topLeft == null) {
            if (p != null) {
                this.messages.send((CommandSender)p, "error.targetFrame", new Object[0]);
            }
            return null;
        }
        BlockFace face = topLeft.getFacing();
        Location baseLoc = WhiteboardPlugin.frameBlockCenter(topLeft);
        Vector base = baseLoc.toVector();
        Vector rightBase = WhiteboardPlugin.rightVector(face);
        Vector downBase = new Vector(0, -1, 0);
        double scanRadius = (double)Math.max(width, height) + 1.5;
        Collection nearby = topLeft.getWorld().getNearbyEntities(baseLoc, scanRadius, scanRadius, scanRadius);
        ArrayList<ItemFrame> candidates = new ArrayList<ItemFrame>();
        ArrayList<Vector> offsets = new ArrayList<Vector>();
        for (Entity e : nearby) {
            ItemFrame frame;
            if (!(e instanceof ItemFrame) || (frame = (ItemFrame)e).getFacing() != face) continue;
            candidates.add(frame);
            offsets.add(WhiteboardPlugin.frameBlockCenter(frame).toVector().subtract(base));
        }
        if (candidates.isEmpty()) {
            if (p != null) {
                this.messages.send((CommandSender)p, "error.noFrames", new Object[0]);
            }
            return null;
        }
        GridAssembly assembly = this.resolveGridOrientation(width, height, baseLoc, topLeft, candidates, offsets, rightBase, downBase);
        if (assembly == null) {
            if (p != null) {
                this.messages.send((CommandSender)p, "error.missingFrames", new Object[0]);
            }
            return null;
        }
        ItemFrame[][] grid = assembly.tiles;
        Vector right = assembly.right;
        Vector down = assembly.down;
        World world = topLeft.getWorld();
        int autoPlaced = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (grid[y][x] != null) continue;
                Location center = this.computeFrameCenter(baseLoc, right, down, x, y);
                ItemFrame created = this.ensureFrameExists(world, center, face);
                if (created == null) {
                    if (p != null) {
                        this.messages.send((CommandSender)p, "error.autoPlace", x + 1, y + 1);
                    }
                    return null;
                }
                grid[y][x] = created;
                ++autoPlaced;
            }
        }
        String groupId = UUID.randomUUID().toString();
        BoardGroup group = new BoardGroup(groupId, width, height);
        this.groups.put(groupId, group);
        group.baseTopLeft = baseLoc.clone();
        group.rightUnit = right.clone();
        group.downUnit = down.clone();
        group.locked = true;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ItemFrame frame = grid[y][x];
                MapView view = Bukkit.createMap((World)frame.getWorld());
                view.getRenderers().clear();
                view.setLocked(true);
                WhiteboardRenderer renderer = new WhiteboardRenderer();
                renderer.setBackground(Color.WHITE);
                renderer.setBorderVisible(false);
                view.addRenderer((MapRenderer)renderer);
                this.boards.put(view.getId(), renderer);
                group.tiles[y][x] = renderer;
                group.centers[y][x] = WhiteboardPlugin.frameBlockCenter(frame);
                group.frames[y][x] = frame.getUniqueId();
                this.mapToGroup.put(view.getId(), groupId);
                this.frameToGroup.put(frame.getUniqueId(), groupId);
                this.protectedFrames.add(frame.getUniqueId());
                ItemStack map = new ItemStack(Material.FILLED_MAP);
                MapMeta meta = (MapMeta)map.getItemMeta();
                meta.setMapView(view);
                meta.setDisplayName("\u00a7bWhiteboard");
                map.setItemMeta((ItemMeta)meta);
                frame.setItem(map, false);
            }
        }
        this.applyGroupLock(group, true);
        if (p != null) {
            if (fromBook) {
                this.messages.send((CommandSender)p, "board.init.book", width, height);
            } else {
                this.messages.send((CommandSender)p, "board.init.command", width, height);
                this.messages.send((CommandSender)p, "board.help.commands", new Object[0]);
            }
            if (autoPlaced > 0) {
                this.messages.send((CommandSender)p, "board.autoPlaced", autoPlaced);
            }
        }
        return group;
    }

    private boolean handleTextCommand(Player p, String[] subArgs, boolean htmlMode) {
        BoardGroup group;
        if (subArgs.length == 0) {
            this.sendTextUsage(p, htmlMode);
            return true;
        }
        boolean fromBook = subArgs[0].equalsIgnoreCase("book");
        if (htmlMode) {
            int n = minArgs = fromBook ? 4 : 4;
            if (subArgs.length < minArgs) {
                this.sendTextUsage(p, true);
                return true;
            }
        } else {
            int n = minArgs = fromBook ? 5 : 5;
            if (subArgs.length < minArgs) {
                this.sendTextUsage(p, false);
                return true;
            }
        }
        if ((group = this.requireGroupBySight(p)) == null) {
            return true;
        }
        if (!fromBook && this.isPasswordProtected(group)) {
            this.messages.send((CommandSender)p, "password.locked", new Object[0]);
            return true;
        }
        if (fromBook) {
            int added;
            Color resolvedColor;
            RenderMode mode;
            BookPayload payload;
            ParsedBookCommand parsed = this.parseBookArguments(subArgs, htmlMode);
            if (!parsed.extraTokens.isEmpty()) {
                this.messages.send((CommandSender)p, "book.extraTokens", String.join((CharSequence)", ", parsed.extraTokens));
            }
            if ((payload = this.readBookPayload(p)) == null) {
                return true;
            }
            if (!this.handlePasswordDirectives(p, group, payload.providedPassword, payload.newPassword)) {
                return true;
            }
            RenderMode renderMode = mode = payload.explicitMode ? payload.mode : RenderMode.HTML;
            if (!payload.explicitMode && !htmlMode && mode == RenderMode.HTML) {
                this.messages.send((CommandSender)p, "book.html.defaultMode", new Object[0]);
            }
            if (payload.clearBefore) {
                int cleared = this.clearGroupTexts(group);
                this.messages.send((CommandSender)p, "book.clear", cleared);
            }
            int resolvedSize = WhiteboardPlugin.clamp(payload.sizeOverride != null ? payload.sizeOverride : parsed.size, 8, 64);
            Color color = resolvedColor = payload.colorOverride != null ? payload.colorOverride : parsed.color;
            if (resolvedColor == null) {
                resolvedColor = Color.BLACK;
            }
            int resolvedGx = payload.gxOverride != null ? payload.gxOverride : parsed.gx;
            int resolvedGy = payload.gyOverride != null ? payload.gyOverride : parsed.gy;
            Integer resolvedLineH = payload.lineHeightOverride != null ? WhiteboardPlugin.clamp(payload.lineHeightOverride, 8, 256) : parsed.lineHeight;
            int n = added = mode == RenderMode.PLAIN ? this.renderPlainText(group, payload.text, resolvedSize, resolvedColor, resolvedGx, resolvedGy, resolvedLineH) : this.renderHtmlText(group, payload.text, resolvedSize, resolvedColor, resolvedGx, resolvedGy, resolvedLineH);
            if (added == 0) {
                this.messages.send((CommandSender)p, "book.noText", new Object[0]);
            } else {
                this.messages.send((CommandSender)p, "book.added", added);
            }
            return true;
        }
        if (htmlMode) {
            int added;
            String html = subArgs[0];
            int size = WhiteboardPlugin.clamp(WhiteboardPlugin.parseIntSafe(subArgs[1], 16), 8, 64);
            int index = 2;
            if (subArgs.length <= index) {
                this.sendTextUsage(p, true);
                return true;
            }
            Color color = Color.BLACK;
            if (!WhiteboardPlugin.isInteger(subArgs[index])) {
                color = WhiteboardPlugin.parseHtmlColor(subArgs[index], color);
                ++index;
            }
            if (subArgs.length - index < 2) {
                this.sendTextUsage(p, true);
                return true;
            }
            int gx = WhiteboardPlugin.parseIntSafe(subArgs[index++], 0);
            int gy = WhiteboardPlugin.parseIntSafe(subArgs[index++], 0);
            Integer customLineHeight = null;
            if (subArgs.length > index) {
                customLineHeight = WhiteboardPlugin.clamp(WhiteboardPlugin.parseIntSafe(subArgs[index], WhiteboardPlugin.defaultLineHeight(size)), 8, 256);
            }
            if ((added = this.renderHtmlText(group, html, size, color, gx, gy, customLineHeight)) == 0) {
                this.messages.send((CommandSender)p, "book.html.empty", new Object[0]);
            } else {
                this.messages.send((CommandSender)p, "book.html.added", new Object[0]);
            }
            return true;
        }
        String msg = subArgs[0];
        int size = WhiteboardPlugin.clamp(WhiteboardPlugin.parseIntSafe(subArgs[1], 16), 8, 64);
        Color color = WhiteboardPlugin.parseHtmlColor(subArgs[2], Color.BLACK);
        int gx = WhiteboardPlugin.parseIntSafe(subArgs[3], 0);
        int gy = WhiteboardPlugin.parseIntSafe(subArgs[4], 0);
        TextAction action = new TextAction();
        TextAtom atom = new TextAtom(msg, size, color, gx, gy);
        action.atoms.add(atom);
        this.applyTextAtom(group, atom, action.id);
        group.redo.clear();
        group.undo.push(action);
        this.messages.send((CommandSender)p, "book.text.added", new Object[0]);
        return true;
    }

    private void sendTextUsage(Player p, boolean htmlMode) {
        if (htmlMode) {
            this.messages.send((CommandSender)p, "usage.htext", new Object[0]);
            this.messages.send((CommandSender)p, "usage.htext.book", new Object[0]);
            this.messages.send((CommandSender)p, "usage.htext.colorTip", new Object[0]);
            this.messages.send((CommandSender)p, "usage.htext.bookTip", new Object[0]);
            this.messages.send((CommandSender)p, "usage.book.modeTip", new Object[0]);
        } else {
            this.messages.send((CommandSender)p, "usage.text", new Object[0]);
            this.messages.send((CommandSender)p, "usage.text.book", new Object[0]);
            this.messages.send((CommandSender)p, "usage.text.modeTip", new Object[0]);
            this.messages.send((CommandSender)p, "usage.text.defaults", new Object[0]);
        }
    }

    private boolean handleBackgroundCommand(Player p, String[] subArgs) {
        if (subArgs.length < 1) {
            this.messages.send((CommandSender)p, "usage.bg", new Object[0]);
            return true;
        }
        BoardGroup group = this.requireGroupBySight(p);
        if (group == null) {
            return true;
        }
        if (this.isPasswordProtected(group)) {
            this.messages.send((CommandSender)p, "password.locked", new Object[0]);
            return true;
        }
        Color color = WhiteboardPlugin.parseHtmlColor(subArgs[0], Color.WHITE);
        int count = 0;
        for (int y = 0; y < group.H; ++y) {
            for (int x = 0; x < group.W; ++x) {
                WhiteboardRenderer renderer = group.tiles[y][x];
                if (renderer == null) continue;
                renderer.setBackground(color);
                renderer.requestRedraw();
                ++count;
            }
        }
        this.messages.send((CommandSender)p, "bg.changed", subArgs[0], count);
        return true;
    }

    private boolean handleClearCommand(Player p) {
        BoardGroup group = this.requireGroupBySight(p);
        if (group == null) {
            return true;
        }
        if (this.isPasswordProtected(group)) {
            this.messages.send((CommandSender)p, "password.locked", new Object[0]);
            return true;
        }
        int cleared = this.clearGroupTexts(group);
        this.messages.send((CommandSender)p, "board.cleared", cleared);
        return true;
    }

    private boolean handleUndoCommand(Player p) {
        BoardGroup group = this.requireGroupBySight(p);
        if (group == null) {
            return true;
        }
        if (this.isPasswordProtected(group)) {
            this.messages.send((CommandSender)p, "password.locked", new Object[0]);
            return true;
        }
        if (group.undo.isEmpty()) {
            this.messages.send((CommandSender)p, "undo.none", new Object[0]);
            return true;
        }
        TextAction action = group.undo.pop();
        this.removeAction(group, action.id);
        group.redo.push(action);
        this.messages.send((CommandSender)p, "undo.done", new Object[0]);
        return true;
    }

    private boolean handleRedoCommand(Player p) {
        BoardGroup group = this.requireGroupBySight(p);
        if (group == null) {
            return true;
        }
        if (this.isPasswordProtected(group)) {
            this.messages.send((CommandSender)p, "password.locked", new Object[0]);
            return true;
        }
        if (group.redo.isEmpty()) {
            this.messages.send((CommandSender)p, "redo.none", new Object[0]);
            return true;
        }
        TextAction action = group.redo.pop();
        for (TextAtom atom : action.atoms) {
            this.applyTextAtom(group, atom, action.id);
        }
        group.undo.push(action);
        this.messages.send((CommandSender)p, "redo.done", new Object[0]);
        return true;
    }

    private int clearGroupTexts(BoardGroup group) {
        int cleared = 0;
        for (int y = 0; y < group.H; ++y) {
            for (int x = 0; x < group.W; ++x) {
                WhiteboardRenderer renderer = group.tiles[y][x];
                if (renderer == null) continue;
                renderer.clearTexts();
                renderer.requestRedraw();
                ++cleared;
            }
        }
        group.undo.clear();
        group.redo.clear();
        return cleared;
    }

    private void applyGroupLock(BoardGroup group, boolean on) {
        if (group == null) {
            return;
        }
        group.locked = on;
        for (int y = 0; y < group.H; ++y) {
            for (int x = 0; x < group.W; ++x) {
                UUID id = group.frames[y][x];
                if (id == null) continue;
                if (on) {
                    this.protectedFrames.add(id);
                    continue;
                }
                this.protectedFrames.remove(id);
            }
        }
    }

    private boolean handleLockCommand(Player p, String[] subArgs) {
        if (subArgs.length < 1 || !subArgs[0].equalsIgnoreCase("on") && !subArgs[0].equalsIgnoreCase("off")) {
            this.messages.send((CommandSender)p, "cmd.lock.usage", new Object[0]);
            return true;
        }
        BoardGroup group = this.requireGroupBySight(p);
        if (group == null) {
            return true;
        }
        if (this.isPasswordProtected(group)) {
            this.messages.send((CommandSender)p, "password.locked", new Object[0]);
            return true;
        }
        boolean on = subArgs[0].equalsIgnoreCase("on");
        this.applyGroupLock(group, on);
        this.messages.send((CommandSender)p, "lock.state", on ? "ON" : "OFF");
        return true;
    }

    private boolean handleDestroyCommand(Player p) {
        if (!this.hasAdminPrivilege(p)) {
            this.messages.send((CommandSender)p, "destroy.denied", new Object[0]);
            return true;
        }
        BoardGroup group = this.requireGroupBySight(p);
        if (group == null) {
            return true;
        }
        int removed = this.destroyBoardGroup(group);
        if (removed > 0) {
            this.messages.send((CommandSender)p, "destroy.done", removed);
        } else {
            this.messages.send((CommandSender)p, "destroy.none", new Object[0]);
        }
        return true;
    }

    private boolean hasAdminPrivilege(Player p) {
        return p.isOp() || p.hasPermission("whiteboard.admin");
    }

    private boolean hasPassword(BoardGroup group) {
        return group != null && group.password != null && !group.password.isEmpty();
    }

    private boolean isPasswordProtected(BoardGroup group) {
        return group != null && group.locked && this.hasPassword(group);
    }

    private String normalizePasswordToken(String token) {
        if (token == null) {
            return null;
        }
        String trimmed = token.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private boolean isPasswordClearToken(String token) {
        if (token == null) {
            return false;
        }
        String lower = token.toLowerCase(Locale.ROOT);
        return lower.equals("clear") || lower.equals("off") || lower.equals("none") || lower.equals("remove") || lower.equals("reset");
    }

    private boolean handlePasswordDirectives(Player player, BoardGroup group, String providedToken, String requestedToken) {
        if (group == null) {
            return false;
        }
        String provided = this.normalizePasswordToken(providedToken);
        String requested = this.normalizePasswordToken(requestedToken);
        String current = group.password;
        boolean hasCurrent = this.hasPassword(group);
        if (!hasCurrent) {
            String candidate;
            String string = candidate = requested != null ? requested : provided;
            if (candidate != null) {
                if (this.isPasswordClearToken(candidate)) {
                    group.password = null;
                    this.messages.send((CommandSender)player, "password.cleared", new Object[0]);
                } else {
                    group.password = candidate;
                    this.messages.send((CommandSender)player, "password.set", new Object[0]);
                }
            }
            return true;
        }
        if (group.locked) {
            if (provided == null) {
                this.messages.send((CommandSender)player, "password.required", new Object[0]);
                return false;
            }
            if (!current.equals(provided)) {
                this.messages.send((CommandSender)player, "password.mismatch", new Object[0]);
                return false;
            }
        } else if (requested != null || provided != null && this.isPasswordClearToken(provided)) {
            if (provided == null || !current.equals(provided)) {
                this.messages.send((CommandSender)player, "password.mismatch", new Object[0]);
                return false;
            }
        } else if (provided != null && !current.equals(provided)) {
            this.messages.send((CommandSender)player, "password.mismatch", new Object[0]);
            return false;
        }
        if (requested != null) {
            if (this.isPasswordClearToken(requested)) {
                if (hasCurrent) {
                    group.password = null;
                    this.messages.send((CommandSender)player, "password.cleared", new Object[0]);
                }
            } else if (!current.equals(requested)) {
                group.password = requested;
                this.messages.send((CommandSender)player, "password.changed", new Object[0]);
            }
            return true;
        }
        if (!group.locked && provided != null && this.isPasswordClearToken(provided) && hasCurrent) {
            group.password = null;
            this.messages.send((CommandSender)player, "password.cleared", new Object[0]);
        }
        return true;
    }

    private int destroyBoardGroup(BoardGroup group) {
        if (group == null) {
            return 0;
        }
        this.groups.remove(group.id);
        int removed = 0;
        for (int y = 0; y < group.H; ++y) {
            for (int x = 0; x < group.W; ++x) {
                MapMeta meta;
                MapView view;
                boolean hadMap;
                UUID frameId = group.frames[y][x];
                group.tiles[y][x] = null;
                group.centers[y][x] = null;
                group.frames[y][x] = null;
                if (frameId == null) continue;
                this.protectedFrames.remove(frameId);
                this.frameToGroup.remove(frameId);
                Entity entity = Bukkit.getEntity((UUID)frameId);
                if (!(entity instanceof ItemFrame)) continue;
                ItemFrame frame = (ItemFrame)entity;
                ItemStack item = frame.getItem();
                boolean bl = hadMap = item != null && item.getType() == Material.FILLED_MAP;
                if (hadMap && (view = (meta = (MapMeta)item.getItemMeta()).getMapView()) != null) {
                    this.mapToGroup.remove(view.getId());
                    this.boards.remove(view.getId());
                    ArrayList renderers = new ArrayList(view.getRenderers());
                    for (MapRenderer renderer : renderers) {
                        if (!(renderer instanceof WhiteboardRenderer)) continue;
                        view.removeRenderer(renderer);
                    }
                }
                if (hadMap) {
                    frame.setItem(null);
                } else {
                    frame.setItem(null, false);
                }
                frame.setFixed(false);
                frame.setRotation(Rotation.NONE);
                ++removed;
            }
        }
        this.mapToGroup.entrySet().removeIf(entry -> {
            if (group.id.equals(entry.getValue())) {
                this.boards.remove(entry.getKey());
                return true;
            }
            return false;
        });
        group.undo.clear();
        group.redo.clear();
        group.password = null;
        return removed;
    }

    private boolean handleFontCommand(Player p, String[] subArgs) {
        if (subArgs.length < 1) {
            this.messages.send((CommandSender)p, "usage.font", new Object[0]);
            return true;
        }
        BoardGroup group = this.requireGroupBySight(p);
        if (group == null) {
            return true;
        }
        if (this.isPasswordProtected(group)) {
            this.messages.send((CommandSender)p, "password.locked", new Object[0]);
            return true;
        }
        String family = subArgs[0];
        int style = WhiteboardPlugin.parseFontStyle(subArgs.length >= 2 ? subArgs[1] : "PLAIN");
        Font baseFont = new Font(family, style, 16);
        if (!WhiteboardPlugin.fontFamilyExists(family)) {
            this.messages.send((CommandSender)p, "font.warn", family);
        }
        for (int y = 0; y < group.H; ++y) {
            for (int x = 0; x < group.W; ++x) {
                WhiteboardRenderer renderer = group.tiles[y][x];
                if (renderer == null) continue;
                renderer.setBaseFont(baseFont);
                renderer.requestRedraw();
            }
        }
        this.messages.send((CommandSender)p, "font.changed", baseFont.getFamily());
        return true;
    }

    private void sendHelp(Player p) {
        this.messages.send((CommandSender)p, "help.grid", new Object[0]);
        this.messages.send((CommandSender)p, "help.text", new Object[0]);
        this.messages.send((CommandSender)p, "help.text.book", new Object[0]);
        this.messages.send((CommandSender)p, "help.htext", new Object[0]);
        this.messages.send((CommandSender)p, "help.htext.book", new Object[0]);
        this.messages.send((CommandSender)p, "help.bg", new Object[0]);
        this.messages.send((CommandSender)p, "help.clear", new Object[0]);
        this.messages.send((CommandSender)p, "help.undo", new Object[0]);
        this.messages.send((CommandSender)p, "help.lock", new Object[0]);
        this.messages.send((CommandSender)p, "help.font", new Object[0]);
        this.messages.send((CommandSender)p, "help.tip.quick", new Object[0]);
        this.messages.send((CommandSender)p, "help.tip.directives", new Object[0]);
    }

    private ItemStack findBookInHand(Player p) {
        ItemStack main = p.getInventory().getItemInMainHand();
        if (this.isBook(main)) {
            return main;
        }
        ItemStack off = p.getInventory().getItemInOffHand();
        if (this.isBook(off)) {
            return off;
        }
        return null;
    }

    private boolean isBook(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Material type = stack.getType();
        return type == Material.WRITTEN_BOOK || type == Material.WRITABLE_BOOK;
    }

    private BookPayload readBookPayload(Player p) {
        return this.readBookPayload(p, null);
    }

    private BookPayload readBookPayload(Player p, ItemStack preferredBook) {
        ItemStack handBook;
        ItemStack itemStack = handBook = preferredBook != null && this.isBook(preferredBook) ? preferredBook : null;
        if (handBook == null && !this.isBook(handBook = this.findBookInHand(p))) {
            handBook = null;
        }
        LecternHit lecternHit = null;
        ItemStack source = handBook;
        if (source == null && (lecternHit = this.findLecternBook(p, 5.0)) != null) {
            source = lecternHit.book;
        }
        if (source == null) {
            this.messages.send((CommandSender)p, "error.noBook", new Object[0]);
            return null;
        }
        BookPayload payload = this.extractBookPayload(source);
        if (payload == null || payload.text.isEmpty()) {
            this.messages.send((CommandSender)p, "error.emptyBook", new Object[0]);
            return null;
        }
        if (lecternHit != null) {
            double dist = Math.sqrt(lecternHit.distanceSq);
            double meters = (double)Math.round(dist * 10.0) / 10.0;
            this.messages.send((CommandSender)p, "info.lecternLoaded", String.format(Locale.ROOT, "%.1f", meters));
            payload = payload.withLectern(lecternHit.distanceSq);
        }
        return payload;
    }

    private LecternHit findLecternBook(Player p, double radius) {
        Location origin = p.getLocation();
        World world = origin.getWorld();
        if (world == null) {
            return null;
        }
        int range = (int)Math.ceil(radius);
        double bestDistSq = radius * radius;
        LecternHit best = null;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    ItemStack book;
                    Lectern lectern;
                    Inventory inv;
                    BlockState blockState;
                    Location blockCenter;
                    double distSq;
                    Block block = world.getBlockAt(origin.getBlockX() + dx, origin.getBlockY() + dy, origin.getBlockZ() + dz);
                    if (block.getType() != Material.LECTERN || (distSq = (blockCenter = block.getLocation().add(0.5, 0.5, 0.5)).distanceSquared(origin)) > bestDistSq || !((blockState = block.getState()) instanceof Lectern) || (inv = (lectern = (Lectern)blockState).getInventory()) == null || !this.isBook(book = inv.getItem(0)) || best != null && !(distSq < best.distanceSq)) continue;
                    best = new LecternHit(book.clone(), distSq);
                }
            }
        }
        return best;
    }

    private boolean placeBookOnLectern(Player player, ItemStack book, double radius) {
        if (book == null) {
            return false;
        }
        Location origin = player.getLocation();
        World world = origin.getWorld();
        if (world == null) {
            return false;
        }
        int range = (int)Math.ceil(radius);
        double bestDistSq = radius * radius;
        Lectern bestLectern = null;
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    ItemStack slot;
                    Lectern lectern;
                    Inventory inv;
                    BlockState blockState;
                    Location blockCenter;
                    double distSq;
                    Block block = world.getBlockAt(origin.getBlockX() + dx, origin.getBlockY() + dy, origin.getBlockZ() + dz);
                    if (block.getType() != Material.LECTERN || (distSq = (blockCenter = block.getLocation().add(0.5, 0.5, 0.5)).distanceSquared(origin)) > bestDistSq || !((blockState = block.getState()) instanceof Lectern) || (inv = (lectern = (Lectern)blockState).getInventory()) == null || !this.isLecternSlotEmpty(slot = inv.getItem(0)) || bestLectern != null && !(distSq < bestDistSq)) continue;
                    bestDistSq = distSq;
                    bestLectern = lectern;
                }
            }
        }
        if (bestLectern == null) {
            return false;
        }
        ItemStack toPlace = book.clone();
        toPlace.setAmount(1);
        bestLectern.getInventory().setItem(0, toPlace);
        bestLectern.update();
        return true;
    }

    private void removeBookFromHand(Player player, boolean mainHand) {
        if (mainHand) {
            ItemStack current = player.getInventory().getItemInMainHand();
            if (!this.isBook(current)) {
                return;
            }
            if (current.getAmount() > 1) {
                current.setAmount(current.getAmount() - 1);
                player.getInventory().setItemInMainHand(current);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
        } else {
            ItemStack current = player.getInventory().getItemInOffHand();
            if (!this.isBook(current)) {
                return;
            }
            if (current.getAmount() > 1) {
                current.setAmount(current.getAmount() - 1);
                player.getInventory().setItemInOffHand(current);
            } else {
                player.getInventory().setItemInOffHand(null);
            }
        }
    }

    private boolean isLecternSlotEmpty(ItemStack stack) {
        return stack == null || stack.getType() == Material.AIR || stack.getAmount() <= 0;
    }

    private BookPayload extractBookPayload(ItemStack book) {
        if (book == null) {
            return null;
        }
        ItemMeta itemMeta = book.getItemMeta();
        if (!(itemMeta instanceof BookMeta)) {
            return null;
        }
        BookMeta meta = (BookMeta)itemMeta;
        List<String> pages = this.collectBookPages(meta);
        if (pages.isEmpty()) {
            return null;
        }
        String raw = String.join((CharSequence)"\n", pages);
        ModePrefixResult prefix = this.parseBookMode(raw);
        BookDirectives directives = this.parseBookDirectives(prefix.content);
        return new BookPayload(directives.content, prefix.mode, prefix.explicit, directives.size, directives.color, directives.gx, directives.gy, directives.lineHeight, directives.clearBefore, directives.boardWidth, directives.boardHeight, directives.lockOn, directives.providedPassword, directives.newPassword);
    }

    private List<String> collectBookPages(BookMeta meta) {
        ArrayList<String> pages;
        block10: {
            pages = new ArrayList<String>();
            try {
                Method pagesMethod = meta.getClass().getMethod("pages", new Class[0]);
                Object result = pagesMethod.invoke((Object)meta, new Object[0]);
                if (!(result instanceof Collection)) break block10;
                Collection collection = (Collection)result;
                Object serializer = null;
                Method serializeMethod = null;
                try {
                    Class<?> serializerClass = Class.forName("net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer");
                    Class<?> componentClass = Class.forName("net.kyori.adventure.text.Component");
                    Method plainText = serializerClass.getMethod("plainText", new Class[0]);
                    serializer = plainText.invoke(null, new Object[0]);
                    serializeMethod = serializerClass.getMethod("serialize", componentClass);
                }
                catch (ClassNotFoundException ignored) {
                    serializer = null;
                    serializeMethod = null;
                }
                for (Object element : collection) {
                    if (serializer != null && serializeMethod != null) {
                        try {
                            pages.add((String)serializeMethod.invoke(serializer, element));
                        }
                        catch (Exception e) {
                            pages.add(element.toString());
                        }
                        continue;
                    }
                    pages.add(element.toString());
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pages.isEmpty()) {
            pages.addAll(meta.getPages());
        }
        return pages;
    }

    private ModePrefixResult parseBookMode(String raw) {
        if (raw == null) {
            return new ModePrefixResult(RenderMode.HTML, false, "");
        }
        String trimmed = raw.stripLeading();
        Matcher matcher = BOOK_MODE_PREFIX.matcher(trimmed);
        if (matcher.find()) {
            String keyword = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            String remainder = trimmed.substring(matcher.end()).stripLeading();
            RenderMode mode = this.interpretModeKeyword(keyword);
            return new ModePrefixResult(mode, true, remainder);
        }
        return new ModePrefixResult(RenderMode.HTML, false, trimmed);
    }

    private RenderMode interpretModeKeyword(String keyword) {
        String lower;
        if (keyword == null) {
            return RenderMode.HTML;
        }
        return switch (lower = keyword.toLowerCase(Locale.ROOT)) {
            case "plain", "text" -> RenderMode.PLAIN;
            case "html", "htext" -> RenderMode.HTML;
            default -> RenderMode.HTML;
        };
    }

    private BookDirectives parseBookDirectives(String content) {
        int close;
        String trimmed;
        if (content == null) {
            return new BookDirectives("", null, null, null, null, null, false, null, null, null, null, null);
        }
        String working = content.stripLeading();
        Integer size = null;
        Color color = null;
        Integer gx = null;
        Integer gy = null;
        Integer lineHeight = null;
        boolean clearBefore = false;
        Integer boardWidth = null;
        Integer boardHeight = null;
        Boolean lockOn = null;
        Object providedPassword = null;
        Object newPassword = null;
        while ((trimmed = working.stripLeading()).startsWith("[") && (close = trimmed.indexOf(93)) >= 0) {
            String token = trimmed.substring(1, close).trim();
            String remainder = trimmed.substring(close + 1);
            boolean matched = false;
            String lower = token.toLowerCase(Locale.ROOT);
            if (lower.startsWith("size")) {
                value = this.parseFirstInt(token);
                if (value != null) {
                    size = WhiteboardPlugin.clamp((Integer)value, 8, 64);
                    matched = true;
                }
            } else if (lower.startsWith("line")) {
                value = this.parseFirstInt(token);
                if (value != null) {
                    lineHeight = WhiteboardPlugin.clamp((Integer)value, 8, 256);
                    matched = true;
                }
            } else if (lower.equals("clear")) {
                clearBefore = true;
                matched = true;
            } else if (lower.startsWith("color")) {
                Color parsed;
                arg = token.replaceFirst("(?i)color", "").trim();
                while (!(arg.isEmpty() || arg.charAt(0) != '=' && arg.charAt(0) != ':' && arg.charAt(0) != ',')) {
                    arg = arg.substring(1).trim();
                }
                if (arg.isEmpty()) {
                    arg = token;
                }
                if ((parsed = this.tryParseColorToken(arg)) == null) {
                    parsed = this.tryParseColorToken(token);
                }
                if (parsed != null) {
                    color = parsed;
                    matched = true;
                }
            } else if (lower.startsWith("pos") || lower.startsWith("xy") || lower.startsWith("offset")) {
                Integer[] pos = this.parsePositionToken(token);
                if (pos != null) {
                    gx = pos[0];
                    gy = pos[1];
                    matched = true;
                }
            } else if (lower.startsWith("boardsize")) {
                Integer[] dims = this.parseBoardSizeToken(token);
                if (dims != null) {
                    boardWidth = Math.max(1, dims[0]);
                    boardHeight = Math.max(1, dims[1]);
                    matched = true;
                }
            } else if (lower.startsWith("password")) {
                value = this.extractDirectiveValue(token, "password");
                if (value != null) {
                    newPassword = value;
                    matched = true;
                }
            } else if (lower.startsWith("pass")) {
                value = this.extractDirectiveValue(token, "pass");
                if (value != null) {
                    if (providedPassword == null) {
                        providedPassword = value;
                    }
                    matched = true;
                }
            } else if (lower.startsWith("lock")) {
                arg = token.replaceFirst("(?i)lock", "").trim().toLowerCase(Locale.ROOT);
                if (arg.isEmpty() || arg.equals("on")) {
                    lockOn = true;
                    matched = true;
                } else if (arg.equals("off")) {
                    lockOn = false;
                    matched = true;
                }
            }
            if (!matched) break;
            working = remainder;
        }
        return new BookDirectives(working.stripLeading(), size, color, gx, gy, lineHeight, clearBefore, boardWidth, boardHeight, lockOn, (String)providedPassword, (String)newPassword);
    }

    private Integer parseFirstInt(String token) {
        Matcher matcher = INT_PATTERN.matcher(token);
        if (!matcher.find()) {
            return null;
        }
        try {
            return Integer.parseInt(matcher.group());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Integer[] parsePositionToken(String token) {
        Integer x;
        Matcher matcher = INT_PATTERN.matcher(token);
        if (!matcher.find()) {
            return null;
        }
        Integer y = 0;
        try {
            x = Integer.parseInt(matcher.group());
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (matcher.find()) {
            try {
                y = Integer.parseInt(matcher.group());
            }
            catch (NumberFormatException e) {
                y = 0;
            }
        }
        return new Integer[]{x, y};
    }

    private Integer[] parseBoardSizeToken(String token) {
        Integer h;
        Integer w;
        Matcher matcher = INT_PATTERN.matcher(token);
        if (!matcher.find()) {
            return null;
        }
        try {
            w = Math.max(1, Integer.parseInt(matcher.group()));
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (!matcher.find()) {
            return null;
        }
        try {
            h = Math.max(1, Integer.parseInt(matcher.group()));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Integer[]{w, h};
    }

    private String extractDirectiveValue(String token, String keyword) {
        char ch;
        if (token == null || keyword == null) {
            return null;
        }
        String remainder = token.replaceFirst("(?i)^" + keyword, "").trim();
        while (!(remainder.isEmpty() || (ch = remainder.charAt(0)) != '=' && ch != ':' && ch != ',')) {
            remainder = remainder.substring(1).trim();
        }
        return remainder.isEmpty() ? null : remainder;
    }

    private ParsedBookCommand parseBookArguments(String[] subArgs, boolean htmlMode) {
        Color parsedColor;
        int size = 16;
        Color color = Color.BLACK;
        int gx = 0;
        int gy = 0;
        Integer lineHeight = null;
        int index = 1;
        if (index < subArgs.length && WhiteboardPlugin.isInteger(subArgs[index])) {
            size = WhiteboardPlugin.clamp(WhiteboardPlugin.parseIntSafe(subArgs[index], size), 8, 64);
            ++index;
        }
        if (index < subArgs.length && (parsedColor = this.tryParseColorToken(subArgs[index])) != null) {
            color = parsedColor;
            ++index;
        }
        if (index < subArgs.length && WhiteboardPlugin.isInteger(subArgs[index])) {
            gx = WhiteboardPlugin.parseIntSafe(subArgs[index], gx);
            ++index;
        }
        if (index < subArgs.length && WhiteboardPlugin.isInteger(subArgs[index])) {
            gy = WhiteboardPlugin.parseIntSafe(subArgs[index], gy);
            ++index;
        }
        if (index < subArgs.length && WhiteboardPlugin.isInteger(subArgs[index])) {
            lineHeight = WhiteboardPlugin.clamp(WhiteboardPlugin.parseIntSafe(subArgs[index], WhiteboardPlugin.defaultLineHeight(size)), 8, 256);
            ++index;
        }
        ArrayList<String> extras = new ArrayList<String>();
        while (index < subArgs.length) {
            extras.add(subArgs[index++]);
        }
        return new ParsedBookCommand(size, color, gx, gy, lineHeight, Collections.unmodifiableList(extras));
    }

    private List<HtmlToken> createPlainTextTokens(String text, Color color, int size) {
        ArrayList<HtmlToken> tokens = new ArrayList<HtmlToken>();
        if (text == null || text.isEmpty()) {
            return tokens;
        }
        String normalized = text.replace("\r", "");
        StringBuilder current = new StringBuilder();
        boolean lineStart = true;
        boolean pendingSpace = false;
        for (int i = 0; i < normalized.length(); ++i) {
            char ch = normalized.charAt(i);
            if (ch == '\n') {
                if (current.length() > 0) {
                    tokens.add(HtmlToken.text(current.toString(), color, size));
                    current.setLength(0);
                }
                tokens.add(HtmlToken.lineBreak());
                lineStart = true;
                pendingSpace = false;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (lineStart) continue;
                pendingSpace = true;
                continue;
            }
            if (pendingSpace) {
                current.append(' ');
                pendingSpace = false;
            }
            current.append(ch);
            lineStart = false;
        }
        if (current.length() > 0) {
            tokens.add(HtmlToken.text(current.toString(), color, size));
        }
        return tokens;
    }

    private int renderPlainText(BoardGroup group, String text, int size, Color color, int gx, int gy, Integer customLineH) {
        List<HtmlToken> tokens = this.createPlainTextTokens(text, color, size);
        if (tokens.isEmpty()) {
            return 0;
        }
        int lineHeight = WhiteboardPlugin.clamp(customLineH != null ? customLineH : WhiteboardPlugin.defaultLineHeight(size), 8, 256);
        return this.renderTokens(group, tokens, gx, gy, lineHeight);
    }

    private int renderHtmlText(BoardGroup group, String html, int defaultSize, Color defaultColor, int gx, int gy, Integer customLineH) {
        List<HtmlToken> tokens = this.parseHtmlTokens(html, defaultColor, defaultSize);
        if (tokens.isEmpty()) {
            return 0;
        }
        int lineHeight = WhiteboardPlugin.clamp(customLineH != null ? customLineH : WhiteboardPlugin.defaultLineHeight(defaultSize), 8, 256);
        return this.renderTokens(group, tokens, gx, gy, lineHeight);
    }

    private int renderTokens(BoardGroup group, List<HtmlToken> tokens, int gx, int gy, int baseLineHeight) {
        Font baseFont = this.resolveBaseFont(group);
        int canvasWidth = group.W * 128;
        TextAction action = new TextAction();
        int x = gx;
        int y = gy;
        int lineHeight = baseLineHeight;
        boolean added = false;
        block0: for (HtmlToken token : tokens) {
            int tokenLineHeight;
            if (token.lineBreak) {
                x = 0;
                y += lineHeight;
                lineHeight = baseLineHeight;
                continue;
            }
            if (token.isTable()) {
                List<String> row22;
                x = 0;
                Font tableFont = baseFont.deriveFont((float)token.size);
                tokenLineHeight = WhiteboardPlugin.defaultLineHeight(token.size);
                if (tokenLineHeight > lineHeight) {
                    lineHeight = tokenLineHeight;
                }
                int columns = 0;
                for (List<String> row22 : token.tableRows) {
                    if (row22.size() <= columns) continue;
                    columns = row22.size();
                }
                if (columns == 0) continue;
                int[] colWidths = new int[columns];
                row22 = token.tableRows.iterator();
                while (row22.hasNext()) {
                    List row3 = (List)row22.next();
                    for (int c = 0; c < columns; ++c) {
                        String value = c < row3.size() ? (String)row3.get(c) : "";
                        int n = WhiteboardPlugin.measureWidth(tableFont, value);
                        if (n <= colWidths[c]) continue;
                        colWidths[c] = n;
                    }
                }
                int separatorWidth = WhiteboardPlugin.measureWidth(tableFont, "| ");
                int closingWidth = WhiteboardPlugin.measureWidth(tableFont, "|");
                int paddingWidth = WhiteboardPlugin.measureWidth(tableFont, "  ");
                if (paddingWidth < 4) {
                    paddingWidth = 4;
                }
                for (List list : token.tableRows) {
                    int cursorX = 0;
                    for (int c = 0; c < columns; ++c) {
                        String value;
                        if (separatorWidth > 0) {
                            TextAtom sep = new TextAtom("| ", token.size, token.color, cursorX, y);
                            action.atoms.add(sep);
                            this.applyTextAtom(group, sep, action.id);
                            added = true;
                        }
                        cursorX += separatorWidth;
                        String string = value = c < list.size() ? (String)list.get(c) : "";
                        if (!value.isEmpty()) {
                            TextAtom cell = new TextAtom(value, token.size, token.color, cursorX, y);
                            action.atoms.add(cell);
                            this.applyTextAtom(group, cell, action.id);
                            added = true;
                        }
                        cursorX += colWidths[c] + paddingWidth;
                    }
                    TextAtom endSep = new TextAtom("|", token.size, token.color, cursorX, y);
                    action.atoms.add(endSep);
                    this.applyTextAtom(group, endSep, action.id);
                    added = true;
                    y += tokenLineHeight;
                    lineHeight = baseLineHeight;
                }
                continue;
            }
            if (token.text == null || token.text.isEmpty()) continue;
            Font font = baseFont.deriveFont((float)token.size);
            tokenLineHeight = WhiteboardPlugin.defaultLineHeight(token.size);
            if (tokenLineHeight > lineHeight) {
                lineHeight = tokenLineHeight;
            }
            int idx = 0;
            String text = token.text;
            while (idx < text.length()) {
                String piece;
                while (idx < text.length() && text.charAt(idx) == ' ' && x == 0) {
                    ++idx;
                }
                if (idx >= text.length()) continue block0;
                int remaining = canvasWidth - x;
                if (remaining <= 0) {
                    x = 0;
                    y += lineHeight;
                    lineHeight = Math.max(baseLineHeight, tokenLineHeight);
                    continue;
                }
                int next = this.findWrapPoint(text, idx, font, remaining);
                if (next <= idx) {
                    if (x != 0) {
                        x = 0;
                        y += lineHeight;
                        lineHeight = Math.max(baseLineHeight, tokenLineHeight);
                        continue;
                    }
                    next = Math.min(idx + 1, text.length());
                }
                if ((piece = text.substring(idx, next)).isBlank()) {
                    idx = next;
                    continue;
                }
                TextAtom atom = new TextAtom(piece, token.size, token.color, x, y);
                action.atoms.add(atom);
                this.applyTextAtom(group, atom, action.id);
                added = true;
                x += WhiteboardPlugin.measureWidth(font, piece);
                idx = next;
                if (idx >= text.length()) continue;
                x = 0;
                y += lineHeight;
                lineHeight = Math.max(baseLineHeight, tokenLineHeight);
            }
        }
        if (!added) {
            return 0;
        }
        group.redo.clear();
        group.undo.push(action);
        return action.atoms.size();
    }

    private List<HtmlToken> parseHtmlTokens(String html, Color defaultColor, int defaultSize) {
        ArrayList<HtmlToken> tokens = new ArrayList<HtmlToken>();
        if (html == null || html.isEmpty()) {
            return tokens;
        }
        String input = html.replace("\r", "");
        ArrayDeque<HtmlStyle> stack = new ArrayDeque<HtmlStyle>();
        stack.push(new HtmlStyle(defaultColor, defaultSize));
        ArrayDeque<TableContext> tableStack = new ArrayDeque<TableContext>();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            int semi;
            char ch = input.charAt(i);
            if (ch == '<') {
                int close;
                if (buffer.length() > 0) {
                    this.emitHtmlText(buffer, (HtmlStyle)stack.peek(), tokens, tableStack);
                    buffer.setLength(0);
                }
                if ((close = input.indexOf(62, i + 1)) == -1) break;
                String raw = input.substring(i + 1, close).trim();
                boolean closing = raw.startsWith("/");
                boolean selfClosing = raw.endsWith("/");
                String content = raw;
                if (closing) {
                    content = raw.substring(1).trim();
                }
                if (selfClosing) {
                    content = content.substring(0, content.length() - 1).trim();
                }
                String name = content;
                String attrPart = "";
                int spaceIdx = content.indexOf(32);
                if (spaceIdx >= 0) {
                    name = content.substring(0, spaceIdx);
                    attrPart = content.substring(spaceIdx + 1);
                }
                name = name.toLowerCase(Locale.ROOT);
                Map<String, String> attrs = this.parseHtmlAttributes(attrPart);
                if (closing) {
                    if ((name.equals("span") || name.equals("font")) && stack.size() > 1) {
                        stack.pop();
                    } else if (name.equals("p") || name.equals("div")) {
                        tokens.add(HtmlToken.lineBreak());
                        tokens.add(HtmlToken.lineBreak());
                    } else if (name.equals("table")) {
                        TableContext ctx;
                        TableContext tableContext = ctx = tableStack.isEmpty() ? null : (TableContext)tableStack.pop();
                        if (ctx != null) {
                            this.emitTableTokens(ctx, tokens);
                        }
                        this.ensureLineBreak(tokens);
                    } else if (name.equals("tr")) {
                        if (!tableStack.isEmpty()) {
                            this.endTableRow((TableContext)tableStack.peek());
                        }
                    } else if ((name.equals("td") || name.equals("th")) && !tableStack.isEmpty()) {
                        this.endTableCell((TableContext)tableStack.peek());
                    }
                } else if (name.equals("br")) {
                    tokens.add(HtmlToken.lineBreak());
                } else if (name.equals("p") || name.equals("div")) {
                    if (!tokens.isEmpty() && !((HtmlToken)tokens.get((int)(tokens.size() - 1))).lineBreak) {
                        tokens.add(HtmlToken.lineBreak());
                    }
                    tokens.add(HtmlToken.lineBreak());
                } else if (name.equals("span") || name.equals("font")) {
                    HtmlStyle child = this.deriveStyleFromAttributes((HtmlStyle)stack.peek(), attrs);
                    stack.push(child);
                    if (selfClosing && stack.size() > 1) {
                        stack.pop();
                    }
                } else if (name.equals("table")) {
                    this.stripTrailingLineBreaks(tokens);
                    HtmlStyle current = (HtmlStyle)stack.peek();
                    TableContext ctx = new TableContext(new HtmlStyle(current.color, current.size));
                    tableStack.push(ctx);
                    if (selfClosing && !tableStack.isEmpty()) {
                        this.emitTableTokens((TableContext)tableStack.pop(), tokens);
                    }
                } else if (name.equals("tr")) {
                    if (!tableStack.isEmpty()) {
                        this.startTableRow((TableContext)tableStack.peek());
                    }
                } else if ((name.equals("td") || name.equals("th")) && !tableStack.isEmpty()) {
                    this.startTableCell((TableContext)tableStack.peek());
                }
                i = close + 1;
                continue;
            }
            if (ch == '&' && (semi = input.indexOf(59, i + 1)) > i) {
                buffer.append(this.decodeHtmlEntity(input.substring(i + 1, semi)));
                i = semi + 1;
                continue;
            }
            buffer.append(ch);
            ++i;
        }
        if (buffer.length() > 0) {
            this.emitHtmlText(buffer, (HtmlStyle)stack.peek(), tokens, tableStack);
        }
        return tokens;
    }

    private void ensureLineBreak(List<HtmlToken> tokens) {
        if (tokens.isEmpty() || tokens.get((int)(tokens.size() - 1)).lineBreak) {
            return;
        }
        tokens.add(HtmlToken.lineBreak());
    }

    private void stripTrailingLineBreaks(List<HtmlToken> tokens) {
        int removed = 0;
        while (!tokens.isEmpty() && tokens.get((int)(tokens.size() - 1)).lineBreak) {
            tokens.remove(tokens.size() - 1);
            ++removed;
        }
        if (removed > 0) {
            tokens.add(HtmlToken.lineBreak());
        }
    }

    private void emitHtmlText(StringBuilder buffer, HtmlStyle style, List<HtmlToken> tokens, Deque<TableContext> tableStack) {
        TableContext currentTable;
        if (buffer.isEmpty()) {
            return;
        }
        String raw = buffer.toString();
        buffer.setLength(0);
        TableContext tableContext = currentTable = tableStack != null && !tableStack.isEmpty() ? tableStack.peek() : null;
        if (currentTable != null) {
            if (currentTable.capturingCell) {
                this.appendTableText(currentTable, raw);
                return;
            }
            if (raw.isBlank()) {
                return;
            }
        }
        StringBuilder current = new StringBuilder();
        boolean lineStart = tokens.isEmpty() || tokens.get((int)(tokens.size() - 1)).lineBreak;
        boolean pendingSpace = false;
        for (int i = 0; i < raw.length(); ++i) {
            char ch = raw.charAt(i);
            if (ch == '\n') {
                if (current.length() > 0) {
                    tokens.add(HtmlToken.text(current.toString(), style.color, style.size));
                    current.setLength(0);
                }
                tokens.add(HtmlToken.lineBreak());
                lineStart = true;
                pendingSpace = false;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (lineStart) continue;
                pendingSpace = true;
                continue;
            }
            if (pendingSpace) {
                current.append(' ');
                pendingSpace = false;
            }
            current.append(ch);
            lineStart = false;
        }
        if (current.length() > 0) {
            tokens.add(HtmlToken.text(current.toString(), style.color, style.size));
        }
    }

    private void startTableRow(TableContext ctx) {
        if (ctx == null) {
            return;
        }
        this.endTableRow(ctx);
        ctx.currentRow = new ArrayList<String>();
    }

    private void endTableRow(TableContext ctx) {
        if (ctx == null) {
            return;
        }
        this.endTableCell(ctx);
        if (ctx.currentRow != null) {
            ctx.rows.add(ctx.currentRow);
            ctx.currentRow = null;
        }
    }

    private void startTableCell(TableContext ctx) {
        if (ctx == null) {
            return;
        }
        if (ctx.currentRow == null) {
            ctx.currentRow = new ArrayList<String>();
        }
        this.endTableCell(ctx);
        ctx.capturingCell = true;
        if (ctx.currentCell == null) {
            ctx.currentCell = new StringBuilder();
        }
        ctx.currentCell.setLength(0);
    }

    private void endTableCell(TableContext ctx) {
        if (ctx == null || !ctx.capturingCell) {
            return;
        }
        String text = ctx.currentCell.toString().strip();
        ctx.currentRow.add(text);
        ctx.capturingCell = false;
        ctx.currentCell.setLength(0);
    }

    private void appendTableText(TableContext ctx, String raw) {
        if (ctx == null || !ctx.capturingCell || raw == null || raw.isEmpty()) {
            return;
        }
        String normalized = raw.replace("\r", " ").replace('\n', ' ').replaceAll("\\s+", " ").trim();
        if (normalized.isEmpty()) {
            return;
        }
        if (ctx.currentCell.length() > 0) {
            ctx.currentCell.append(' ');
        }
        ctx.currentCell.append(normalized);
    }

    private void emitTableTokens(TableContext ctx, List<HtmlToken> tokens) {
        if (ctx == null) {
            return;
        }
        this.endTableRow(ctx);
        if (ctx.rows.isEmpty()) {
            return;
        }
        tokens.add(HtmlToken.table(ctx.rows, ctx.style.color, ctx.style.size));
        tokens.add(HtmlToken.lineBreak());
    }

    private Map<String, String> parseHtmlAttributes(String raw) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (raw == null || raw.isEmpty()) {
            return map;
        }
        int i = 0;
        while (i < raw.length()) {
            String value;
            int eq;
            while (i < raw.length() && Character.isWhitespace(raw.charAt(i))) {
                ++i;
            }
            if (i >= raw.length() || (eq = raw.indexOf(61, i)) == -1) break;
            String key = raw.substring(i, eq).trim().toLowerCase(Locale.ROOT);
            i = eq + 1;
            if (i >= raw.length()) break;
            char quote = raw.charAt(i);
            if (quote == '\"' || quote == '\'') {
                if ((end = raw.indexOf(quote, ++i)) == -1) {
                    value = raw.substring(i);
                    i = raw.length();
                } else {
                    value = raw.substring(i, end);
                    i = end + 1;
                }
            } else {
                for (end = i; end < raw.length() && !Character.isWhitespace(raw.charAt(end)); ++end) {
                }
                value = raw.substring(i, end);
                i = end;
            }
            map.put(key, value);
        }
        return map;
    }

    private HtmlStyle deriveStyleFromAttributes(HtmlStyle parent, Map<String, String> attrs) {
        Color color = parent.color;
        int size = parent.size;
        if (attrs.containsKey("color")) {
            color = WhiteboardPlugin.parseCssColor(attrs.get("color"), color);
        }
        if (attrs.containsKey("size")) {
            size = WhiteboardPlugin.clamp(this.parseFontSize(attrs.get("size"), size), 8, 256);
        }
        if (attrs.containsKey("font-size")) {
            size = WhiteboardPlugin.clamp(this.parseFontSize(attrs.get("font-size"), size), 8, 256);
        }
        if (attrs.containsKey("style")) {
            String styleDecl = attrs.get("style");
            for (String decl : styleDecl.split(";")) {
                int colon = decl.indexOf(58);
                if (colon == -1) continue;
                String key = decl.substring(0, colon).trim().toLowerCase(Locale.ROOT);
                String value = decl.substring(colon + 1).trim();
                if (key.equals("color")) {
                    color = WhiteboardPlugin.parseCssColor(value, color);
                }
                if (!key.equals("font-size")) continue;
                size = WhiteboardPlugin.clamp(this.parseFontSize(value, size), 8, 256);
            }
        }
        return new HtmlStyle(color, size);
    }

    private int parseFontSize(String raw, int current) {
        if (raw == null) {
            return current;
        }
        String v = raw.trim().toLowerCase(Locale.ROOT);
        if (v.endsWith("px")) {
            v = v.substring(0, v.length() - 2).trim();
        }
        if (v.endsWith("%")) {
            try {
                double pct = Double.parseDouble(v.substring(0, v.length() - 1));
                return Math.max(1, (int)Math.round((double)current * pct / 100.0));
            }
            catch (NumberFormatException pct) {
                return current;
            }
        }
        if (v.endsWith("em")) {
            try {
                double em = Double.parseDouble(v.substring(0, v.length() - 2));
                return Math.max(1, (int)Math.round((double)current * em));
            }
            catch (NumberFormatException ignored) {
                return current;
            }
        }
        return Math.max(1, WhiteboardPlugin.parseIntSafe(v, current));
    }

    private int findWrapPoint(String text, int start, Font font, int maxWidth) {
        int len = text.length();
        int best = start;
        int lastSpace = -1;
        for (int i = start; i < len; ++i) {
            int width;
            char ch = text.charAt(i);
            if (ch == ' ') {
                lastSpace = i;
            }
            if ((width = WhiteboardPlugin.measureWidth(font, text.substring(start, i + 1))) > maxWidth) {
                if (lastSpace >= start && lastSpace < i) {
                    return lastSpace + 1;
                }
                return best;
            }
            best = i + 1;
        }
        return best;
    }

    private Font resolveBaseFont(BoardGroup group) {
        for (int y = 0; y < group.H; ++y) {
            for (int x = 0; x < group.W; ++x) {
                WhiteboardRenderer renderer = group.tiles[y][x];
                if (renderer == null) continue;
                return renderer.getBaseFont();
            }
        }
        return new Font("Noto Sans CJK JP", 0, 16);
    }

    private static int defaultLineHeight(int size) {
        return Math.max(8, (int)Math.round((double)size * 1.25));
    }

    private static int measureWidth(Font font, String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        Rectangle2D bounds = font.getStringBounds(text, FONT_CONTEXT);
        return (int)Math.ceil(bounds.getWidth());
    }

    private String decodeHtmlEntity(String entity) {
        String key = entity.trim();
        if (key.isEmpty()) {
            return "";
        }
        if (key.startsWith("#x") || key.startsWith("#X")) {
            try {
                int code = Integer.parseInt(key.substring(2), 16);
                return Character.toString((char)code);
            }
            catch (NumberFormatException ignored) {
                return "&" + entity + ";";
            }
        }
        if (key.startsWith("#")) {
            try {
                int code = Integer.parseInt(key.substring(1));
                return Character.toString((char)code);
            }
            catch (NumberFormatException ignored) {
                return "&" + entity + ";";
            }
        }
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "lt" -> "<";
            case "gt" -> ">";
            case "amp" -> "&";
            case "quot" -> "\"";
            case "apos" -> "'";
            case "nbsp" -> " ";
            default -> "&" + entity + ";";
        };
    }

    private static Color parseCssColor(String raw, Color fallback) {
        if (raw == null) {
            return fallback;
        }
        String v = raw.trim();
        if (v.isEmpty()) {
            return fallback;
        }
        String lower = v.toLowerCase(Locale.ROOT);
        if (lower.startsWith("rgb(") && lower.endsWith(")")) {
            String inner = lower.substring(4, lower.length() - 1);
            String[] parts = inner.split(",");
            if (parts.length == 3) {
                try {
                    int r = WhiteboardPlugin.clamp(WhiteboardPlugin.parseCssColorComponent(parts[0]), 0, 255);
                    int g = WhiteboardPlugin.clamp(WhiteboardPlugin.parseCssColorComponent(parts[1]), 0, 255);
                    int b = WhiteboardPlugin.clamp(WhiteboardPlugin.parseCssColorComponent(parts[2]), 0, 255);
                    return new Color(r, g, b);
                }
                catch (NumberFormatException ignored) {
                    return fallback;
                }
            }
            return fallback;
        }
        Color named = CSS_COLOR_MAP.get(lower.replace(" ", ""));
        if (named != null) {
            return named;
        }
        return WhiteboardPlugin.parseHtmlColor(v, fallback);
    }

    private static int parseCssColorComponent(String raw) {
        String v = raw.trim();
        if (v.endsWith("%")) {
            double pct = Double.parseDouble(v.substring(0, v.length() - 1));
            return (int)Math.round(255.0 * (pct / 100.0));
        }
        return Integer.parseInt(v);
    }

    private Color tryParseColorToken(String token) {
        String hex;
        if (token == null) {
            return null;
        }
        String trimmed = token.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        String normalized = trimmed.toLowerCase(Locale.ROOT).replace(" ", "");
        Color named = CSS_COLOR_MAP.get(normalized);
        if (named != null) {
            return named;
        }
        if (normalized.startsWith("rgb(") && normalized.endsWith(")")) {
            String inner = normalized.substring(4, normalized.length() - 1);
            String[] parts = inner.split(",");
            if (parts.length == 3) {
                try {
                    int r = WhiteboardPlugin.clamp(WhiteboardPlugin.parseCssColorComponent(parts[0]), 0, 255);
                    int g = WhiteboardPlugin.clamp(WhiteboardPlugin.parseCssColorComponent(parts[1]), 0, 255);
                    int b = WhiteboardPlugin.clamp(WhiteboardPlugin.parseCssColorComponent(parts[2]), 0, 255);
                    return new Color(r, g, b);
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            return null;
        }
        String string = hex = trimmed.startsWith("#") ? trimmed.substring(1) : trimmed;
        if (hex.length() == 3 && WhiteboardPlugin.isHexDigits(hex)) {
            StringBuilder sb = new StringBuilder(6);
            for (int i = 0; i < 3; ++i) {
                sb.append(hex.charAt(i)).append(hex.charAt(i));
            }
            hex = sb.toString();
        }
        if (hex.length() == 6 && WhiteboardPlugin.isHexDigits(hex)) {
            try {
                return new Color(Integer.parseInt(hex, 16));
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    private static boolean isHexDigits(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    private BoardGroup requireGroupBySight(Player p) {
        ItemFrame f = this.rayItemFrame(p, 5.0);
        MapView view = this.requireMapViewOnFrame(p, f);
        if (view == null) {
            return null;
        }
        String gid = this.mapToGroup.get(view.getId());
        if (gid == null) {
            this.messages.send((CommandSender)p, "error.notBoard", new Object[0]);
            return null;
        }
        BoardGroup g = this.groups.get(gid);
        if (g == null || g.baseTopLeft == null) {
            this.messages.send((CommandSender)p, "error.groupMissing", new Object[0]);
            return null;
        }
        return g;
    }

    private MapView requireMapViewOnFrame(Player p, ItemFrame frame) {
        if (frame == null || frame.getItem() == null || frame.getItem().getType() != Material.FILLED_MAP) {
            this.messages.send((CommandSender)p, "error.targetMap", new Object[0]);
            return null;
        }
        MapMeta mm = (MapMeta)frame.getItem().getItemMeta();
        MapView view = mm.getMapView();
        if (view == null) {
            this.messages.send((CommandSender)p, "error.mapView", new Object[0]);
            return null;
        }
        return view;
    }

    private BoardGroup groupFromFrame(ItemFrame frame) {
        if (frame == null) {
            return null;
        }
        ItemStack item = frame.getItem();
        if (item == null || item.getType() != Material.FILLED_MAP) {
            return null;
        }
        MapMeta meta = (MapMeta)item.getItemMeta();
        if (meta == null) {
            return null;
        }
        MapView view = meta.getMapView();
        if (view == null) {
            return null;
        }
        String gid = this.mapToGroup.get(view.getId());
        if (gid == null) {
            return null;
        }
        return this.groups.get(gid);
    }

    private ItemFrame rayItemFrame(Player p, double maxDist) {
        Location eye = p.getEyeLocation();
        for (double t = 0.0; t <= maxDist; t += 0.25) {
            Location pos = eye.clone().add(eye.getDirection().multiply(t));
            for (Entity e : pos.getWorld().getNearbyEntities(pos, 0.4, 0.4, 0.4)) {
                if (!(e instanceof ItemFrame)) continue;
                ItemFrame f = (ItemFrame)e;
                return f;
            }
        }
        return null;
    }

    private ItemFrame ensureFrameExists(World world, Location center, BlockFace facing) {
        if (world == null) {
            return null;
        }
        ItemFrame existing = this.findFrameNear(world, center, facing);
        if (existing != null) {
            return existing;
        }
        Block support = center.getBlock().getRelative(facing.getOppositeFace());
        if (support.getType().isAir()) {
            return null;
        }
        try {
            ItemFrame spawned = (ItemFrame)world.spawn(center, ItemFrame.class, frame -> {
                frame.setFacingDirection(facing, true);
                frame.setRotation(Rotation.NONE);
            });
            if (spawned == null || !spawned.isValid()) {
                return null;
            }
            return spawned;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private ItemFrame findFrameNear(World world, Location center, BlockFace facing) {
        if (world == null) {
            return null;
        }
        double radius = 0.25;
        for (Entity entity : world.getNearbyEntities(center, radius, radius, radius)) {
            ItemFrame frame;
            if (!(entity instanceof ItemFrame) || (frame = (ItemFrame)entity).getFacing() != facing || !(WhiteboardPlugin.frameBlockCenter(frame).distanceSquared(center) <= 0.05)) continue;
            return frame;
        }
        return null;
    }

    private boolean handleBookInteract(Player player, ItemFrame frame) {
        int added;
        ItemStack held = this.findBookInHand(player);
        if (!this.isBook(held)) {
            return false;
        }
        BookPayload payload = this.readBookPayload(player, held);
        if (payload == null) {
            return true;
        }
        BoardGroup group = this.groupFromFrame(frame);
        if (group == null && payload.boardWidth != null && payload.boardHeight != null) {
            group = this.createBoardFromFrame(player, frame, payload.boardWidth, payload.boardHeight, true);
        }
        if (group == null) {
            return false;
        }
        if (!this.handlePasswordDirectives(player, group, payload.providedPassword, payload.newPassword)) {
            return true;
        }
        if (payload.lockOverride != null) {
            this.applyGroupLock(group, payload.lockOverride);
        }
        if (payload.clearBefore) {
            int cleared = this.clearGroupTexts(group);
            this.messages.send((CommandSender)player, "book.clear", cleared);
        }
        int size = WhiteboardPlugin.clamp(payload.sizeOverride != null ? payload.sizeOverride : 16, 8, 64);
        Color color = payload.colorOverride != null ? payload.colorOverride : Color.BLACK;
        int gx = payload.gxOverride != null ? payload.gxOverride : 0;
        int gy = payload.gyOverride != null ? payload.gyOverride : 0;
        Integer lineHeight = payload.lineHeightOverride != null ? Integer.valueOf(WhiteboardPlugin.clamp(payload.lineHeightOverride, 8, 256)) : null;
        RenderMode mode = payload.explicitMode ? payload.mode : RenderMode.HTML;
        int n = added = mode == RenderMode.PLAIN ? this.renderPlainText(group, payload.text, size, color, gx, gy, lineHeight) : this.renderHtmlText(group, payload.text, size, color, gx, gy, lineHeight);
        if (added == 0) {
            this.messages.send((CommandSender)player, "book.noneRendered", new Object[0]);
        } else {
            this.messages.send((CommandSender)player, "book.applied", new Object[0]);
            if (!payload.fromLectern && held != null) {
                boolean fromOffHand;
                boolean fromMainHand = held == player.getInventory().getItemInMainHand();
                boolean bl = fromOffHand = !fromMainHand && held == player.getInventory().getItemInOffHand();
                if (fromMainHand || fromOffHand) {
                    boolean placed = this.placeBookOnLectern(player, held, 5.0);
                    if (placed) {
                        this.removeBookFromHand(player, fromMainHand);
                        this.messages.send((CommandSender)player, "lectern.placed", new Object[0]);
                    } else {
                        this.messages.send((CommandSender)player, "lectern.notFound", new Object[0]);
                    }
                }
            }
        }
        return true;
    }

    private static int parseIntSafe(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private static boolean isInteger(String s) {
        if (s == null) {
            return false;
        }
        String v = s.trim();
        if (v.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(v);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static int clamp(int v, int lo, int hi) {
        return Math.max(lo, Math.min(hi, v));
    }

    private static Color parseHtmlColor(String s, Color def) {
        if (s == null) {
            return def;
        }
        String v = s.trim();
        if (v.isEmpty()) {
            return def;
        }
        if (v.charAt(0) == '#') {
            v = v.substring(1);
        }
        if (v.length() == 3) {
            StringBuilder sb = new StringBuilder(6);
            for (int i = 0; i < 3; ++i) {
                sb.append(v.charAt(i)).append(v.charAt(i));
            }
            v = sb.toString();
        }
        if (v.length() != 6) {
            return def;
        }
        try {
            return new Color(Integer.parseInt(v, 16));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    private static boolean fontFamilyExists(String family) {
        String[] names;
        for (String n : names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!n.equalsIgnoreCase(family)) continue;
            return true;
        }
        return false;
    }

    private static int parseFontStyle(String s) {
        String v;
        return switch (v = (s == null ? "PLAIN" : s).toUpperCase(Locale.ROOT)) {
            case "BOLD" -> 1;
            case "ITALIC" -> 2;
            case "BOLDITALIC", "BOLD_ITALIC" -> 3;
            default -> 0;
        };
    }

    private static Map<String, Color> createCssColorMap() {
        HashMap<String, Color> map = new HashMap<String, Color>();
        map.put("black", new Color(0));
        map.put("white", new Color(0xFFFFFF));
        map.put("red", new Color(0xFF0000));
        map.put("green", new Color(32768));
        map.put("blue", new Color(255));
        map.put("yellow", new Color(0xFFFF00));
        map.put("cyan", new Color(65535));
        map.put("aqua", new Color(65535));
        map.put("magenta", new Color(0xFF00FF));
        map.put("fuchsia", new Color(0xFF00FF));
        map.put("gray", new Color(0x808080));
        map.put("grey", new Color(0x808080));
        map.put("lightgray", new Color(0xD3D3D3));
        map.put("lightgrey", new Color(0xD3D3D3));
        map.put("darkgray", new Color(0xA9A9A9));
        map.put("darkgrey", new Color(0xA9A9A9));
        map.put("orange", new Color(16753920));
        map.put("brown", new Color(0xA52A2A));
        map.put("purple", new Color(0x800080));
        map.put("pink", new Color(16761035));
        map.put("lime", new Color(65280));
        map.put("navy", new Color(128));
        map.put("teal", new Color(32896));
        map.put("olive", new Color(0x808000));
        map.put("maroon", new Color(0x800000));
        map.put("silver", new Color(0xC0C0C0));
        map.put("gold", new Color(16766720));
        return Collections.unmodifiableMap(map);
    }

    private void loadCustomFonts(File fontsDir) {
        if (!fontsDir.exists() || !fontsDir.isDirectory()) {
            return;
        }
        File[] files = fontsDir.listFiles((dir, name) -> {
            String lower = name.toLowerCase(Locale.ROOT);
            return lower.endsWith(".ttf") || lower.endsWith(".otf");
        });
        if (files == null) {
            return;
        }
        for (File file : files) {
            try (FileInputStream fis = new FileInputStream(file);){
                Font font = Font.createFont(0, fis);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                this.getLogger().info("Loaded custom font: " + font.getFamily() + " (" + file.getName() + ")");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load font " + file.getName() + ": " + e.getMessage());
            }
        }
    }

    private static Vector rightVector(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> new Vector(1, 0, 0);
            case BlockFace.SOUTH -> new Vector(-1, 0, 0);
            case BlockFace.EAST -> new Vector(0, 0, 1);
            case BlockFace.WEST -> new Vector(0, 0, -1);
            default -> new Vector(0, 0, 0);
        };
    }

    private static Location frameBlockCenter(ItemFrame f) {
        Location l = f.getLocation();
        return new Location(l.getWorld(), Math.floor(l.getX()) + 0.5, Math.floor(l.getY()) + 0.5, Math.floor(l.getZ()) + 0.5);
    }

    private WhiteboardRenderer getOrAttachRenderer(MapView view) {
        WhiteboardRenderer r = this.boards.get(view.getId());
        if (r != null) {
            return r;
        }
        for (MapRenderer mr : view.getRenderers()) {
            if (!(mr instanceof WhiteboardRenderer)) continue;
            WhiteboardRenderer wr = (WhiteboardRenderer)mr;
            this.boards.put(view.getId(), wr);
            return wr;
        }
        WhiteboardRenderer nw = new WhiteboardRenderer();
        view.addRenderer((MapRenderer)nw);
        this.boards.put(view.getId(), nw);
        return nw;
    }

    private void applyTextAtom(BoardGroup g, TextAtom a, UUID actionId) {
        double TOL = 0.75;
        Vector ORG = g.baseTopLeft.toVector();
        Vector RIGHT = g.rightUnit.clone();
        Vector DOWN = g.downUnit.clone();
        for (int ty = 0; ty < g.H; ++ty) {
            for (int tx = 0; tx < g.W; ++tx) {
                WhiteboardRenderer r = g.tiles[ty][tx];
                Location center = g.centers[ty][tx];
                if (r == null || center == null) continue;
                Vector rel = center.toVector().subtract(ORG);
                double u = rel.dot(RIGHT);
                double v = rel.dot(DOWN);
                int ix = (int)Math.round(u);
                int iy = (int)Math.round(v);
                if (Math.abs(u - (double)ix) > 0.75 || Math.abs(v - (double)iy) > 0.75) continue;
                int localX = a.gx - ix * 128;
                int localY = a.gy - iy * 128;
                r.addText(new TextEntry(a.msg, a.size, a.col, localX, localY, actionId));
                r.requestRedraw();
            }
        }
    }

    private void removeAction(BoardGroup g, UUID actionId) {
        for (int ty = 0; ty < g.H; ++ty) {
            for (int tx = 0; tx < g.W; ++tx) {
                WhiteboardRenderer r = g.tiles[ty][tx];
                if (r == null) continue;
                r.removeByActionId(actionId);
            }
        }
    }

    private GridAssembly resolveGridOrientation(int width, int height, Location baseLoc, ItemFrame topLeft, List<ItemFrame> candidates, List<Vector> offsets, Vector rightBase, Vector downBase) {
        Vector[][] orientations;
        GridAssembly best = null;
        for (Vector[] pair : orientations = new Vector[][]{{rightBase.clone(), downBase.clone()}, {rightBase.clone(), downBase.clone().multiply(-1)}, {rightBase.clone().multiply(-1), downBase.clone()}, {rightBase.clone().multiply(-1), downBase.clone().multiply(-1)}}) {
            ItemFrame[][] grid = this.assembleGrid(width, height, baseLoc, topLeft, candidates, offsets, pair[0], pair[1]);
            if (grid == null) continue;
            int count = this.countFrames(grid);
            if (best != null && count <= best.existingCount) continue;
            best = new GridAssembly(grid, pair[0], pair[1], count);
        }
        return best;
    }

    private ItemFrame[][] assembleGrid(int width, int height, Location baseLoc, ItemFrame topLeft, List<ItemFrame> candidates, List<Vector> offsets, Vector right, Vector down) {
        double tolerance = 0.6;
        ItemFrame[][] grid = new ItemFrame[height][width];
        double[][] bestDist = new double[height][width];
        for (int y = 0; y < height; ++y) {
            Arrays.fill(bestDist[y], Double.POSITIVE_INFINITY);
        }
        Vector baseVec = baseLoc.toVector();
        for (int i = 0; i < candidates.size(); ++i) {
            Vector rel = offsets.get(i);
            double u = rel.dot(right);
            double v = rel.dot(down);
            int ix = (int)Math.round(u);
            int iy = (int)Math.round(v);
            if (ix < 0 || ix >= width || iy < 0 || iy >= height || Math.abs(u - (double)ix) > 0.6 || Math.abs(v - (double)iy) > 0.6) continue;
            ItemFrame frame = candidates.get(i);
            Vector expected = baseVec.clone().add(right.clone().multiply(ix)).add(down.clone().multiply(iy));
            double distSq = WhiteboardPlugin.frameBlockCenter(frame).toVector().distanceSquared(expected);
            if (!(distSq < bestDist[iy][ix])) continue;
            grid[iy][ix] = frame;
            bestDist[iy][ix] = distSq;
        }
        if (grid[0][0] == null || !grid[0][0].getUniqueId().equals(topLeft.getUniqueId())) {
            return null;
        }
        return grid;
    }

    private int countFrames(ItemFrame[][] grid) {
        int count = 0;
        ItemFrame[][] itemFrameArray = grid;
        int n = itemFrameArray.length;
        for (int i = 0; i < n; ++i) {
            ItemFrame[] row;
            for (ItemFrame frame : row = itemFrameArray[i]) {
                if (frame == null) continue;
                ++count;
            }
        }
        return count;
    }

    private Location computeFrameCenter(Location base, Vector right, Vector down, int x, int y) {
        return base.clone().add(right.clone().multiply(x)).add(down.clone().multiply(y));
    }

    static final class BoardGroup {
        final String id;
        final int W;
        final int H;
        final WhiteboardRenderer[][] tiles;
        final Location[][] centers;
        final UUID[][] frames;
        Location baseTopLeft;
        Vector rightUnit;
        Vector downUnit;
        boolean locked = true;
        String password;
        final Deque<TextAction> undo = new ArrayDeque<TextAction>();
        final Deque<TextAction> redo = new ArrayDeque<TextAction>();

        BoardGroup(String id, int W, int H) {
            this.id = id;
            this.W = W;
            this.H = H;
            this.tiles = new WhiteboardRenderer[H][W];
            this.centers = new Location[H][W];
            this.frames = new UUID[H][W];
        }
    }

    private static final class GridAssembly {
        final ItemFrame[][] tiles;
        final Vector right;
        final Vector down;
        final int existingCount;

        GridAssembly(ItemFrame[][] tiles, Vector right, Vector down, int existingCount) {
            this.tiles = tiles;
            this.right = right.clone();
            this.down = down.clone();
            this.existingCount = existingCount;
        }
    }

    private static final class ParsedBookCommand {
        final int size;
        final Color color;
        final int gx;
        final int gy;
        final Integer lineHeight;
        final List<String> extraTokens;

        ParsedBookCommand(int size, Color color, int gx, int gy, Integer lineHeight, List<String> extraTokens) {
            this.size = size;
            this.color = color;
            this.gx = gx;
            this.gy = gy;
            this.lineHeight = lineHeight;
            this.extraTokens = extraTokens;
        }
    }

    static final class BookPayload {
        final String text;
        final RenderMode mode;
        final boolean explicitMode;
        final Integer sizeOverride;
        final Color colorOverride;
        final Integer gxOverride;
        final Integer gyOverride;
        final Integer lineHeightOverride;
        final boolean clearBefore;
        final Integer boardWidth;
        final Integer boardHeight;
        final Boolean lockOverride;
        final String providedPassword;
        final String newPassword;
        final boolean fromLectern;
        final double distanceSq;

        BookPayload(String text, RenderMode mode, boolean explicitMode, Integer sizeOverride, Color colorOverride, Integer gxOverride, Integer gyOverride, Integer lineHeightOverride, boolean clearBefore, Integer boardWidth, Integer boardHeight, Boolean lockOverride, String providedPassword, String newPassword) {
            this(text, mode, explicitMode, sizeOverride, colorOverride, gxOverride, gyOverride, lineHeightOverride, clearBefore, boardWidth, boardHeight, lockOverride, providedPassword, newPassword, false, 0.0);
        }

        BookPayload(String text, RenderMode mode, boolean explicitMode, Integer sizeOverride, Color colorOverride, Integer gxOverride, Integer gyOverride, Integer lineHeightOverride, boolean clearBefore, Integer boardWidth, Integer boardHeight, Boolean lockOverride, String providedPassword, String newPassword, boolean fromLectern, double distanceSq) {
            this.text = text;
            this.mode = mode;
            this.explicitMode = explicitMode;
            this.sizeOverride = sizeOverride;
            this.colorOverride = colorOverride;
            this.gxOverride = gxOverride;
            this.gyOverride = gyOverride;
            this.lineHeightOverride = lineHeightOverride;
            this.clearBefore = clearBefore;
            this.boardWidth = boardWidth;
            this.boardHeight = boardHeight;
            this.lockOverride = lockOverride;
            this.providedPassword = providedPassword;
            this.newPassword = newPassword;
            this.fromLectern = fromLectern;
            this.distanceSq = distanceSq;
        }

        BookPayload withLectern(double distSq) {
            return new BookPayload(this.text, this.mode, this.explicitMode, this.sizeOverride, this.colorOverride, this.gxOverride, this.gyOverride, this.lineHeightOverride, this.clearBefore, this.boardWidth, this.boardHeight, this.lockOverride, this.providedPassword, this.newPassword, true, distSq);
        }
    }

    private static enum RenderMode {
        HTML,
        PLAIN;

    }

    static final class TextAction {
        final UUID id = UUID.randomUUID();
        final List<TextAtom> atoms = new ArrayList<TextAtom>();

        TextAction() {
        }
    }

    static final class TextAtom {
        final String msg;
        final int size;
        final Color col;
        final int gx;
        final int gy;

        TextAtom(String m, int s, Color c, int x, int y) {
            this.msg = m;
            this.size = s;
            this.col = c;
            this.gx = x;
            this.gy = y;
        }
    }

    private static final class LecternHit {
        final ItemStack book;
        final double distanceSq;

        LecternHit(ItemStack book, double distanceSq) {
            this.book = book;
            this.distanceSq = distanceSq;
        }
    }

    private static final class ModePrefixResult {
        final RenderMode mode;
        final boolean explicit;
        final String content;

        ModePrefixResult(RenderMode mode, boolean explicit, String content) {
            this.mode = mode;
            this.explicit = explicit;
            this.content = content;
        }
    }

    private static final class BookDirectives {
        final String content;
        final Integer size;
        final Color color;
        final Integer gx;
        final Integer gy;
        final Integer lineHeight;
        final boolean clearBefore;
        final Integer boardWidth;
        final Integer boardHeight;
        final Boolean lockOn;
        final String providedPassword;
        final String newPassword;

        BookDirectives(String content, Integer size, Color color, Integer gx, Integer gy, Integer lineHeight, boolean clearBefore, Integer boardWidth, Integer boardHeight, Boolean lockOn, String providedPassword, String newPassword) {
            this.content = content;
            this.size = size;
            this.color = color;
            this.gx = gx;
            this.gy = gy;
            this.lineHeight = lineHeight;
            this.clearBefore = clearBefore;
            this.boardWidth = boardWidth;
            this.boardHeight = boardHeight;
            this.lockOn = lockOn;
            this.providedPassword = providedPassword;
            this.newPassword = newPassword;
        }
    }

    private static final class HtmlToken {
        final String text;
        final Color color;
        final int size;
        final boolean lineBreak;
        final List<List<String>> tableRows;

        private HtmlToken(String text, Color color, int size, boolean lineBreak, List<List<String>> tableRows) {
            this.text = text;
            this.color = color;
            this.size = size;
            this.lineBreak = lineBreak;
            this.tableRows = tableRows;
        }

        static HtmlToken text(String text, Color color, int size) {
            return new HtmlToken(text, color, size, false, null);
        }

        static HtmlToken lineBreak() {
            return new HtmlToken("", null, 0, true, null);
        }

        static HtmlToken table(List<List<String>> rows, Color color, int size) {
            ArrayList<List<String>> copy = new ArrayList<List<String>>();
            for (List<String> row : rows) {
                copy.add(new ArrayList<String>(row));
            }
            return new HtmlToken("", color, size, false, copy);
        }

        boolean isTable() {
            return this.tableRows != null;
        }
    }

    private static final class HtmlStyle {
        final Color color;
        final int size;

        HtmlStyle(Color color, int size) {
            this.color = color;
            this.size = size;
        }
    }

    private static final class TableContext {
        final HtmlStyle style;
        final List<List<String>> rows = new ArrayList<List<String>>();
        List<String> currentRow;
        StringBuilder currentCell;
        boolean capturingCell;

        TableContext(HtmlStyle style) {
            this.style = style;
        }
    }
}

