/*
 * Decompiled with CFR 0.152.
 */
package net.nando256.turboagent.http;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import net.nando256.turboagent.TwBridgePlugin;

public final class StaticHttpServer {
    private final TwBridgePlugin plugin;
    private final String address;
    private final int port;
    private final String resourceBase;
    private final int cacheSeconds;
    private final Path externalRoot;
    private final Map<String, byte[]> overrides;
    private HttpServer server;
    private static final Map<String, String> MIME_MAP = Map.ofEntries(Map.entry(".html", "text/html; charset=utf-8"), Map.entry(".js", "application/javascript; charset=utf-8"), Map.entry(".css", "text/css; charset=utf-8"), Map.entry(".json", "application/json; charset=utf-8"), Map.entry(".png", "image/png"), Map.entry(".jpg", "image/jpeg"), Map.entry(".jpeg", "image/jpeg"), Map.entry(".gif", "image/gif"), Map.entry(".svg", "image/svg+xml"), Map.entry(".ico", "image/x-icon"), Map.entry(".woff2", "font/woff2"), Map.entry(".woff", "font/woff"));

    public StaticHttpServer(TwBridgePlugin plugin, String address, int port, String resourceBase, int cacheSeconds, Map<String, byte[]> overrides, Path externalRoot) {
        this.plugin = plugin;
        this.address = address == null || address.isBlank() ? "0.0.0.0" : address;
        this.port = port;
        this.resourceBase = resourceBase == null ? "" : resourceBase;
        this.cacheSeconds = cacheSeconds;
        this.overrides = overrides == null ? Map.of() : overrides;
        this.externalRoot = externalRoot;
    }

    public void start() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(this.address, this.port), 0);
        this.server.createContext("/", new ResourceHandler());
        this.server.setExecutor(Executors.newCachedThreadPool());
        this.server.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
    }

    private final class ResourceHandler
    implements HttpHandler {
        private ResourceHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            URI uri = exchange.getRequestURI();
            Object path = this.normalizePath(uri);
            if (path == null) {
                this.send(exchange, 400, "bad path");
                return;
            }
            if (((String)path).startsWith("tw/")) {
                path = ((String)path).substring("tw/".length());
            }
            if (((String)path).isEmpty() || ((String)path).endsWith("/")) {
                path = (String)path + "index.html";
            }
            String resourcePath = StaticHttpServer.this.resourceBase + (String)path;
            byte[] bytes = StaticHttpServer.this.overrides.get(path);
            if (bytes == null && StaticHttpServer.this.externalRoot != null) {
                try {
                    Path filePath = StaticHttpServer.this.externalRoot.resolve((String)path).normalize();
                    if (!filePath.startsWith(StaticHttpServer.this.externalRoot) || Files.isDirectory(filePath, new LinkOption[0]) || !Files.exists(filePath, new LinkOption[0])) {
                        this.send(exchange, 404, "not found");
                        return;
                    }
                    bytes = Files.readAllBytes(filePath);
                }
                catch (Exception filePath) {
                    // empty catch block
                }
            }
            try (InputStream is = bytes == null ? StaticHttpServer.this.plugin.getResource(resourcePath) : null;){
                if (bytes == null) {
                    if (is == null) {
                        this.send(exchange, 404, "not found");
                        return;
                    }
                    bytes = is.readAllBytes();
                }
            }
            Headers headers = exchange.getResponseHeaders();
            headers.add("Content-Type", this.contentType((String)path));
            headers.add("Cache-Control", "public, max-age=" + StaticHttpServer.this.cacheSeconds);
            this.setSecurityHeaders(headers);
            exchange.sendResponseHeaders(200, bytes.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(bytes);
            }
        }

        private String normalizePath(URI uri) {
            if (uri == null) {
                return "";
            }
            String raw = uri.getPath();
            if (raw == null) {
                return "";
            }
            String cleaned = raw.replace("..", "").replace("\\", "/");
            while (cleaned.startsWith("/")) {
                cleaned = cleaned.substring(1);
            }
            return cleaned;
        }

        private String contentType(String path) {
            String lower = path.toLowerCase(Locale.ROOT);
            for (Map.Entry<String, String> entry : MIME_MAP.entrySet()) {
                if (!lower.endsWith(entry.getKey())) continue;
                return entry.getValue();
            }
            return "application/octet-stream";
        }

        private void send(HttpExchange ex, int status, String msg) throws IOException {
            byte[] bytes = msg.getBytes(StandardCharsets.UTF_8);
            this.setSecurityHeaders(ex.getResponseHeaders());
            ex.sendResponseHeaders(status, bytes.length);
            try (OutputStream os = ex.getResponseBody();){
                os.write(bytes);
            }
        }

        private void setSecurityHeaders(Headers h) {
            h.add("X-Content-Type-Options", "nosniff");
            h.add("Access-Control-Allow-Origin", "*");
            h.add("Access-Control-Allow-Methods", "GET, HEAD, OPTIONS");
        }
    }
}

