/*
 * Decompiled with CFR 0.152.
 */
package net.nando256.twbridge;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.nando256.twbridge.http.TwHttpServer;
import net.nando256.twbridge.ws.BridgeServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public final class TwBridgePlugin
extends JavaPlugin
implements Listener {
    private BridgeServer wsServer;
    private TwHttpServer httpServer;
    private final Map<String, AgentEntry> agents = new ConcurrentHashMap<String, AgentEntry>();
    private boolean debug;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.applyConfigAndStart();
    }

    public void onDisable() {
        this.stopServers();
    }

    private void applyConfigAndStart() {
        this.stopServers();
        this.debug = this.getConfig().getBoolean("debug", false);
        this.logDebug("Debug mode enabled");
        String wsAddr = TwBridgePlugin.firstNonBlank(this.getConfig().getString("ws.bindAddress"), this.getConfig().getString("ws.address"), "0.0.0.0");
        int wsPort = this.getConfig().getInt("ws.port", 8787);
        int rate = this.getConfig().getInt("ws.maxMsgPerSecond", 30);
        int maxBytes = this.getConfig().getInt("ws.maxMsgBytes", 8192);
        HashSet<String> origins = new HashSet<String>(this.getConfig().getStringList("ws.originWhitelist"));
        boolean pairingRequired = this.getConfig().getBoolean("ws.requirePairing", this.getConfig().getBoolean("pairing.enabled", true));
        int pairWindowSec = this.getConfig().getInt("pairing.windowSeconds", 60);
        String clientHost = TwBridgePlugin.chooseClientHost(this.getConfig().getString("http.wsAddress"), this.getConfig().getString("ws.advertiseAddress"), wsAddr);
        String wsDefaultUrl = TwBridgePlugin.buildWsDefaultUrl(clientHost, wsPort);
        try {
            this.wsServer = new BridgeServer(this, wsAddr, wsPort, origins, rate, maxBytes, pairingRequired, pairWindowSec);
            this.wsServer.setReuseAddr(true);
            this.wsServer.start();
            this.getLogger().info("WS: ws://" + wsAddr + ":" + wsPort);
        }
        catch (Exception e) {
            this.getLogger().severe("WS Server Failed: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.getConfig().getBoolean("http.enabled", true)) {
            String hAddr = TwBridgePlugin.firstNonBlank(this.getConfig().getString("http.bindAddress"), this.getConfig().getString("http.address"), "0.0.0.0");
            int hPort = this.getConfig().getInt("http.port", 8788);
            String hPath = this.getConfig().getString("http.path", "/tw/twbridge.js");
            List cors = this.getConfig().getStringList("http.corsAllowOrigins");
            int cache = this.getConfig().getInt("http.cacheSeconds", 60);
            try {
                this.httpServer = new TwHttpServer(this, hAddr, hPort, hPath, cors, cache, wsDefaultUrl);
                this.httpServer.start();
                this.getLogger().info("HTTP: http://" + hAddr + ":" + hPort + hPath);
            }
            catch (Exception e) {
                this.getLogger().severe("HTTP Server Failed: " + e.getMessage());
            }
        }
    }

    private void stopServers() {
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.httpServer = null;
        }
        if (this.wsServer != null) {
            try {
                this.wsServer.stop(1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wsServer = null;
        }
        this.cleanupAgents();
    }

    public boolean onCommand(CommandSender s, Command c, String l, String[] a) {
        if (!s.hasPermission("twbridge.admin")) {
            s.sendMessage("No permission");
            return true;
        }
        if (a.length == 0) {
            s.sendMessage("/twbridge reload | pair");
            return true;
        }
        switch (a[0].toLowerCase(Locale.ROOT)) {
            case "reload": {
                this.reloadConfig();
                this.applyConfigAndStart();
                s.sendMessage("twbridge reloaded.");
                break;
            }
            case "pair": {
                if (this.wsServer == null) {
                    s.sendMessage("WS server not running.");
                    break;
                }
                String code = this.wsServer.rotatePairCode();
                if (code == null) {
                    s.sendMessage("Pairing is disabled (ws.requirePairing = false).");
                    break;
                }
                int ttl = this.getConfig().getInt("pairing.windowSeconds", 60);
                s.sendMessage("Pair code: " + code + " (valid " + ttl + "s)");
            }
        }
        return true;
    }

    public void handleCommand(String command, Runnable onSuccess, Consumer<String> onFailure) {
        if (command == null || command.isBlank()) {
            if (onFailure != null) {
                onFailure.accept("command required");
            }
            return;
        }
        this.logDebug("Executing command: " + command);
        this.runSync(() -> {
            block6: {
                try {
                    boolean success = this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
                    this.logDebug("Command result: " + success);
                    if (success) {
                        if (onSuccess != null) {
                            onSuccess.run();
                        }
                    } else if (onFailure != null) {
                        onFailure.accept("command failed");
                    }
                }
                catch (Exception e) {
                    this.getLogger().warning("Bridge command failed: " + e.getMessage());
                    if (onFailure == null) break block6;
                    onFailure.accept(e.getMessage());
                }
            }
        });
    }

    public void handleAgentTeleportToPlayer(String agentId, String ownerName, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            Player player = this.resolvePlayer(ownerName);
            if (player == null) {
                this.logDebug("Teleport failed: player '" + ownerName + "' not found");
                if (onFailure != null) {
                    onFailure.accept("player not found");
                }
                return;
            }
            String ownerKey = player.getName();
            String agentKey = TwBridgePlugin.agentMapKey(ownerKey, agentId);
            this.logDebug("Teleport agent " + agentId + " for " + ownerKey);
            AgentEntry existing = this.agents.get(agentKey);
            ArmorStand stand = existing == null ? null : this.getAgentEntity(existing.entityId());
            Location target = this.normalizeLocation(player.getLocation());
            if (stand == null) {
                this.logDebug("Spawning new agent " + agentId);
                stand = this.spawnAgent(ownerKey, agentId, target);
                if (stand == null) {
                    this.logDebug("Spawning agent failed (spawnAgent returned null)");
                    if (onFailure != null) {
                        onFailure.accept("spawn failed");
                    }
                    return;
                }
                this.agents.put(agentKey, new AgentEntry(stand.getUniqueId(), ownerKey));
            } else {
                this.logDebug("Teleporting existing agent " + agentId);
                stand.teleport(target);
            }
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentMove(String agentId, String ownerName, String direction, double blocks, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry entry = this.agents.get(agentKey);
            if (entry == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            if (!entry.owner().equalsIgnoreCase(ownerName)) {
                if (onFailure != null) {
                    onFailure.accept("agent owned by another player");
                }
                return;
            }
            ArmorStand stand = this.getAgentEntity(entry.entityId());
            if (stand == null) {
                this.agents.remove(agentKey);
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            String normalizedDirection = this.normalizeDirection(direction);
            if (normalizedDirection == null) {
                if (onFailure != null) {
                    onFailure.accept("invalid direction");
                }
                return;
            }
            double distance = Math.max(0.0, Math.min(Math.abs(blocks), 64.0));
            if (distance < 0.01) {
                if (onFailure != null) {
                    onFailure.accept("blocks must be greater than 0");
                }
                return;
            }
            Vector vector = this.resolveDirectionVector(stand.getLocation(), normalizedDirection);
            if (vector == null) {
                if (onFailure != null) {
                    onFailure.accept("unable to resolve direction");
                }
                return;
            }
            Location origin = stand.getLocation();
            Vector offset = vector.multiply(distance);
            Location target = this.normalizeAgentTarget(origin.clone().add(offset), origin);
            if (target == null) {
                if (onFailure != null) {
                    onFailure.accept("invalid target");
                }
                return;
            }
            this.animateAgentMove(stand);
            stand.teleport(target);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentDespawn(String agentId, String ownerName, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry existing = this.agents.get(agentKey);
            if (existing == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            if (!existing.owner().equalsIgnoreCase(ownerName)) {
                if (onFailure != null) {
                    onFailure.accept("agent owned by another player");
                }
                return;
            }
            ArmorStand entity = this.getAgentEntity(existing.entityId());
            if (entity != null) {
                entity.remove();
            }
            this.agents.remove(agentKey);
            this.logDebug("Despawned agent " + agentId);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public String resolveOnlinePlayerName(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        AtomicReference<Object> resolved = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        this.runSync(() -> {
            try {
                Player player = this.resolvePlayer(name);
                if (player != null) {
                    resolved.set(player.getName());
                }
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return resolved.get();
    }

    private void cleanupAgents() {
        if (this.agents.isEmpty()) {
            return;
        }
        this.runSync(() -> {
            this.agents.values().forEach(entry -> {
                Entity entity = Bukkit.getEntity((UUID)entry.entityId());
                if (entity != null) {
                    entity.remove();
                }
            });
            this.agents.clear();
        });
    }

    private Player resolvePlayer(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        Player exact = this.getServer().getPlayerExact(name);
        if (exact != null) {
            return exact;
        }
        return this.getServer().getPlayer(name);
    }

    private ArmorStand spawnAgent(String ownerKey, String agentId, Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return null;
        }
        Location target = this.normalizeLocation(loc);
        return (ArmorStand)world.spawn(target, ArmorStand.class, spawned -> {
            spawned.setCustomName(String.valueOf(ChatColor.GRAY) + ownerKey + "." + agentId + String.valueOf(ChatColor.RESET));
            spawned.setCustomNameVisible(true);
            spawned.setInvisible(false);
            spawned.setMarker(false);
            spawned.setGravity(false);
            spawned.setArms(true);
            spawned.setBasePlate(false);
            spawned.setSmall(true);
            spawned.setGlowing(true);
            spawned.setInvulnerable(true);
            spawned.setRemoveWhenFarAway(false);
            spawned.setCollidable(false);
            EntityEquipment equipment = spawned.getEquipment();
            if (equipment != null) {
                equipment.clear();
                equipment.setHelmet(this.createGolemHead());
                equipment.setChestplate(new ItemStack(Material.IRON_CHESTPLATE));
                equipment.setLeggings(new ItemStack(Material.LEATHER_LEGGINGS));
                equipment.setBoots(new ItemStack(Material.LEATHER_BOOTS));
            }
        });
    }

    private ItemStack createLeatherArmor(Material type) {
        ItemStack item = new ItemStack(type);
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        if (meta != null) {
            meta.setColor(Color.fromRGB((int)200, (int)200, (int)200));
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    private ItemStack createGolemHead() {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            OfflinePlayer owner = Bukkit.getOfflinePlayer((String)"MHF_Golem");
            meta.setOwningPlayer(owner);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    private ArmorStand getAgentEntity(UUID uuid) {
        ArmorStand stand;
        if (uuid == null) {
            return null;
        }
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entity instanceof ArmorStand && !(stand = (ArmorStand)entity).isDead()) {
            return stand;
        }
        this.agents.values().removeIf(entry -> entry.entityId().equals(uuid));
        return null;
    }

    private Location normalizeLocation(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return loc;
        }
        double x = Math.floor(loc.getX()) + 0.5;
        double z = Math.floor(loc.getZ()) + 0.5;
        double y = Math.floor(loc.getY()) + 0.0;
        return new Location(loc.getWorld(), x, y, z);
    }

    private void runSync(Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)this, runnable);
        }
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void logDebug(String message) {
        if (this.debug) {
            this.getLogger().info("[debug] " + message);
        }
    }

    private boolean isTrackedEntity(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return this.agents.values().stream().anyMatch(entry -> entry.entityId().equals(uuid));
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractAtEntityEvent event) {
        if (this.isTrackedEntity(event.getRightClicked().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (this.isTrackedEntity(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    private void animateAgentMove(final ArmorStand stand) {
        final EulerAngle armForward = new EulerAngle(Math.toRadians(-35.0), 0.0, Math.toRadians(5.0));
        final EulerAngle armBackward = new EulerAngle(Math.toRadians(35.0), 0.0, Math.toRadians(-5.0));
        final EulerAngle legForward = new EulerAngle(Math.toRadians(20.0), 0.0, 0.0);
        final EulerAngle legBackward = new EulerAngle(Math.toRadians(-20.0), 0.0, 0.0);
        new BukkitRunnable(this){
            private int ticks = 0;
            private boolean flip = false;

            public void run() {
                if (!stand.isValid() || stand.isDead()) {
                    this.cancel();
                    return;
                }
                this.flip = !this.flip;
                this.applyPose(this.flip);
                ++this.ticks;
                if (this.ticks >= 6) {
                    this.resetPose();
                    this.cancel();
                }
            }

            private void applyPose(boolean variant) {
                if (variant) {
                    stand.setLeftArmPose(armForward);
                    stand.setRightArmPose(armBackward);
                    stand.setLeftLegPose(legBackward);
                    stand.setRightLegPose(legForward);
                } else {
                    stand.setLeftArmPose(armBackward);
                    stand.setRightArmPose(armForward);
                    stand.setLeftLegPose(legForward);
                    stand.setRightLegPose(legBackward);
                }
            }

            private void resetPose() {
                EulerAngle zero = new EulerAngle(0.0, 0.0, 0.0);
                stand.setLeftArmPose(zero);
                stand.setRightArmPose(zero);
                stand.setLeftLegPose(zero);
                stand.setRightLegPose(zero);
            }
        }.runTaskTimer((Plugin)this, 0L, 2L);
    }

    private Location normalizeAgentTarget(Location raw, Location reference) {
        if (raw == null || raw.getWorld() == null) {
            return raw;
        }
        double x = Math.floor(raw.getX()) + 0.5;
        double z = Math.floor(raw.getZ()) + 0.5;
        double y = Math.floor(raw.getY());
        Location normalized = new Location(raw.getWorld(), x, y, z);
        if (reference != null) {
            normalized.setYaw(reference.getYaw());
            normalized.setPitch(reference.getPitch());
        }
        return normalized;
    }

    private Vector resolveDirectionVector(Location origin, String direction) {
        if (origin == null) {
            return null;
        }
        Vector forward = origin.getDirection();
        if (forward == null || forward.lengthSquared() < 1.0E-4) {
            forward = new Vector(0, 0, 1);
        }
        forward.setY(0);
        if (forward.lengthSquared() < 1.0E-4) {
            forward = new Vector(0, 0, 1);
        } else {
            forward.normalize();
        }
        Vector right = forward.clone().crossProduct(new Vector(0, 1, 0));
        if (right.lengthSquared() < 1.0E-4) {
            right = new Vector(1, 0, 0);
        } else {
            right.normalize();
        }
        return switch (direction) {
            case "forward" -> forward;
            case "back" -> forward.clone().multiply(-1);
            case "right" -> right;
            case "left" -> right.clone().multiply(-1);
            default -> null;
        };
    }

    private String normalizeDirection(String direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction.trim().toLowerCase(Locale.ROOT)) {
            case "forward", "back", "right", "left" -> direction.trim().toLowerCase(Locale.ROOT);
            default -> null;
        };
    }

    private static String agentMapKey(String ownerName, String agentId) {
        String ownerPart = ownerName == null ? "" : ownerName.trim().toLowerCase(Locale.ROOT);
        String agentPart = agentId == null ? "" : agentId.trim();
        return ownerPart + "." + agentPart;
    }

    private static String firstNonBlank(String ... candidates) {
        for (String c : candidates) {
            if (c == null || c.isBlank()) continue;
            return c;
        }
        return null;
    }

    private static String chooseClientHost(String ... candidates) {
        for (String candidate : candidates) {
            String normalized;
            if (candidate == null || candidate.isBlank() || TwBridgePlugin.isAnyAddress(normalized = candidate.trim())) continue;
            return normalized;
        }
        return "127.0.0.1";
    }

    private static boolean isAnyAddress(String host) {
        String normalized = host.trim();
        return normalized.equals("0.0.0.0") || normalized.equals("::") || normalized.equals("::0") || normalized.equals("*");
    }

    private static String buildWsDefaultUrl(String host, int port) {
        String effectiveHost = host == null || host.isBlank() ? "127.0.0.1" : host;
        boolean bracketed = effectiveHost.startsWith("[") && effectiveHost.endsWith("]");
        boolean needsBrackets = effectiveHost.contains(":") && !bracketed;
        Object normalizedHost = needsBrackets ? "[" + effectiveHost + "]" : effectiveHost;
        return "ws://" + (String)normalizedHost + ":" + port;
    }

    private record AgentEntry(UUID entityId, String owner) {
    }
}

