/*
 * Decompiled with CFR 0.152.
 */
package net.nando256.turboagent;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.nando256.turboagent.http.StaticHttpServer;
import net.nando256.turboagent.ws.BridgeServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.SoundGroup;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.json.JSONObject;

public final class TwBridgePlugin
extends JavaPlugin
implements Listener {
    private BridgeServer wsServer;
    private StaticHttpServer httpServer;
    private final Map<String, AgentEntry> agents = new ConcurrentHashMap<String, AgentEntry>();
    private final Map<String, AgentInventory> agentInventories = new ConcurrentHashMap<String, AgentInventory>();
    private final Map<String, MagicToken> magicTokens = new ConcurrentHashMap<String, MagicToken>();
    private final SecureRandom tokenRng = new SecureRandom();
    private boolean debug;
    private boolean magicLinkEnabled;
    private boolean requireSession;
    private boolean allowLegacyPairing;
    private int magicTokenTtlSeconds;
    private String magicLinkBaseUrl;
    private String magicLinkExtensionTemplate;
    private String wsBindAddress;
    private int wsPort;
    private boolean httpEnabled;
    private String httpBindAddress;
    private int httpPort;
    private String defaultLang;
    private String promptLangDefault = "en";
    private String defaultBranch;
    private String blockChoicesJson;
    private String eggChoicesJson;
    private boolean downloadTurbowarp;
    private String turbowarpZipUrl;
    private boolean forceDownloadOnStart;
    private Path externalTurbowarpRoot;
    private final String customAssetBase = "turbowarp-custom/";
    private Map<String, byte[]> staticOverrides = Map.of();
    private Map<String, PromptLocale> promptLocales = Map.of();

    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.applyConfigAndStart();
    }

    public void onDisable() {
        this.stopServers();
    }

    private void applyConfigAndStart() {
        String wsAddr;
        this.stopServers();
        this.debug = this.getConfig().getBoolean("debug", false);
        this.logDebug("Debug mode enabled");
        this.magicLinkEnabled = this.getConfig().getBoolean("magicLink.enabled", true);
        this.requireSession = this.getConfig().getBoolean("ws.requireSession", true);
        this.allowLegacyPairing = false;
        this.magicTokenTtlSeconds = Math.max(30, this.getConfig().getInt("magicLink.tokenTtlSeconds", 300));
        this.defaultLang = TwBridgePlugin.sanitizeLang(this.getConfig().getString("magicLink.defaultLang"), "en");
        this.defaultBranch = TwBridgePlugin.sanitizeBranchValue(this.getConfig().getString("magicLink.defaultBranch"), "main");
        this.magicTokens.clear();
        this.blockChoicesJson = this.buildBlockChoicesJson();
        this.eggChoicesJson = this.buildEggChoicesJson();
        this.staticOverrides = this.prepareStaticOverrides();
        this.promptLocales = this.loadPromptLocales();
        this.downloadTurbowarp = this.getConfig().getBoolean("turbowarp.download.enabled", true);
        this.turbowarpZipUrl = TwBridgePlugin.firstNonBlank(this.getConfig().getString("turbowarp.download.zipUrl"), "https://github.com/nando256/TurboAgent/releases/download/v3.0.0/www-client.zip");
        this.forceDownloadOnStart = this.getConfig().getBoolean("turbowarp.download.forceOnStart", false);
        this.externalTurbowarpRoot = this.prepareExternalTurbowarp();
        this.wsBindAddress = wsAddr = TwBridgePlugin.firstNonBlank(this.getConfig().getString("ws.bindAddress"), this.getConfig().getString("ws.address"), "0.0.0.0");
        this.wsPort = this.getConfig().getInt("ws.port", 8787);
        int rate = this.getConfig().getInt("ws.maxMsgPerSecond", 30);
        int maxBytes = this.getConfig().getInt("ws.maxMsgBytes", 8192);
        HashSet<String> origins = new HashSet<String>(this.getConfig().getStringList("ws.originWhitelist"));
        boolean pairingRequired = this.getConfig().getBoolean("ws.requirePairing", this.getConfig().getBoolean("pairing.enabled", true));
        int pairWindowSec = this.getConfig().getInt("pairing.windowSeconds", 60);
        this.httpEnabled = this.getConfig().getBoolean("http.enabled", true);
        this.httpBindAddress = TwBridgePlugin.firstNonBlank(this.getConfig().getString("http.bindAddress"), "0.0.0.0");
        this.httpPort = this.getConfig().getInt("http.port", 8788);
        try {
            this.wsServer = new BridgeServer(this, wsAddr, this.wsPort, origins, rate, maxBytes, pairingRequired, pairWindowSec, this.requireSession, this.allowLegacyPairing);
            this.wsServer.setReuseAddr(true);
            this.wsServer.start();
            this.getLogger().info("WS: ws://" + wsAddr + ":" + this.wsPort);
        }
        catch (Exception e) {
            this.getLogger().severe("WS Server Failed: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.httpEnabled) {
            int cacheSeconds = Math.max(0, this.getConfig().getInt("http.cacheSeconds", 300));
            try {
                this.httpServer = new StaticHttpServer(this, this.httpBindAddress, this.httpPort, "turbowarp/", cacheSeconds, this.staticOverrides, this.externalTurbowarpRoot);
                this.httpServer.start();
                this.getLogger().info("HTTP: http://" + this.httpBindAddress + ":" + this.httpPort + "/ (" + (String)(this.externalTurbowarpRoot != null ? "fs " + String.valueOf(this.externalTurbowarpRoot) : "classpath") + ")");
            }
            catch (Exception e) {
                this.getLogger().severe("HTTP Server Failed: " + e.getMessage());
            }
        }
    }

    private void stopServers() {
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.httpServer = null;
        }
        if (this.wsServer != null) {
            try {
                this.wsServer.stop(1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wsServer = null;
        }
        this.cleanupAgents();
        this.magicTokens.clear();
    }

    public boolean onCommand(CommandSender s, Command c, String l, String[] a) {
        String cmdName = c.getName().toLowerCase(Locale.ROOT);
        if ("tw".equals(cmdName)) {
            return this.handleMagicLinkCommand(s, a);
        }
        return false;
    }

    private Map<String, PromptLocale> loadPromptLocales() {
        HashMap<String, PromptLocale> map = new HashMap<String, PromptLocale>();
        map.put("en", PromptLocale.defaultEn());
        map.put("ja", PromptLocale.defaultJa());
        this.loadPromptLocaleFromResource("locale/prompt/en.json", map);
        this.loadPromptLocaleFromResource("locale/prompt/ja.json", map);
        return map;
    }

    private void loadPromptLocaleFromResource(String path, Map<String, PromptLocale> sink) {
        try (InputStream is = this.getResource(path);){
            if (is == null) {
                return;
            }
            JSONObject json = new JSONObject(new String(is.readAllBytes(), StandardCharsets.UTF_8));
            PromptLocale loc = PromptLocale.fromJson(json);
            if (loc != null && loc.key != null && !loc.key.isBlank()) {
                sink.put(loc.key, loc);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to load prompt locale " + path + ": " + e.getMessage());
        }
    }

    private boolean handleMagicLinkCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Player only command");
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("turboagent.link")) {
            sender.sendMessage("No permission");
            return true;
        }
        if (!this.magicLinkEnabled) {
            sender.sendMessage("Magic link is disabled in config");
            return true;
        }
        String firstArg = args != null && args.length > 0 ? args[0] : null;
        boolean testMode = firstArg != null && firstArg.equalsIgnoreCase("test");
        String link = this.buildMagicLink(player, null, testMode);
        if (link == null || link.isBlank()) {
            sender.sendMessage("Failed to create link");
            return true;
        }
        try {
            TextComponent clickable = new TextComponent("[TurboAgent] TurboWarp link: ");
            clickable.setColor(ChatColor.AQUA);
            TextComponent linkPart = new TextComponent(link);
            linkPart.setColor(ChatColor.AQUA);
            linkPart.setUnderlined(Boolean.valueOf(true));
            linkPart.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
            linkPart.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("Click to open").create()));
            clickable.addExtra((BaseComponent)linkPart);
            player.spigot().sendMessage((BaseComponent)clickable);
        }
        catch (Exception ignored) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.AQUA) + "[TurboAgent] TurboWarp link: " + String.valueOf(org.bukkit.ChatColor.UNDERLINE) + link);
        }
        return true;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.magicLinkEnabled) {
            return;
        }
        if (!player.hasPermission("turboagent.link")) {
            return;
        }
        String link = this.buildMagicLink(player, null, false);
        if (link == null || link.isBlank()) {
            return;
        }
        this.sendMagicPrompt(player, link);
    }

    private void sendMagicPrompt(Player player, String link) {
        String lang = TwBridgePlugin.sanitizeLang(player == null ? null : player.getLocale(), this.promptLangDefault);
        PromptLocale locale = this.resolvePromptLocale(lang);
        try {
            TextComponent prefix = new TextComponent(locale.prompt);
            prefix.setColor(ChatColor.AQUA);
            TextComponent yes = new TextComponent(locale.yes);
            yes.setColor(ChatColor.GREEN);
            yes.setBold(Boolean.valueOf(true));
            yes.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
            yes.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(locale.hover).create()));
            TextComponent no = new TextComponent(" " + locale.no);
            no.setColor(ChatColor.GRAY);
            prefix.addExtra((BaseComponent)yes);
            prefix.addExtra((BaseComponent)no);
            player.spigot().sendMessage((BaseComponent)prefix);
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.GRAY) + locale.clickHint);
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.GRAY) + locale.adblockHint);
        }
        catch (Exception e) {
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.AQUA) + locale.prompt + " " + String.valueOf(org.bukkit.ChatColor.UNDERLINE) + link);
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.GRAY) + locale.clickHint);
            player.sendMessage(String.valueOf(org.bukkit.ChatColor.GRAY) + locale.adblockHint);
        }
    }

    private PromptLocale resolvePromptLocale(String lang) {
        String normalized = TwBridgePlugin.sanitizeLang(lang, this.promptLangDefault);
        PromptLocale exact = this.promptLocales.get(normalized);
        if (exact != null) {
            return exact;
        }
        String base = normalized.contains("-") ? normalized.substring(0, normalized.indexOf(45)) : normalized;
        PromptLocale baseLocale = this.promptLocales.get(base);
        if (baseLocale != null) {
            return baseLocale;
        }
        return this.promptLocales.getOrDefault(this.promptLangDefault, PromptLocale.defaultEn());
    }

    public void handleCommand(String command, Runnable onSuccess, Consumer<String> onFailure) {
        if (command == null || command.isBlank()) {
            if (onFailure != null) {
                onFailure.accept("command required");
            }
            return;
        }
        this.logDebug("Executing command: " + command);
        this.runSync(() -> {
            block6: {
                try {
                    boolean success = this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
                    this.logDebug("Command result: " + success);
                    if (success) {
                        if (onSuccess != null) {
                            onSuccess.run();
                        }
                    } else if (onFailure != null) {
                        onFailure.accept("command failed");
                    }
                }
                catch (Exception e) {
                    this.getLogger().warning("Bridge command failed: " + e.getMessage());
                    if (onFailure == null) break block6;
                    onFailure.accept(e.getMessage());
                }
            }
        });
    }

    private String buildMagicLink(Player player, String branchOverride, boolean testMode) {
        String token = this.issueMagicToken(player == null ? null : player.getName());
        if (token == null) {
            return null;
        }
        String lang = this.chooseMagicLang(player);
        String httpHost = this.resolveHttpHost(player);
        String hostForPlayer = this.resolveAdvertisedHost(player);
        String extensionUrl = testMode ? this.resolveTestExtensionUrl(httpHost) : this.resolveExtensionUrl(lang, httpHost);
        String wsUrl = TwBridgePlugin.buildWsDefaultUrl(hostForPlayer, this.wsPort, "ws");
        if (!this.httpEnabled) {
            this.getLogger().warning("HTTP server disabled; cannot create magic link.");
            return null;
        }
        String base = "http://" + httpHost + ":" + this.httpPort + "/editor.html";
        Object extWithQuery = extensionUrl;
        extWithQuery = testMode ? extensionUrl + (extensionUrl.contains("?") ? "&" : "?") + "lang=" + TwBridgePlugin.encodeComponent(lang) : extensionUrl + (extensionUrl.contains("?") ? "&" : "?") + "host=" + TwBridgePlugin.encodeComponent(wsUrl) + "&token=" + TwBridgePlugin.encodeComponent(token) + "&lang=" + TwBridgePlugin.encodeComponent(lang);
        String encodedExt = TwBridgePlugin.encodeComponent((String)extWithQuery);
        if (encodedExt == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(base);
        builder.append(base.contains("?") ? "&" : "?").append("extension=").append(encodedExt);
        return builder.toString();
    }

    private String resolveExtensionUrl(String lang, String httpHost) {
        return "http://" + httpHost + ":" + this.httpPort + "/turboagent.js";
    }

    private String resolveTestExtensionUrl(String httpHost) {
        return "http://" + httpHost + ":" + this.httpPort + "/turboagent-test.js";
    }

    private String ensureHost(String host) {
        if (host == null || host.isBlank() || TwBridgePlugin.isAnyAddress(host) || TwBridgePlugin.isLoopbackHost(host)) {
            String detected = TwBridgePlugin.detectLocalIp();
            if (detected != null && !detected.isBlank()) {
                return detected;
            }
            return "127.0.0.1";
        }
        return host;
    }

    private String resolveHttpHost(Player player) {
        if (this.isUsableSpecificHost(this.httpBindAddress)) {
            return this.ensureHost(this.httpBindAddress);
        }
        return this.ensureHost(this.resolveHttpAdvertisedHost(player));
    }

    private String issueMagicToken(String playerName) {
        if (playerName == null || playerName.isBlank()) {
            return null;
        }
        this.purgeExpiredTokens();
        byte[] buf = new byte[24];
        this.tokenRng.nextBytes(buf);
        String token = Base64.getUrlEncoder().withoutPadding().encodeToString(buf);
        long expires = System.currentTimeMillis() + (long)this.magicTokenTtlSeconds * 1000L;
        this.magicTokens.put(token, new MagicToken(playerName, expires));
        return token;
    }

    public String consumeMagicToken(String token) {
        if (token == null || token.isBlank()) {
            return null;
        }
        this.purgeExpiredTokens();
        MagicToken entry = this.magicTokens.remove(token);
        if (entry == null) {
            return null;
        }
        if (entry.expiresAt() < System.currentTimeMillis()) {
            return null;
        }
        return entry.player();
    }

    private void purgeExpiredTokens() {
        long now = System.currentTimeMillis();
        this.magicTokens.entrySet().removeIf(e -> e.getValue() == null || ((MagicToken)e.getValue()).expiresAt() < now);
    }

    private String chooseMagicLang(Player player) {
        String base;
        String requested = TwBridgePlugin.sanitizeLang(player == null ? null : player.getLocale(), this.defaultLang);
        if (this.hasLocaleForLang(requested)) {
            return requested;
        }
        String string = base = requested.contains("-") ? requested.substring(0, requested.indexOf(45)) : requested;
        if (this.hasLocaleForLang(base)) {
            return base;
        }
        if (this.hasLocaleForLang(this.defaultLang)) {
            return this.defaultLang;
        }
        return "en";
    }

    private String resolveAdvertisedHost(Player player) {
        String serverIp;
        if (this.isUsableSpecificHost(this.wsBindAddress)) {
            return this.wsBindAddress.trim();
        }
        if (player != null && player.getAddress() != null && player.getAddress().getAddress() != null) {
            String localFromChannel = this.localAddressFromPlayer(player);
            if (localFromChannel != null && !localFromChannel.isBlank()) {
                return localFromChannel;
            }
            String remoteHost = player.getAddress().getAddress().getHostAddress();
            String routed = this.localAddressForRemote(remoteHost);
            if (routed != null && !routed.isBlank()) {
                return routed;
            }
            String matched = this.findLocalForRemote(remoteHost);
            if (matched != null && !matched.isBlank()) {
                return matched;
            }
        }
        String string = serverIp = this.getServer() == null ? null : this.getServer().getIp();
        if (!(serverIp == null || serverIp.isBlank() || TwBridgePlugin.isAnyAddress(serverIp) || TwBridgePlugin.isLoopbackHost(serverIp))) {
            return serverIp.trim();
        }
        String detected = TwBridgePlugin.detectLocalIp();
        if (!(detected == null || detected.isBlank() || TwBridgePlugin.isLoopbackHost(detected) || TwBridgePlugin.isAnyAddress(detected))) {
            return detected;
        }
        return "127.0.0.1";
    }

    private String resolveHttpAdvertisedHost(Player player) {
        String serverIp;
        if (player != null && player.getAddress() != null && player.getAddress().getAddress() != null) {
            String localFromChannel = this.localAddressFromPlayer(player);
            if (localFromChannel != null && !localFromChannel.isBlank()) {
                return localFromChannel;
            }
            String remoteHost = player.getAddress().getAddress().getHostAddress();
            String routed = this.localAddressForRemote(remoteHost);
            if (routed != null && !routed.isBlank()) {
                return routed;
            }
            String matched = this.findLocalForRemote(remoteHost);
            if (matched != null && !matched.isBlank()) {
                return matched;
            }
        }
        String string = serverIp = this.getServer() == null ? null : this.getServer().getIp();
        if (!(serverIp == null || serverIp.isBlank() || TwBridgePlugin.isAnyAddress(serverIp) || TwBridgePlugin.isLoopbackHost(serverIp))) {
            return serverIp.trim();
        }
        String detected = TwBridgePlugin.detectLocalIp();
        if (!(detected == null || detected.isBlank() || TwBridgePlugin.isLoopbackHost(detected) || TwBridgePlugin.isAnyAddress(detected))) {
            return detected;
        }
        return "127.0.0.1";
    }

    private String findLocalForRemote(String remoteHost) {
        if (remoteHost == null || remoteHost.isBlank()) {
            return null;
        }
        try {
            InetAddress remote = InetAddress.getByName(remoteHost.trim());
            if (!(remote instanceof Inet4Address)) {
                return null;
            }
            Inet4Address remote4 = (Inet4Address)remote;
            int remoteInt = ByteBuffer.wrap(remote4.getAddress()).getInt();
            int mask = -256;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces != null && ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface == null || !iface.isUp() || iface.isLoopback()) continue;
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    int localInt;
                    Inet4Address local4;
                    InetAddress addr = addrs.nextElement();
                    if (!(addr instanceof Inet4Address) || (local4 = (Inet4Address)addr).isLoopbackAddress() || local4.isAnyLocalAddress() || local4.isLinkLocalAddress() || ((localInt = ByteBuffer.wrap(local4.getAddress()).getInt()) & mask) != (remoteInt & mask)) continue;
                    return local4.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean hasLocaleForLang(String lang) {
        boolean bl;
        block9: {
            if (lang == null || lang.isBlank()) {
                return false;
            }
            String path = "turbowarp/locale/" + lang + ".json";
            InputStream ignored = this.getResource(path);
            try {
                boolean bl2 = bl = ignored != null;
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    private static String sanitizeBranchValue(String raw, String fallback) {
        String fb;
        String string = fb = fallback == null || fallback.isBlank() ? "main" : fallback.trim();
        if (raw == null) {
            return fb;
        }
        String normalized = raw.trim();
        if (normalized.isBlank() || normalized.length() > 48) {
            return fb;
        }
        if (!normalized.matches("[A-Za-z0-9._-]{1,48}")) {
            return fb;
        }
        return normalized;
    }

    public String getBlockChoicesJson() {
        if (this.blockChoicesJson != null && !this.blockChoicesJson.isBlank()) {
            return this.blockChoicesJson;
        }
        return "[[\"stone\",\"stone\"],[\"dirt\",\"dirt\"],[\"cobblestone\",\"cobblestone\"]]";
    }

    public String getEggChoicesJson() {
        if (this.eggChoicesJson != null && !this.eggChoicesJson.isBlank()) {
            return this.eggChoicesJson;
        }
        return "[[\"Cow Spawn Egg\",\"cow_spawn_egg\"],[\"Pig Spawn Egg\",\"pig_spawn_egg\"]]";
    }

    private String buildBlockChoicesJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Material material : Material.values()) {
            if (!material.isBlock() || !material.isItem() || material.isAir()) continue;
            String id = material.getKey().getKey();
            String name = TwBridgePlugin.humanizeMaterialName(id);
            if (!first) {
                sb.append(",");
            }
            sb.append("[\"").append(TwBridgePlugin.escapeJson(name)).append("\",\"").append(TwBridgePlugin.escapeJson(id)).append("\"]");
            first = false;
        }
        if (first) {
            sb.append("[\"stone\",\"stone\"],[\"dirt\",\"dirt\"],[\"cobblestone\",\"cobblestone\"]");
        }
        sb.append("]");
        return sb.toString();
    }

    private String buildEggChoicesJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Material material : Material.values()) {
            String key;
            if (!material.isItem() || !(key = material.getKey().getKey()).endsWith("_spawn_egg")) continue;
            String name = TwBridgePlugin.humanizeMaterialName(key);
            if (!first) {
                sb.append(",");
            }
            sb.append("[\"").append(TwBridgePlugin.escapeJson(name)).append("\",\"").append(TwBridgePlugin.escapeJson(key)).append("\"]");
            first = false;
        }
        if (first) {
            sb.append("[\"Cow Spawn Egg\",\"cow_spawn_egg\"],[\"Pig Spawn Egg\",\"pig_spawn_egg\"]");
        }
        sb.append("]");
        return sb.toString();
    }

    private Map<String, byte[]> prepareStaticOverrides() {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        this.prepareWithBlocks("turbowarp-custom/turboagent.js", map);
        this.prepareWithBlocks("turbowarp-custom/turboagent-test.js", map);
        return map;
    }

    private void prepareWithBlocks(String resourcePath, Map<String, byte[]> sink) {
        try (InputStream is = this.getResource(resourcePath);){
            if (is == null) {
                return;
            }
            String body = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            if (body.contains("__BLOCK_LIST__")) {
                body = body.replace("__BLOCK_LIST__", this.blockChoicesJson);
            }
            if (body.contains("__EGG_LIST__")) {
                body = body.replace("__EGG_LIST__", this.eggChoicesJson);
            }
            sink.put(resourcePath.replace("turbowarp/", ""), body.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to prepare static resource " + resourcePath + ": " + e.getMessage());
        }
    }

    private static String humanizeMaterialName(String key) {
        if (key == null || key.isBlank()) {
            return "";
        }
        String[] parts = key.split("_");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            if (part.isBlank()) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            builder.append(part.substring(1));
        }
        return builder.toString();
    }

    private static String escapeJson(String raw) {
        if (raw == null) {
            return "";
        }
        return raw.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private void playPlacementSound(Material material, Location loc) {
        if (material == null || loc == null || loc.getWorld() == null) {
            return;
        }
        try {
            SoundGroup sg;
            Sound sound;
            BlockData data = material.createBlockData();
            if (data != null && data.getSoundGroup() != null && (sound = (sg = data.getSoundGroup()).getPlaceSound()) != null) {
                loc.getWorld().playSound(loc, sound, sg.getVolume(), sg.getPitch());
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        loc.getWorld().playSound(loc, Sound.BLOCK_STONE_PLACE, 1.0f, 1.0f);
    }

    private boolean isSpawnEgg(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        if (type != null && type.name().toLowerCase(Locale.ROOT).endsWith("_spawn_egg")) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        return meta instanceof SpawnEggMeta;
    }

    private Entity spawnFromEgg(ItemStack egg, Location loc) {
        try {
            String key;
            Material mat;
            EntityType type = null;
            ItemMeta meta = egg.getItemMeta();
            if (meta instanceof SpawnEggMeta) {
                SpawnEggMeta sem = (SpawnEggMeta)meta;
                try {
                    Method method = sem.getClass().getMethod("getCustomSpawnedType", new Class[0]);
                    Object res = method.invoke((Object)sem, new Object[0]);
                    if (res instanceof EntityType) {
                        EntityType t;
                        type = t = (EntityType)res;
                    }
                }
                catch (Exception ignored) {
                    try {
                        Method m = sem.getClass().getMethod("getSpawnedType", new Class[0]);
                        Object res = m.invoke((Object)sem, new Object[0]);
                        if (res instanceof EntityType) {
                            EntityType t;
                            type = t = (EntityType)res;
                        }
                    }
                    catch (Exception m) {
                        // empty catch block
                    }
                }
            }
            if (type == null && (mat = egg.getType()) != null && (key = mat.getKey().getKey()).endsWith("_spawn_egg")) {
                String base = key.substring(0, key.length() - "_spawn_egg".length()).toUpperCase(Locale.ROOT);
                try {
                    type = EntityType.valueOf((String)base);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (type == null) {
                return null;
            }
            World world = loc.getWorld();
            if (world == null) {
                return null;
            }
            return world.spawnEntity(loc, type);
        }
        catch (Exception e) {
            this.getLogger().warning("Spawn from egg failed: " + e.getMessage());
            return null;
        }
    }

    private static String encodeComponent(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8).replace("+", "%20");
        }
        catch (Exception e) {
            return "";
        }
    }

    public void handleAgentTeleportToPlayer(String agentId, String ownerName, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            Player player = this.resolvePlayer(ownerName);
            if (player == null) {
                this.logDebug("Teleport failed: player '" + ownerName + "' not found");
                if (onFailure != null) {
                    onFailure.accept("player not found");
                }
                return;
            }
            String ownerKey = player.getName();
            String agentKey = TwBridgePlugin.agentMapKey(ownerKey, agentId);
            this.logDebug("Teleport agent " + agentId + " for " + ownerKey);
            AgentEntry existing = this.agents.get(agentKey);
            ArmorStand stand = existing == null ? null : this.getAgentEntity(existing.entityId());
            AgentInventory inventory = this.agentInventories.computeIfAbsent(agentKey, k -> new AgentInventory());
            Location target = this.normalizeLocation(player.getLocation());
            if (stand == null) {
                this.logDebug("Spawning new agent " + agentId);
                stand = this.spawnAgent(ownerKey, agentId, target);
                if (stand == null) {
                    this.logDebug("Spawning agent failed (spawnAgent returned null)");
                    if (onFailure != null) {
                        onFailure.accept("spawn failed");
                    }
                    return;
                }
                this.agents.put(agentKey, new AgentEntry(stand.getUniqueId(), ownerKey));
            } else {
                this.logDebug("Teleporting existing agent " + agentId);
                stand.teleport(target);
            }
            this.resetFacingForward(stand);
            this.applyActiveSlotToStand(stand, inventory);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentMove(String agentId, String ownerName, String direction, double blocks, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry entry = this.agents.get(agentKey);
            if (entry == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            if (!entry.owner().equalsIgnoreCase(ownerName)) {
                if (onFailure != null) {
                    onFailure.accept("agent owned by another player");
                }
                return;
            }
            ArmorStand stand = this.getAgentEntity(entry.entityId());
            if (stand == null) {
                this.agents.remove(agentKey);
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            String normalizedDirection = this.normalizeDirection(direction);
            if (normalizedDirection == null) {
                if (onFailure != null) {
                    onFailure.accept("invalid direction");
                }
                return;
            }
            double distance = Math.max(0.0, Math.min(Math.abs(blocks), 64.0));
            if (distance < 0.01) {
                if (onFailure != null) {
                    onFailure.accept("blocks must be greater than 0");
                }
                return;
            }
            Vector vector = this.resolveDirectionVector(stand.getLocation(), normalizedDirection);
            if (vector == null) {
                if (onFailure != null) {
                    onFailure.accept("unable to resolve direction");
                }
                return;
            }
            Location origin = stand.getLocation();
            Vector offset = vector.multiply(distance);
            Location target = this.normalizeAgentTarget(origin.clone().add(offset), origin);
            if (target == null) {
                if (onFailure != null) {
                    onFailure.accept("invalid target");
                }
                return;
            }
            this.animateAgentMove(stand);
            stand.teleport(target);
            this.resetFacingForward(stand);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentRotate(String agentId, String ownerName, String direction, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry entry = this.agents.get(agentKey);
            if (entry == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            if (!entry.owner().equalsIgnoreCase(ownerName)) {
                if (onFailure != null) {
                    onFailure.accept("agent owned by another player");
                }
                return;
            }
            ArmorStand stand = this.getAgentEntity(entry.entityId());
            if (stand == null) {
                this.agents.remove(agentKey);
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            String turnDir = this.normalizeTurnDirection(direction);
            if (turnDir == null) {
                if (onFailure != null) {
                    onFailure.accept("invalid direction");
                }
                return;
            }
            float delta = "left".equals(turnDir) ? -90.0f : 90.0f;
            Location loc = stand.getLocation();
            float newYaw = this.normalizeYaw(loc.getYaw() + delta);
            stand.teleport(new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), newYaw, loc.getPitch()));
            this.resetFacingForward(stand);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentFacePlayer(String agentId, String ownerName, String targetPlayerName, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            float yaw;
            String targetName;
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry entry = this.agents.get(agentKey);
            if (entry == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            if (!entry.owner().equalsIgnoreCase(ownerName)) {
                if (onFailure != null) {
                    onFailure.accept("agent owned by another player");
                }
                return;
            }
            ArmorStand stand = this.getAgentEntity(entry.entityId());
            if (stand == null) {
                this.agents.remove(agentKey);
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            String string = targetName = targetPlayerName == null ? "" : targetPlayerName.trim();
            if (targetName.isEmpty()) {
                if (onFailure != null) {
                    onFailure.accept("target player required");
                }
                return;
            }
            Player targetPlayer = this.resolvePlayer(targetName);
            if (targetPlayer == null) {
                if (onFailure != null) {
                    onFailure.accept("target player not found");
                }
                return;
            }
            Location standLoc = stand.getLocation();
            Location targetLoc = targetPlayer.getLocation();
            World standWorld = standLoc.getWorld();
            World targetWorld = targetLoc.getWorld();
            if (standWorld == null || targetWorld == null || !standWorld.equals((Object)targetWorld)) {
                if (onFailure != null) {
                    onFailure.accept("player not in same world");
                }
                return;
            }
            double standEyeY = standLoc.getY() + stand.getEyeHeight();
            double targetEyeY = targetLoc.getY() + targetPlayer.getEyeHeight();
            double dx = targetLoc.getX() - standLoc.getX();
            double dz = targetLoc.getZ() - standLoc.getZ();
            double dy = targetEyeY - standEyeY;
            double horiz = Math.sqrt(dx * dx + dz * dz);
            float f = yaw = horiz < 1.0E-4 ? standLoc.getYaw() : this.normalizeYaw((float)Math.toDegrees(Math.atan2(-dx, dz)));
            float pitch = horiz < 1.0E-4 ? (Math.abs(dy) < 1.0E-4 ? standLoc.getPitch() : (dy > 0.0 ? -90.0f : 90.0f)) : (float)Math.toDegrees(-Math.atan2(dy, horiz));
            if (pitch < -90.0f) {
                pitch = -90.0f;
            }
            if (pitch > 90.0f) {
                pitch = 90.0f;
            }
            stand.teleport(new Location(standWorld, standLoc.getX(), standLoc.getY(), standLoc.getZ(), yaw, pitch));
            EulerAngle slightTilt = new EulerAngle(Math.toRadians(-10.0), 0.0, 0.0);
            stand.setHeadPose(slightTilt);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentDespawn(String agentId, String ownerName, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry existing = this.agents.get(agentKey);
            if (existing == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            if (!existing.owner().equalsIgnoreCase(ownerName)) {
                if (onFailure != null) {
                    onFailure.accept("agent owned by another player");
                }
                return;
            }
            ArmorStand entity = this.getAgentEntity(existing.entityId());
            if (entity != null) {
                entity.remove();
            }
            this.agents.remove(agentKey);
            this.agentInventories.remove(agentKey);
            this.logDebug("Despawned agent " + agentId);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentSlotAssignBlock(String agentId, String ownerName, String blockId, int amount, int slot, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            if (slot < 1 || slot > 27) {
                if (onFailure != null) {
                    onFailure.accept("slot must be 1-27");
                }
                return;
            }
            if (amount < 1 || amount > 64) {
                if (onFailure != null) {
                    onFailure.accept("amount must be 1-64");
                }
                return;
            }
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry entry = this.agents.get(agentKey);
            if (entry == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            ArmorStand stand = this.getAgentEntity(entry.entityId());
            if (stand == null) {
                this.agents.remove(agentKey);
                this.agentInventories.remove(agentKey);
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            if (blockId == null || blockId.isBlank()) {
                if (onFailure != null) {
                    onFailure.accept("block required");
                }
                return;
            }
            Material material = Material.matchMaterial((String)blockId);
            if (material == null || !material.isItem()) {
                if (onFailure != null) {
                    onFailure.accept("invalid block");
                }
                return;
            }
            AgentInventory inventory = this.agentInventories.computeIfAbsent(agentKey, k -> new AgentInventory());
            inventory.slots[slot - 1] = new ItemStack(material, amount);
            if (inventory.activeSlot == slot - 1) {
                this.applyActiveSlotToStand(stand, inventory);
            }
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentSlotActivate(String agentId, String ownerName, int slot, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            if (slot < 1 || slot > 27) {
                if (onFailure != null) {
                    onFailure.accept("slot must be 1-27");
                }
                return;
            }
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry entry = this.agents.get(agentKey);
            if (entry == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            ArmorStand stand = this.getAgentEntity(entry.entityId());
            if (stand == null) {
                this.agents.remove(agentKey);
                this.agentInventories.remove(agentKey);
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            AgentInventory inventory = this.agentInventories.computeIfAbsent(agentKey, k -> new AgentInventory());
            inventory.activeSlot = slot - 1;
            this.applyActiveSlotToStand(stand, inventory);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public void handleAgentPlace(String agentId, String ownerName, String direction, Runnable onSuccess, Consumer<String> onFailure) {
        this.runSync(() -> {
            String agentKey = TwBridgePlugin.agentMapKey(ownerName, agentId);
            AgentEntry entry = this.agents.get(agentKey);
            if (entry == null) {
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            ArmorStand stand = this.getAgentEntity(entry.entityId());
            if (stand == null) {
                this.agents.remove(agentKey);
                this.agentInventories.remove(agentKey);
                if (onFailure != null) {
                    onFailure.accept("agent not found");
                }
                return;
            }
            AgentInventory inventory = this.agentInventories.get(agentKey);
            if (inventory == null || inventory.activeSlot < 0 || inventory.activeSlot >= inventory.slots.length) {
                if (onFailure != null) {
                    onFailure.accept("no active slot");
                }
                return;
            }
            ItemStack held = inventory.slots[inventory.activeSlot];
            if (held == null || held.getType() == null) {
                if (onFailure != null) {
                    onFailure.accept("active slot empty");
                }
                return;
            }
            Vector targetOffset = this.resolvePlaceOffset(stand.getLocation(), direction);
            if (targetOffset == null) {
                if (onFailure != null) {
                    onFailure.accept("invalid direction");
                }
                return;
            }
            Location targetLoc = stand.getLocation().clone().add(targetOffset);
            Block targetBlock = targetLoc.getBlock();
            if (targetBlock == null) {
                if (onFailure != null) {
                    onFailure.accept("invalid target");
                }
                return;
            }
            if (this.isSpawnEgg(held)) {
                if (!targetBlock.isEmpty() && targetBlock.getType().isSolid() && !targetBlock.isPassable()) {
                    if (onFailure != null) {
                        onFailure.accept("target not empty");
                    }
                    return;
                }
                Entity spawned = this.spawnFromEgg(held, targetBlock.getLocation().add(0.5, 0.0, 0.5));
                if (spawned == null) {
                    if (onFailure != null) {
                        onFailure.accept("spawn failed");
                    }
                    return;
                }
            } else {
                if (!held.getType().isBlock()) {
                    if (onFailure != null) {
                        onFailure.accept("active slot has no block");
                    }
                    return;
                }
                if (!targetBlock.isEmpty() && !targetBlock.getType().isAir()) {
                    if (onFailure != null) {
                        onFailure.accept("target not empty");
                    }
                    return;
                }
                targetBlock.setType(held.getType(), false);
                this.playPlacementSound(held.getType(), targetBlock.getLocation().add(0.5, 0.5, 0.5));
            }
            int newAmount = held.getAmount() - 1;
            inventory.slots[inventory.activeSlot] = newAmount > 0 ? new ItemStack(held.getType(), newAmount) : null;
            this.applyActiveSlotToStand(stand, inventory);
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
    }

    public String resolveOnlinePlayerName(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        AtomicReference<Object> resolved = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        this.runSync(() -> {
            try {
                Player player = this.resolvePlayer(name);
                if (player != null) {
                    resolved.set(player.getName());
                }
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return resolved.get();
    }

    private void cleanupAgents() {
        if (this.agents.isEmpty()) {
            return;
        }
        this.runSync(() -> {
            this.agents.values().forEach(entry -> {
                Entity entity = Bukkit.getEntity((UUID)entry.entityId());
                if (entity != null) {
                    entity.remove();
                }
            });
            this.agents.clear();
            this.agentInventories.clear();
        });
    }

    private Player resolvePlayer(String name) {
        if (name == null || name.isBlank()) {
            return null;
        }
        Player exact = this.getServer().getPlayerExact(name);
        if (exact != null) {
            return exact;
        }
        return this.getServer().getPlayer(name);
    }

    private ArmorStand spawnAgent(String ownerKey, String agentId, Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return null;
        }
        Location target = this.normalizeLocation(loc);
        return (ArmorStand)world.spawn(target, ArmorStand.class, spawned -> {
            spawned.setCustomName(String.valueOf(org.bukkit.ChatColor.GRAY) + ownerKey + "." + agentId + String.valueOf(org.bukkit.ChatColor.RESET));
            spawned.setCustomNameVisible(true);
            spawned.setInvisible(false);
            spawned.setMarker(false);
            spawned.setGravity(false);
            spawned.setArms(true);
            spawned.setBasePlate(false);
            spawned.setSmall(true);
            spawned.setGlowing(true);
            spawned.setInvulnerable(true);
            spawned.setRemoveWhenFarAway(false);
            spawned.setCollidable(false);
            EntityEquipment equipment = spawned.getEquipment();
            if (equipment != null) {
                equipment.clear();
                equipment.setHelmet(this.createGolemHead());
                equipment.setChestplate(new ItemStack(Material.IRON_CHESTPLATE));
                equipment.setLeggings(new ItemStack(Material.LEATHER_LEGGINGS));
                equipment.setBoots(new ItemStack(Material.LEATHER_BOOTS));
            }
        });
    }

    private ItemStack createLeatherArmor(Material type) {
        ItemStack item = new ItemStack(type);
        LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
        if (meta != null) {
            meta.setColor(Color.fromRGB((int)200, (int)200, (int)200));
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    private ItemStack createGolemHead() {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            OfflinePlayer owner = Bukkit.getOfflinePlayer((String)"MHF_Golem");
            meta.setOwningPlayer(owner);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    private ArmorStand getAgentEntity(UUID uuid) {
        ArmorStand stand;
        if (uuid == null) {
            return null;
        }
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entity instanceof ArmorStand && !(stand = (ArmorStand)entity).isDead()) {
            return stand;
        }
        this.agents.values().removeIf(entry -> entry.entityId().equals(uuid));
        return null;
    }

    private Path prepareExternalTurbowarp() {
        if (!this.downloadTurbowarp) {
            return null;
        }
        try {
            Path targetDir = new File(this.getDataFolder(), "turbowarp").toPath();
            if (this.forceDownloadOnStart && Files.exists(targetDir, new LinkOption[0])) {
                this.deleteRecursive(targetDir);
            }
            if (!Files.exists(targetDir, new LinkOption[0])) {
                Files.createDirectories(targetDir, new FileAttribute[0]);
                if (!this.downloadAndExtractTurbowarp(targetDir)) {
                    this.getLogger().warning("Failed to download TurboWarp assets; falling back to classpath resources.");
                    return null;
                }
            }
            this.overlayCustomAssets(targetDir);
            this.patchDownloadedAssets(targetDir);
            return targetDir;
        }
        catch (Exception e) {
            this.getLogger().warning("Preparing TurboWarp assets failed: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadAndExtractTurbowarp(Path targetDir) {
        this.getLogger().info("Downloading TurboWarp assets from " + this.turbowarpZipUrl);
        Path tmpZip = targetDir.resolveSibling("turbowarp.zip");
        try (InputStream in = this.openZipStream(this.turbowarpZipUrl);){
            if (in == null) {
                this.getLogger().warning("Download failed: cannot open " + this.turbowarpZipUrl);
                boolean bl = false;
                return bl;
            }
            Files.copy(in, tmpZip, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.getLogger().warning("Download failed: " + e.getMessage());
            return false;
        }
        try (ZipInputStream zipIn = new ZipInputStream(Files.newInputStream(tmpZip, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                Path outPath;
                String relative;
                String name = entry.getName();
                int idx = name.indexOf("turbowarp/");
                if (idx < 0 || (relative = name.substring(idx + "turbowarp/".length())).isEmpty() || !(outPath = targetDir.resolve(relative).normalize()).startsWith(targetDir)) continue;
                if (entry.isDirectory()) {
                    Files.createDirectories(outPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                Files.copy(zipIn, outPath, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (Exception e) {
            this.getLogger().warning("Extract failed: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                Files.deleteIfExists(tmpZip);
            }
            catch (Exception exception) {}
        }
    }

    private void patchDownloadedAssets(Path root) {
        this.patchFile(root.resolve("turboagent.js"));
        this.patchFile(root.resolve("turboagent-test.js"));
    }

    private void overlayCustomAssets(Path root) {
        this.copyResourceTo(root.resolve("turboagent.js"), "turbowarp-custom/turboagent.js");
        this.copyResourceTo(root.resolve("turboagent-test.js"), "turbowarp-custom/turboagent-test.js");
        this.copyResourceTo(root.resolve("locale/en.json"), "turbowarp-custom/locale/en.json");
        this.copyResourceTo(root.resolve("locale/ja.json"), "turbowarp-custom/locale/ja.json");
    }

    private void patchFile(Path file) {
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            return;
        }
        try {
            String body = Files.readString(file, StandardCharsets.UTF_8);
            boolean changed = false;
            if (body.contains("__BLOCK_LIST__")) {
                body = body.replace("__BLOCK_LIST__", this.blockChoicesJson);
                changed = true;
            }
            if (body.contains("__EGG_LIST__")) {
                body = body.replace("__EGG_LIST__", this.eggChoicesJson);
                changed = true;
            }
            if (changed) {
                Files.writeString(file, (CharSequence)body, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Patch failed for " + String.valueOf(file) + ": " + e.getMessage());
        }
    }

    private void copyResourceTo(Path dest, String resourcePath) {
        if (dest == null || resourcePath == null) {
            return;
        }
        try (InputStream is = this.getResource(resourcePath);){
            if (is == null) {
                return;
            }
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.copy(is, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to copy custom asset " + resourcePath + ": " + e.getMessage());
        }
    }

    private InputStream openZipStream(String urlOrPath) {
        if (urlOrPath == null || urlOrPath.isBlank()) {
            return null;
        }
        try {
            URL url = new URL(urlOrPath);
            return url.openStream();
        }
        catch (Exception ignored) {
            try {
                Path path = Path.of(urlOrPath, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    return Files.newInputStream(path, new OpenOption[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private void deleteRecursive(Path path) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.deleteIfExists(p);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Location normalizeLocation(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return loc;
        }
        double x = Math.floor(loc.getX()) + 0.5;
        double z = Math.floor(loc.getZ()) + 0.5;
        double y = Math.floor(loc.getY()) + 0.0;
        return new Location(loc.getWorld(), x, y, z);
    }

    private void runSync(Runnable runnable) {
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)this, runnable);
        }
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void logDebug(String message) {
        if (this.debug) {
            this.getLogger().info("[debug] " + message);
        }
    }

    private boolean isTrackedEntity(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return this.agents.values().stream().anyMatch(entry -> entry.entityId().equals(uuid));
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractAtEntityEvent event) {
        if (this.isTrackedEntity(event.getRightClicked().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (this.isTrackedEntity(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    private void animateAgentMove(final ArmorStand stand) {
        final EulerAngle armForward = new EulerAngle(Math.toRadians(-35.0), 0.0, Math.toRadians(5.0));
        final EulerAngle armBackward = new EulerAngle(Math.toRadians(35.0), 0.0, Math.toRadians(-5.0));
        final EulerAngle legForward = new EulerAngle(Math.toRadians(20.0), 0.0, 0.0);
        final EulerAngle legBackward = new EulerAngle(Math.toRadians(-20.0), 0.0, 0.0);
        new BukkitRunnable(this){
            private int ticks = 0;
            private boolean flip = false;

            public void run() {
                if (!stand.isValid() || stand.isDead()) {
                    this.cancel();
                    return;
                }
                this.flip = !this.flip;
                this.applyPose(this.flip);
                ++this.ticks;
                if (this.ticks >= 6) {
                    this.resetPose();
                    this.cancel();
                }
            }

            private void applyPose(boolean variant) {
                if (variant) {
                    stand.setLeftArmPose(armForward);
                    stand.setRightArmPose(armBackward);
                    stand.setLeftLegPose(legBackward);
                    stand.setRightLegPose(legForward);
                } else {
                    stand.setLeftArmPose(armBackward);
                    stand.setRightArmPose(armForward);
                    stand.setLeftLegPose(legForward);
                    stand.setRightLegPose(legBackward);
                }
            }

            private void resetPose() {
                EulerAngle zero = new EulerAngle(0.0, 0.0, 0.0);
                stand.setLeftArmPose(zero);
                stand.setRightArmPose(zero);
                stand.setLeftLegPose(zero);
                stand.setRightLegPose(zero);
            }
        }.runTaskTimer((Plugin)this, 0L, 2L);
    }

    private void resetFacingForward(ArmorStand stand) {
        if (stand == null) {
            return;
        }
        Location loc = stand.getLocation();
        if (loc == null || loc.getWorld() == null) {
            return;
        }
        stand.teleport(new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), 0.0f));
        stand.setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
    }

    private Location normalizeAgentTarget(Location raw, Location reference) {
        if (raw == null || raw.getWorld() == null) {
            return raw;
        }
        double x = Math.floor(raw.getX()) + 0.5;
        double z = Math.floor(raw.getZ()) + 0.5;
        double y = Math.floor(raw.getY());
        Location normalized = new Location(raw.getWorld(), x, y, z);
        if (reference != null) {
            normalized.setYaw(reference.getYaw());
            normalized.setPitch(reference.getPitch());
        }
        return normalized;
    }

    private Vector resolveDirectionVector(Location origin, String direction) {
        if (origin == null) {
            return null;
        }
        if (direction == null) {
            return null;
        }
        String dirTrim = direction.trim().toLowerCase(Locale.ROOT);
        if (dirTrim.equals("up")) {
            return new Vector(0, 1, 0);
        }
        if (dirTrim.equals("down")) {
            return new Vector(0, -1, 0);
        }
        Vector forward = origin.getDirection();
        if (forward == null || forward.lengthSquared() < 1.0E-4) {
            forward = new Vector(0, 0, 1);
        }
        forward.setY(0);
        if (forward.lengthSquared() < 1.0E-4) {
            forward = new Vector(0, 0, 1);
        } else {
            forward.normalize();
        }
        Vector right = forward.clone().crossProduct(new Vector(0, 1, 0));
        if (right.lengthSquared() < 1.0E-4) {
            right = new Vector(1, 0, 0);
        } else {
            right.normalize();
        }
        return switch (dirTrim) {
            case "forward" -> forward;
            case "back" -> forward.clone().multiply(-1);
            case "right" -> right;
            case "left" -> right.clone().multiply(-1);
            default -> null;
        };
    }

    private Vector resolvePlaceOffset(Location origin, String direction) {
        if (direction == null) {
            return null;
        }
        String dir = direction.trim().toLowerCase(Locale.ROOT);
        if (dir.equals("up")) {
            return new Vector(0, 1, 0);
        }
        if (dir.equals("down")) {
            return new Vector(0, -1, 0);
        }
        Vector horiz = this.resolveDirectionVector(origin, dir);
        if (horiz == null) {
            return null;
        }
        return horiz.normalize();
    }

    private String normalizeDirection(String direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction.trim().toLowerCase(Locale.ROOT)) {
            case "forward", "back", "right", "left", "up", "down" -> direction.trim().toLowerCase(Locale.ROOT);
            default -> null;
        };
    }

    private String normalizeTurnDirection(String direction) {
        if (direction == null) {
            return null;
        }
        return switch (direction.trim().toLowerCase(Locale.ROOT)) {
            case "left", "right" -> direction.trim().toLowerCase(Locale.ROOT);
            default -> null;
        };
    }

    private float normalizeYaw(float yaw) {
        float normalized = yaw % 360.0f;
        if (normalized < -180.0f) {
            normalized += 360.0f;
        }
        if (normalized >= 180.0f) {
            normalized -= 360.0f;
        }
        return normalized;
    }

    private void applyActiveSlotToStand(ArmorStand stand, AgentInventory inventory) {
        ItemStack stored;
        if (stand == null || inventory == null) {
            return;
        }
        EntityEquipment equipment = stand.getEquipment();
        if (equipment == null) {
            return;
        }
        ItemStack item = null;
        if (inventory.activeSlot >= 0 && inventory.activeSlot < inventory.slots.length && (stored = inventory.slots[inventory.activeSlot]) != null) {
            item = stored.clone();
        }
        equipment.setItemInMainHand(item);
    }

    private static String agentMapKey(String ownerName, String agentId) {
        String ownerPart = ownerName == null ? "" : ownerName.trim().toLowerCase(Locale.ROOT);
        String agentPart = agentId == null ? "" : agentId.trim();
        return ownerPart + "." + agentPart;
    }

    private String localAddressFromPlayer(Player player) {
        if (player == null) {
            return null;
        }
        try {
            String host;
            InetSocketAddress inet;
            InetAddress addr;
            SocketAddress sa;
            Object handle = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            if (handle == null) {
                return null;
            }
            Object connection = this.readField(handle, "playerConnection", "connection");
            if (connection == null) {
                return null;
            }
            Object networkManager = this.readField(connection, "networkManager", "connection");
            if (networkManager == null) {
                return null;
            }
            Object channel = this.readField(networkManager, "channel");
            if (channel == null) {
                return null;
            }
            Object localAddrObj = channel.getClass().getMethod("localAddress", new Class[0]).invoke(channel, new Object[0]);
            if (localAddrObj instanceof SocketAddress && (sa = (SocketAddress)localAddrObj) instanceof InetSocketAddress && (addr = (inet = (InetSocketAddress)sa).getAddress()) != null && !addr.isAnyLocalAddress() && !addr.isLoopbackAddress() && !TwBridgePlugin.isAnyAddress(host = addr.getHostAddress()) && !TwBridgePlugin.isLoopbackHost(host)) {
                return host;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Object readField(Object target, String ... names) {
        if (target == null || names == null) {
            return null;
        }
        for (String name : names) {
            if (name == null || name.isBlank()) continue;
            try {
                Field field = target.getClass().getField(name);
                field.setAccessible(true);
                return field.get(target);
            }
            catch (Exception ignored) {
                try {
                    Field field = target.getClass().getDeclaredField(name);
                    field.setAccessible(true);
                    return field.get(target);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static String firstNonBlank(String ... candidates) {
        for (String c : candidates) {
            if (c == null || c.isBlank()) continue;
            return c;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String localAddressForRemote(String remoteHost) {
        if (remoteHost == null) return null;
        if (remoteHost.isBlank()) {
            return null;
        }
        try {
            InetSocketAddress remote = new InetSocketAddress(remoteHost.trim(), 80);
            try (Socket socket = new Socket();){
                socket.connect(remote, 500);
                InetAddress local = socket.getLocalAddress();
                if (local == null) return null;
                if (local.isAnyLocalAddress()) return null;
                if (local.isLoopbackAddress()) return null;
                String host = local.getHostAddress();
                if (TwBridgePlugin.isAnyAddress(host)) return null;
                if (TwBridgePlugin.isLoopbackHost(host)) return null;
                String string = host;
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String sanitizeLang(String raw, String fallback) {
        String fb;
        String string = fb = fallback == null || fallback.isBlank() ? "en" : fallback.trim().toLowerCase(Locale.ROOT);
        if (raw == null) {
            return fb;
        }
        String normalized = raw.trim().replace('_', '-').toLowerCase(Locale.ROOT);
        if (normalized.isBlank() || normalized.length() > 32) {
            return fb;
        }
        if (!normalized.matches("^[a-z0-9]{2,8}(?:-[a-z0-9]{1,8})*$")) {
            return fb;
        }
        return normalized;
    }

    private static String chooseClientHost(String ... candidates) {
        for (String candidate : candidates) {
            String normalized;
            if (candidate == null || candidate.isBlank() || TwBridgePlugin.isAnyAddress(normalized = candidate.trim())) continue;
            return normalized;
        }
        String detected = TwBridgePlugin.detectLocalIp();
        return detected == null || detected.isBlank() ? "127.0.0.1" : detected;
    }

    private boolean isUsableSpecificHost(String host) {
        return host != null && !host.isBlank() && !TwBridgePlugin.isAnyAddress(host) && !TwBridgePlugin.isLoopbackHost(host);
    }

    private static String detectLocalIp() {
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            InetAddress firstNonLoopback = null;
            while (ifaces != null && ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (iface == null || !iface.isUp() || iface.isLoopback()) continue;
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr instanceof Inet6Address && ((Inet6Address)addr).isLinkLocalAddress() || addr.isLinkLocalAddress()) continue;
                    if (addr.isSiteLocalAddress() && addr instanceof Inet4Address) {
                        return addr.getHostAddress();
                    }
                    if (firstNonLoopback != null) continue;
                    firstNonLoopback = addr;
                }
            }
            if (firstNonLoopback != null) {
                return firstNonLoopback.getHostAddress();
            }
            InetAddress local = InetAddress.getLocalHost();
            if (local != null && !local.isLoopbackAddress() && !local.isAnyLocalAddress()) {
                return local.getHostAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isAnyAddress(String host) {
        String normalized = host.trim();
        return normalized.equals("0.0.0.0") || normalized.equals("::") || normalized.equals("::0") || normalized.equals("*");
    }

    private static boolean isLoopbackHost(String host) {
        if (host == null) {
            return true;
        }
        String normalized = host.trim().toLowerCase(Locale.ROOT);
        return normalized.equals("localhost") || normalized.equals("127.0.0.1") || normalized.startsWith("127.") || normalized.equals("::1") || normalized.equals("[::1]");
    }

    private static String buildWsDefaultUrl(String host, int port, String scheme) {
        String effectiveScheme;
        String effectiveHost = host == null || host.isBlank() ? "127.0.0.1" : host;
        boolean bracketed = effectiveHost.startsWith("[") && effectiveHost.endsWith("]");
        boolean needsBrackets = effectiveHost.contains(":") && !bracketed;
        Object normalizedHost = needsBrackets ? "[" + effectiveHost + "]" : effectiveHost;
        String string = effectiveScheme = scheme == null || scheme.isBlank() ? "ws" : scheme.trim().toLowerCase(Locale.ROOT);
        if (!effectiveScheme.equals("wss") && !effectiveScheme.equals("ws")) {
            effectiveScheme = "ws";
        }
        return effectiveScheme + "://" + (String)normalizedHost + ":" + port;
    }

    private static final class PromptLocale {
        final String key;
        final String prompt;
        final String yes;
        final String no;
        final String hover;
        final String clickHint;
        final String adblockHint;

        PromptLocale(String key, String prompt, String yes, String no, String hover, String clickHint, String adblockHint) {
            this.key = key;
            this.prompt = prompt;
            this.yes = yes;
            this.no = no;
            this.hover = hover;
            this.clickHint = clickHint;
            this.adblockHint = adblockHint;
        }

        static PromptLocale defaultEn() {
            return new PromptLocale("en", "[TurboAgent] Use the agent?", "[Yes]", "[No]", "Click to open", "Press \"t\" or \"/\" before clicking the link.", "If blocks do not appear, try disabling your browser ad-blocker.");
        }

        static PromptLocale defaultJa() {
            return new PromptLocale("ja", "[TurboAgent] \u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u3092\u4f7f\u3044\u307e\u3059\u304b\uff1f", "[\u306f\u3044]", "[\u3044\u3044\u3048]", "\u30af\u30ea\u30c3\u30af\u3067\u958b\u304f", "\u30af\u30ea\u30c3\u30af\u3059\u308b\u306b\u306f\u300ct\u300d\u304b\u300c/\u300d\u3092\u62bc\u3057\u3066\u304b\u3089\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044\u3002", "\u30b3\u30fc\u30c9\u30d6\u30ed\u30c3\u30af\u304c\u8868\u793a\u3055\u308c\u306a\u3044\u5834\u5408\u306f\u3001\u30d6\u30e9\u30a6\u30b6\u306e\u5e83\u544a\u30d6\u30ed\u30c3\u30af\u6a5f\u80fd\u3092\u7121\u52b9\u306b\u3057\u3066\u307f\u3066\u304f\u3060\u3055\u3044\u3002");
        }

        static PromptLocale fromJson(JSONObject json) {
            String key;
            if (json == null) {
                return null;
            }
            PromptLocale base = switch (key = json.optString("key", "").trim()) {
                case "ja" -> PromptLocale.defaultJa();
                default -> PromptLocale.defaultEn();
            };
            return new PromptLocale(key.isBlank() ? base.key : key, json.optString("prompt", base.prompt), json.optString("yes", base.yes), json.optString("no", base.no), json.optString("hover", base.hover), json.optString("clickHint", base.clickHint), json.optString("adblockHint", base.adblockHint));
        }
    }

    private record MagicToken(String player, long expiresAt) {
    }

    private static class AgentInventory {
        final ItemStack[] slots = new ItemStack[27];
        int activeSlot = -1;

        private AgentInventory() {
        }
    }

    private record AgentEntry(UUID entityId, String owner) {
    }
}

