/*
 * Decompiled with CFR 0.152.
 */
package net.nando256.pdca;

import net.nando256.pdca.PdcaTimerManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PdcaTimerPlugin
extends JavaPlugin {
    private PdcaTimerManager manager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadManager();
        this.getLogger().info("[PDCATimer] Lectern timers enabled.");
    }

    public void onDisable() {
        if (this.manager != null) {
            HandlerList.unregisterAll((Listener)this.manager);
            this.manager.shutdown();
            this.manager = null;
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("pdcetimer")) {
            return false;
        }
        if (args.length == 0) {
            sender.sendMessage("/" + label + " reload");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("pdcetimer.admin")) {
                sender.sendMessage("\u00a7cYou do not have permission to do that.");
                return true;
            }
            this.reloadConfig();
            this.reloadManager();
            sender.sendMessage("\u00a7aPDCATimer configuration reloaded.");
            return true;
        }
        sender.sendMessage("/" + label + " reload");
        return true;
    }

    private void reloadManager() {
        if (this.manager != null) {
            HandlerList.unregisterAll((Listener)this.manager);
            this.manager.shutdown();
        }
        if (!this.getConfig().getBoolean("pdca.enabled", true)) {
            this.manager = null;
            this.getLogger().info("[PDCATimer] Disabled via config.");
            return;
        }
        this.manager = new PdcaTimerManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.manager, (Plugin)this);
    }
}

