/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.vertexgeometry.shapes;

import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.vertexgeometry.VertexShapeBuilder;
import com.mochibit.defcon.vertexgeometry.vertexes.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016\u00a2\u0006\u0002\u0010!J \u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010'\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bJ \u0010(\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0004J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R$\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006."}, d2={"Lcom/mochibit/defcon/vertexgeometry/shapes/SphereBuilder;", "Lcom/mochibit/defcon/vertexgeometry/VertexShapeBuilder;", "()V", "<set-?>", "", "density", "getDensity", "()D", "", "hollow", "getHollow", "()Z", "ignoreBottomSurface", "getIgnoreBottomSurface", "ignoreTopSurface", "getIgnoreTopSurface", "radiusXZ", "getRadiusXZ", "radiusY", "getRadiusY", "skipRadiusXZ", "getSkipRadiusXZ", "skipRadiusY", "getSkipRadiusY", "yEnd", "getYEnd", "()Ljava/lang/Double;", "Ljava/lang/Double;", "yStart", "getYStart", "build", "", "Lcom/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "()[Lcom/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "checkInSkipRadius", "x", "y", "z", "checkYBounds", "hollowValidSurfaceY", "radiusCheck", "withDensity", "withRadiusXZ", "withRadiusY", "withYEnd", "withYStart", "Defcon"})
@SourceDebugExtension(value={"SMAP\nSphereBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SphereBuilder.kt\ncom/mochibit/defcon/vertexgeometry/shapes/SphereBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n37#2,2:114\n1#3:116\n*S KotlinDebug\n*F\n+ 1 SphereBuilder.kt\ncom/mochibit/defcon/vertexgeometry/shapes/SphereBuilder\n*L\n59#1:114,2\n*E\n"})
public final class SphereBuilder
implements VertexShapeBuilder {
    private double radiusY;
    private double radiusXZ;
    private double skipRadiusY;
    private double skipRadiusXZ;
    private double density = 1.0;
    @Nullable
    private Double yStart;
    @Nullable
    private Double yEnd;
    private boolean hollow;
    private boolean ignoreTopSurface;
    private boolean ignoreBottomSurface;

    public final double getRadiusY() {
        return this.radiusY;
    }

    public final double getRadiusXZ() {
        return this.radiusXZ;
    }

    public final double getSkipRadiusY() {
        return this.skipRadiusY;
    }

    public final double getSkipRadiusXZ() {
        return this.skipRadiusXZ;
    }

    public final double getDensity() {
        return this.density;
    }

    @Nullable
    public final Double getYStart() {
        return this.yStart;
    }

    @Nullable
    public final Double getYEnd() {
        return this.yEnd;
    }

    public final boolean getHollow() {
        return this.hollow;
    }

    public final boolean getIgnoreTopSurface() {
        return this.ignoreTopSurface;
    }

    public final boolean getIgnoreBottomSurface() {
        return this.ignoreBottomSurface;
    }

    @Override
    @NotNull
    public Vertex[] build() {
        List sphere = new ArrayList();
        double incrementValue = 1.0 / this.density;
        Double d = this.yStart;
        double startY = d != null ? d : -this.radiusY;
        Double d2 = this.yEnd;
        double endY = d2 != null ? d2 : this.radiusY;
        for (double x = -this.radiusXZ; x < this.radiusXZ; x += incrementValue) {
            double y = startY;
            while (y < endY) {
                if (!this.checkYBounds(y)) {
                    y += incrementValue;
                    continue;
                }
                double z = -this.radiusXZ;
                while (z < this.radiusXZ) {
                    if (this.checkInSkipRadius(x, y, z)) {
                        z += incrementValue;
                        continue;
                    }
                    double radiusCheck = this.radiusCheck(x, y, z);
                    if (this.hollow) {
                        if (!(0.9 <= radiusCheck ? radiusCheck <= 1.0 : false) && !this.hollowValidSurfaceY(y)) {
                            z += incrementValue;
                            continue;
                        }
                    }
                    if (radiusCheck <= 1.0) {
                        sphere.add(new Vertex(new Vector3(x, y, z), null, null, 6, null));
                    }
                    z += incrementValue;
                }
                y += incrementValue;
            }
        }
        Collection $this$toTypedArray$iv = sphere;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Vertex[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkYBounds(double y) {
        if (this.yStart == null) {
            if (this.yEnd == null) return true;
        }
        Double d = this.yStart;
        double d2 = d != null ? d : -this.radiusY;
        Double d3 = this.yEnd;
        double d4 = d3 != null ? d3 : this.radiusY;
        if (!(y <= d4)) return false;
        if (!(d2 <= y)) return false;
        return true;
    }

    private final boolean checkInSkipRadius(double x, double y, double z) {
        if (this.skipRadiusY <= 0.0 && this.skipRadiusXZ <= 0.0) {
            return false;
        }
        double xzComponent = this.skipRadiusXZ > 0.0 ? x * x / (this.skipRadiusXZ * this.skipRadiusXZ) + z * z / (this.skipRadiusXZ * this.skipRadiusXZ) : 0.0;
        double yComponent = this.skipRadiusY > 0.0 ? y * y / (this.skipRadiusY * this.skipRadiusY) : 0.0;
        return xzComponent + yComponent <= 1.0;
    }

    private final double radiusCheck(double x, double y, double z) {
        return x * x / (this.radiusXZ * this.radiusXZ) + y * y / (this.radiusY * this.radiusY) + z * z / (this.radiusXZ * this.radiusXZ);
    }

    private final boolean hollowValidSurfaceY(double y) {
        return this.ignoreTopSurface && Intrinsics.areEqual(y, this.yEnd) ? false : (this.ignoreBottomSurface && Intrinsics.areEqual(y, this.yStart) ? false : Intrinsics.areEqual(y, this.yEnd) || Intrinsics.areEqual(y, this.yStart));
    }

    @NotNull
    public final SphereBuilder withRadiusY(double radiusY) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$withRadiusY_u24lambda_u240 = sphereBuilder = this;
        boolean bl = false;
        $this$withRadiusY_u24lambda_u240.radiusY = radiusY;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder withRadiusXZ(double radiusXZ) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$withRadiusXZ_u24lambda_u241 = sphereBuilder = this;
        boolean bl = false;
        $this$withRadiusXZ_u24lambda_u241.radiusXZ = radiusXZ;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder withYStart(double yStart) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$withYStart_u24lambda_u242 = sphereBuilder = this;
        boolean bl = false;
        $this$withYStart_u24lambda_u242.yStart = yStart;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder withYEnd(double yEnd) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$withYEnd_u24lambda_u243 = sphereBuilder = this;
        boolean bl = false;
        $this$withYEnd_u24lambda_u243.yEnd = yEnd;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder skipRadiusY(double skipRadiusY) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$skipRadiusY_u24lambda_u244 = sphereBuilder = this;
        boolean bl = false;
        $this$skipRadiusY_u24lambda_u244.skipRadiusY = skipRadiusY;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder skipRadiusXZ(double skipRadiusXZ) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$skipRadiusXZ_u24lambda_u245 = sphereBuilder = this;
        boolean bl = false;
        $this$skipRadiusXZ_u24lambda_u245.skipRadiusXZ = skipRadiusXZ;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder withDensity(double density) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$withDensity_u24lambda_u246 = sphereBuilder = this;
        boolean bl = false;
        $this$withDensity_u24lambda_u246.density = density;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder hollow(boolean hollow) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$hollow_u24lambda_u247 = sphereBuilder = this;
        boolean bl = false;
        $this$hollow_u24lambda_u247.hollow = hollow;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder ignoreTopSurface(boolean ignoreTopSurface) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$ignoreTopSurface_u24lambda_u248 = sphereBuilder = this;
        boolean bl = false;
        $this$ignoreTopSurface_u24lambda_u248.ignoreTopSurface = ignoreTopSurface;
        return sphereBuilder;
    }

    @NotNull
    public final SphereBuilder ignoreBottomSurface(boolean ignoreBottomSurface) {
        SphereBuilder sphereBuilder;
        SphereBuilder $this$ignoreBottomSurface_u24lambda_u249 = sphereBuilder = this;
        boolean bl = false;
        $this$ignoreBottomSurface_u24lambda_u249.ignoreBottomSurface = ignoreBottomSurface;
        return sphereBuilder;
    }
}

