/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.vertexgeometry.shapes;

import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.vertexgeometry.VertexShapeBuilder;
import com.mochibit.defcon.vertexgeometry.vertexes.Vertex;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0006J0\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u001aj\b\u0012\u0004\u0012\u00020\u000f`\u001b2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/mochibit/defcon/vertexgeometry/shapes/CircleBuilder;", "Lcom/mochibit/defcon/vertexgeometry/VertexShapeBuilder;", "()V", "extension", "", "hollow", "", "maxAngle", "minRadiusX", "minRadiusZ", "radiusX", "radiusZ", "rate", "build", "", "Lcom/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "()[Lcom/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "getExtension", "getMaxAngle", "getMinRadiusX", "getMinRadiusZ", "getRadiusX", "getRadiusZ", "getRate", "isHollow", "makeCircle", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "withExtension", "withMaxAngle", "withMinRadiusX", "withMinRadiusZ", "withRadiusX", "withRadiusZ", "withRate", "Defcon"})
@SourceDebugExtension(value={"SMAP\nCircleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CircleBuilder.kt\ncom/mochibit/defcon/vertexgeometry/shapes/CircleBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,171:1\n37#2,2:172\n37#2,2:174\n*S KotlinDebug\n*F\n+ 1 CircleBuilder.kt\ncom/mochibit/defcon/vertexgeometry/shapes/CircleBuilder\n*L\n41#1:172,2\n63#1:174,2\n*E\n"})
public final class CircleBuilder
implements VertexShapeBuilder {
    private double radiusX;
    private double radiusZ;
    private double extension = 1.0;
    private double rate = 1.0;
    private double maxAngle;
    private boolean hollow;
    private double minRadiusX;
    private double minRadiusZ;

    @Override
    @NotNull
    public Vertex[] build() {
        if (this.hollow) {
            Collection $this$toTypedArray$iv = this.makeCircle(this.radiusX, this.radiusZ, this.rate);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new Vertex[0]);
        }
        HashSet result = new HashSet();
        double x = 0.0;
        double z = 0.0;
        double dynamicRate = 0.0;
        double radiusRate = 3.0;
        while (x < this.radiusX || z < this.radiusZ) {
            result.addAll(this.makeCircle(x, z, dynamicRate += this.rate / (this.radiusX / radiusRate)));
            x += radiusRate;
            z += radiusRate;
            x = RangesKt.coerceIn(x, this.minRadiusX, this.radiusX);
            z = RangesKt.coerceIn(z, this.minRadiusZ, this.radiusZ);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Vertex[0]);
    }

    private final HashSet<Vertex> makeCircle(double radiusX, double radiusZ, double rate) {
        HashSet<Vertex> result = new HashSet<Vertex>();
        double rateDiv = Math.PI / Math.abs(rate);
        if (this.maxAngle == 0.0) {
            this.maxAngle = Math.PI * 2;
        } else if (this.maxAngle == -1.0) {
            this.maxAngle = Math.PI * 2 / Math.abs(this.extension);
        }
        for (double theta = 0.0; theta <= this.maxAngle; theta += rateDiv) {
            double x = radiusX * Math.cos(this.extension * theta);
            double z = radiusZ * Math.sin(this.extension * theta);
            result.add(new Vertex(new Vector3(x, 0.0, z), null, null, 6, null));
        }
        return result;
    }

    @NotNull
    public final CircleBuilder withRadiusX(double radiusX) {
        this.radiusX = radiusX;
        return this;
    }

    @NotNull
    public final CircleBuilder withRadiusZ(double radiusZ) {
        this.radiusZ = radiusZ;
        return this;
    }

    @NotNull
    public final CircleBuilder withExtension(double extension) {
        this.extension = extension;
        return this;
    }

    @NotNull
    public final CircleBuilder withRate(double rate) {
        this.rate = rate;
        return this;
    }

    @NotNull
    public final CircleBuilder withMaxAngle(double maxAngle) {
        this.maxAngle = maxAngle;
        return this;
    }

    @NotNull
    public final CircleBuilder hollow(boolean hollow) {
        this.hollow = hollow;
        return this;
    }

    @NotNull
    public final CircleBuilder withMinRadiusX(double minRadiusX) {
        this.minRadiusX = minRadiusX;
        return this;
    }

    @NotNull
    public final CircleBuilder withMinRadiusZ(double minRadiusZ) {
        this.minRadiusZ = minRadiusZ;
        return this;
    }

    public final double getRadiusX() {
        return this.radiusX;
    }

    public final double getRadiusZ() {
        return this.radiusZ;
    }

    public final double getExtension() {
        return this.extension;
    }

    public final double getRate() {
        return this.rate;
    }

    public final double getMaxAngle() {
        return this.maxAngle;
    }

    public final boolean isHollow() {
        return this.hollow;
    }

    public final double getMinRadiusX() {
        return this.minRadiusX;
    }

    public final double getMinRadiusZ() {
        return this.minRadiusZ;
    }
}

