/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.vertexgeometry.morphers;

import com.mochibit.defcon.extensions.LocationKt;
import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.utils.Geometry;
import com.mochibit.defcon.utils.MathFunctions;
import com.mochibit.defcon.vertexgeometry.morphers.ShapeMorpher;
import com.mochibit.defcon.vertexgeometry.vertexes.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/mochibit/defcon/vertexgeometry/morphers/SnapToFloor;", "Lcom/mochibit/defcon/vertexgeometry/morphers/ShapeMorpher;", "maxDepth", "", "startYOffset", "easeFromPoint", "Lorg/bukkit/Location;", "(DDLorg/bukkit/Location;)V", "morph", "", "Lcom/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "basis", "([Lcom/mochibit/defcon/vertexgeometry/vertexes/Vertex;)[Lcom/mochibit/defcon/vertexgeometry/vertexes/Vertex;", "morphVertex", "Defcon"})
@SourceDebugExtension(value={"SMAP\nSnapToFloor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapToFloor.kt\ncom/mochibit/defcon/vertexgeometry/morphers/SnapToFloor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,61:1\n11065#2:62\n11400#2,3:63\n37#3,2:66\n*S KotlinDebug\n*F\n+ 1 SnapToFloor.kt\ncom/mochibit/defcon/vertexgeometry/morphers/SnapToFloor\n*L\n59#1:62\n59#1:63,3\n59#1:66,2\n*E\n"})
public final class SnapToFloor
implements ShapeMorpher {
    private final double maxDepth;
    private final double startYOffset;
    @Nullable
    private final Location easeFromPoint;

    public SnapToFloor(double maxDepth, double startYOffset, @Nullable Location easeFromPoint) {
        this.maxDepth = maxDepth;
        this.startYOffset = startYOffset;
        this.easeFromPoint = easeFromPoint;
    }

    public /* synthetic */ SnapToFloor(double d, double d2, Location location, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            location = null;
        }
        this(d, d2, location);
    }

    @Override
    @NotNull
    public Vertex morphVertex(@NotNull Vertex basis) {
        Intrinsics.checkNotNullParameter(basis, "basis");
        Vector3 point = basis.getPoint();
        Location location = basis.getGlobalPosition().clone().add(0.0, this.startYOffset, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location groundedLoc = Geometry.INSTANCE.getMinYUsingSnapshot(location, this.maxDepth + this.startYOffset);
        if (this.easeFromPoint != null) {
            Location location2 = this.easeFromPoint.clone();
            Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
            Location from = location2;
            double distance = basis.getGlobalPosition().distance(from);
            double maxDistance = 80.0;
            double t = MathFunctions.INSTANCE.clamp(distance / maxDistance, 0.0, 1.0);
            double smoothT = t < 0.5 ? (double)4 * t * t * t : 1.0 - Math.pow((double)-2 * t + (double)2, 3) / (double)2;
            Location easedLoc = LocationKt.lerp(basis.getGlobalPosition(), groundedLoc, smoothT);
            Location location3 = easedLoc.add(0.0, point.getY(), 0.0);
            Intrinsics.checkNotNullExpressionValue(location3, "add(...)");
            basis.setGlobalPosition(location3);
        } else {
            Location location4 = groundedLoc.add(0.0, point.getY(), 0.0);
            Intrinsics.checkNotNullExpressionValue(location4, "add(...)");
            basis.setGlobalPosition(location4);
        }
        return basis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Vertex[] morph(@NotNull Vertex[] basis) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(basis, "basis");
        Vertex[] $this$map$iv = basis;
        boolean $i$f$map = false;
        Vertex[] vertexArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.morphVertex((Vertex)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Vertex[0]);
    }

    public SnapToFloor() {
        this(0.0, 0.0, null, 7, null);
    }
}

