/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.utils;

import com.mochibit.defcon.utils.ColorUtils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/mochibit/defcon/utils/Gradient;", "", "colorPoints", "", "Lorg/bukkit/Color;", "([Lorg/bukkit/Color;)V", "getColorPoints", "()[Lorg/bukkit/Color;", "[Lorg/bukkit/Color;", "component1", "copy", "([Lorg/bukkit/Color;)Lcom/mochibit/defcon/utils/Gradient;", "equals", "", "other", "getColorAt", "t", "", "hashCode", "", "toString", "", "Defcon"})
public final class Gradient {
    @NotNull
    private final Color[] colorPoints;

    public Gradient(@NotNull Color[] colorPoints) {
        Intrinsics.checkNotNullParameter(colorPoints, "colorPoints");
        this.colorPoints = colorPoints;
    }

    @NotNull
    public final Color[] getColorPoints() {
        return this.colorPoints;
    }

    @NotNull
    public final Color getColorAt(double t) {
        if (t > 1.0) {
            return ArraysKt.last(this.colorPoints);
        }
        if (t < 0.0) {
            return ArraysKt.first(this.colorPoints);
        }
        double scaledRatio = t * (double)(this.colorPoints.length - 1);
        int index = (int)scaledRatio;
        double remainder = scaledRatio - (double)index;
        if (index >= this.colorPoints.length - 1) {
            return ArraysKt.last(this.colorPoints);
        }
        return ColorUtils.INSTANCE.lerpColor(this.colorPoints[index], this.colorPoints[index + 1], remainder);
    }

    @NotNull
    public final Color[] component1() {
        return this.colorPoints;
    }

    @NotNull
    public final Gradient copy(@NotNull Color[] colorPoints) {
        Intrinsics.checkNotNullParameter(colorPoints, "colorPoints");
        return new Gradient(colorPoints);
    }

    public static /* synthetic */ Gradient copy$default(Gradient gradient, Color[] colorArray, int n, Object object) {
        if ((n & 1) != 0) {
            colorArray = gradient.colorPoints;
        }
        return gradient.copy(colorArray);
    }

    @NotNull
    public String toString() {
        return "Gradient(colorPoints=" + Arrays.toString(this.colorPoints) + ")";
    }

    public int hashCode() {
        return Arrays.hashCode(this.colorPoints);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Gradient)) {
            return false;
        }
        Gradient gradient = (Gradient)other;
        return Intrinsics.areEqual(this.colorPoints, gradient.colorPoints);
    }
}

