/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.utils;

import com.mochibit.defcon.classes.StructureBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u001f\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0006J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\f2\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001e"}, d2={"Lcom/mochibit/defcon/utils/Geometry;", "", "()V", "ccw", "", "p1", "Lorg/bukkit/Location;", "p2", "p3", "getConvexHullXZ", "", "points", "", "getMinY", "position", "maxDepth", "", "(Lorg/bukkit/Location;Ljava/lang/Double;)Lorg/bukkit/Location;", "getMinYUsingSnapshot", "lengthSq", "x", "z", "y", "loc", "rotateLocationPlaneXZ", "angle", "", "rotateStructureBlockPlaneXZ", "Lcom/mochibit/defcon/classes/StructureBlock;", "structureBlocks", "Defcon"})
@SourceDebugExtension(value={"SMAP\nGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Geometry.kt\ncom/mochibit/defcon/utils/Geometry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1963#2,14:176\n1963#2,14:190\n*S KotlinDebug\n*F\n+ 1 Geometry.kt\ncom/mochibit/defcon/utils/Geometry\n*L\n94#1:176,14\n107#1:190,14\n*E\n"})
public final class Geometry {
    @NotNull
    public static final Geometry INSTANCE = new Geometry();

    private Geometry() {
    }

    @NotNull
    public final List<Location> getConvexHullXZ(@NotNull List<? extends Location> points) {
        Intrinsics.checkNotNullParameter(points, "points");
        Location lowestPoint = points.get(0);
        for (Location location : points) {
            if (location.getBlockZ() < lowestPoint.getBlockZ()) {
                lowestPoint = location;
                continue;
            }
            if (location.getBlockZ() != lowestPoint.getBlockZ() || location.getBlockX() >= lowestPoint.getBlockX()) continue;
            lowestPoint = location;
        }
        List sortedPoints = new ArrayList(points);
        sortedPoints.remove(lowestPoint);
        Location location = lowestPoint;
        CollectionsKt.sortWith(sortedPoints, (arg_0, arg_1) -> Geometry.getConvexHullXZ$lambda$0(new Function2<Location, Location, Integer>(location){
            final /* synthetic */ Location $finalLowestPoint;
            {
                this.$finalLowestPoint = $finalLowestPoint;
                super(2);
            }

            @NotNull
            public final Integer invoke(@NotNull Location p1, @NotNull Location p2) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                double angle1 = Math.atan2(p1.getBlockZ() - this.$finalLowestPoint.getBlockZ(), p1.getBlockX() - this.$finalLowestPoint.getBlockX());
                double angle2 = Math.atan2(p2.getBlockZ() - this.$finalLowestPoint.getBlockZ(), p2.getBlockX() - this.$finalLowestPoint.getBlockX());
                return Double.compare(angle1, angle2);
            }
        }, arg_0, arg_1));
        sortedPoints.add(0, lowestPoint);
        Stack hull = new Stack();
        if (sortedPoints.size() < 3) {
            return sortedPoints;
        }
        hull.push(sortedPoints.get(0));
        hull.push(sortedPoints.get(1));
        int n = sortedPoints.size();
        for (int i = 2; i < n; ++i) {
            Location top = (Location)hull.pop();
            while (hull.size() > 0) {
                Object e = hull.peek();
                Intrinsics.checkNotNullExpressionValue(e, "peek(...)");
                Location location2 = (Location)e;
                Location location3 = top;
                Intrinsics.checkNotNull(location3);
                if (INSTANCE.ccw(location2, location3, (Location)sortedPoints.get(i)) > 0) break;
                top = (Location)hull.pop();
            }
            hull.push(top);
            hull.push(sortedPoints.get(i));
        }
        List convexHull = new ArrayList();
        while (!hull.empty()) {
            Object e = hull.pop();
            Intrinsics.checkNotNullExpressionValue(e, "pop(...)");
            convexHull.add(e);
        }
        return convexHull;
    }

    @NotNull
    public final List<Location> rotateLocationPlaneXZ(@NotNull List<? extends Location> points, float angle) {
        Intrinsics.checkNotNullParameter(points, "points");
        List rotatedPoints = new ArrayList();
        for (Location location : points) {
            Object v0;
            double rotatedX = location.getZ();
            Iterable $this$maxByOrNull$iv = points;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Location it = (Location)maxElem$iv;
                    boolean bl = false;
                    double maxValue$iv = it.getX();
                    do {
                        Object e$iv = iterator$iv.next();
                        Location it2 = (Location)e$iv;
                        boolean bl2 = false;
                        double v$iv = it2.getX();
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            double rotatedZ = ((Location)v0).getX() - location.getX();
            rotatedPoints.add(new Location(location.getWorld(), rotatedX, location.getY(), rotatedZ));
        }
        return rotatedPoints;
    }

    public static /* synthetic */ List rotateLocationPlaneXZ$default(Geometry geometry, List list, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 90.0f;
        }
        return geometry.rotateLocationPlaneXZ(list, f);
    }

    @NotNull
    public final List<StructureBlock> rotateStructureBlockPlaneXZ(@NotNull List<StructureBlock> structureBlocks, float angle) {
        Intrinsics.checkNotNullParameter(structureBlocks, "structureBlocks");
        List rotatedStructure = new ArrayList();
        for (StructureBlock structureBlock : structureBlocks) {
            Object v0;
            int rotatedX = structureBlock.getZ();
            Iterable $this$maxByOrNull$iv = structureBlocks;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    StructureBlock it = (StructureBlock)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getX();
                    do {
                        Object e$iv = iterator$iv.next();
                        StructureBlock it2 = (StructureBlock)e$iv;
                        $i$a$-maxByOrNull-Geometry$rotateStructureBlockPlaneXZ$rotatedZ$1 = false;
                        int v$iv = it2.getX();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v0);
            int rotatedZ = ((StructureBlock)v0).getX() - structureBlock.getX();
            rotatedStructure.add(new StructureBlock(structureBlock.getBlock(), rotatedX, structureBlock.getY(), rotatedZ, structureBlock.isInterface()));
        }
        return rotatedStructure;
    }

    public static /* synthetic */ List rotateStructureBlockPlaneXZ$default(Geometry geometry, List list, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 90.0f;
        }
        return geometry.rotateStructureBlockPlaneXZ(list, f);
    }

    @NotNull
    public final Location getMinY(@NotNull Location position, @Nullable Double maxDepth) {
        Intrinsics.checkNotNullParameter(position, "position");
        Location location = position.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location clonedPosition = location;
        clonedPosition.setY(RangesKt.coerceAtMost(clonedPosition.getY(), (double)(clonedPosition.getWorld().getMaxHeight() - 1)));
        int depth = 0;
        while (clonedPosition.getWorld().getBlockAt(clonedPosition).getType() == Material.AIR && (maxDepth == null || (double)depth < maxDepth) && clonedPosition.getY() >= (double)position.getWorld().getMinHeight()) {
            clonedPosition.subtract(0.0, 1.0, 0.0);
            ++depth;
        }
        return clonedPosition;
    }

    public static /* synthetic */ Location getMinY$default(Geometry geometry, Location location, Double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = null;
        }
        return geometry.getMinY(location, d);
    }

    @NotNull
    public final Location getMinYUsingSnapshot(@NotNull Location position, @Nullable Double maxDepth) {
        Intrinsics.checkNotNullParameter(position, "position");
        Location location = position.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location clonedPosition = location;
        Chunk chunk = clonedPosition.getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        Chunk chunk2 = chunk;
        ChunkSnapshot chunkSnapshot = chunk2.getChunkSnapshot();
        Intrinsics.checkNotNullExpressionValue(chunkSnapshot, "getChunkSnapshot(...)");
        ChunkSnapshot chunkSnapshot2 = chunkSnapshot;
        int localX = clonedPosition.getBlockX() & 0xF;
        int chunkY = clonedPosition.getBlockY();
        int localZ = clonedPosition.getBlockZ() & 0xF;
        int depth = 0;
        while (chunkSnapshot2.getBlockData(localX, RangesKt.coerceIn(chunkY, new IntRange(clonedPosition.getWorld().getMinHeight(), clonedPosition.getWorld().getMaxHeight())), localZ).getMaterial() == Material.AIR && (maxDepth == null || (double)depth < maxDepth)) {
            clonedPosition.subtract(0.0, 1.0, 0.0);
            ++depth;
            localX = clonedPosition.getBlockX() & 0xF;
            chunkY = clonedPosition.getBlockY();
            localZ = clonedPosition.getBlockZ() & 0xF;
        }
        return clonedPosition;
    }

    public final double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public final double lengthSq(double x, double z) {
        return x * x + z * z;
    }

    public final double lengthSq(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        return this.lengthSq(loc.getX(), loc.getY(), loc.getZ());
    }

    private final int ccw(Location p1, Location p2, Location p3) {
        return (p2.getBlockX() - p1.getBlockX()) * (p3.getBlockZ() - p1.getBlockZ()) - (p2.getBlockZ() - p1.getBlockZ()) * (p3.getBlockX() - p1.getBlockX());
    }

    private static final int getConvexHullXZ$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

