/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.utils;

import com.mochibit.defcon.math.Vector3;
import com.mochibit.defcon.registers.BlockRegister;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ6\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\r2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/mochibit/defcon/utils/FloodFill3D;", "", "()V", "getFloodFill", "", "Lorg/bukkit/Location;", "startLoc", "maxRange", "", "nonSolidOnly", "", "customBlockOnly", "getFloodFillAsync", "Ljava/util/concurrent/CompletableFuture;", "isCustomBlock", "loc", "Direction", "Defcon"})
public final class FloodFill3D {
    @NotNull
    public static final FloodFill3D INSTANCE = new FloodFill3D();

    private FloodFill3D() {
    }

    @NotNull
    public final List<Location> getFloodFill(@NotNull Location startLoc, int maxRange, boolean nonSolidOnly, boolean customBlockOnly) {
        Intrinsics.checkNotNullParameter(startLoc, "startLoc");
        HashSet<Location> positions = new HashSet<Location>();
        Queue queue = new LinkedList();
        queue.add(startLoc);
        while (!queue.isEmpty() && positions.size() < maxRange) {
            Location currentPos = (Location)queue.poll();
            if (positions.contains(currentPos) || nonSolidOnly && currentPos.getBlock().getType().isSolid()) continue;
            if (customBlockOnly) {
                Intrinsics.checkNotNull(currentPos);
                if (!this.isCustomBlock(currentPos)) continue;
            }
            positions.add(currentPos);
            Vector3 pos = new Vector3(currentPos.getX(), currentPos.getY(), currentPos.getZ());
            for (Direction direction : Direction.getEntries()) {
                Vector3 vector3 = pos.plus(direction.getVec());
                World world = currentPos.getWorld();
                Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
                Location nextPos = vector3.toLocation(world);
                if (nonSolidOnly && nextPos.getBlock().getType().isSolid() || customBlockOnly && !this.isCustomBlock(nextPos)) continue;
                queue.add(nextPos);
            }
        }
        return CollectionsKt.toList((Iterable)positions);
    }

    public static /* synthetic */ List getFloodFill$default(FloodFill3D floodFill3D, Location location, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return floodFill3D.getFloodFill(location, n, bl, bl2);
    }

    @NotNull
    public final CompletableFuture<List<Location>> getFloodFillAsync(@NotNull Location startLoc, int maxRange, boolean nonSolidOnly, boolean customBlockOnly) {
        Intrinsics.checkNotNullParameter(startLoc, "startLoc");
        CompletableFuture<List<Location>> completableFuture = CompletableFuture.supplyAsync(() -> FloodFill3D.getFloodFillAsync$lambda$0(startLoc, maxRange, nonSolidOnly, customBlockOnly));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "supplyAsync(...)");
        return completableFuture;
    }

    public static /* synthetic */ CompletableFuture getFloodFillAsync$default(FloodFill3D floodFill3D, Location location, int n, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return floodFill3D.getFloodFillAsync(location, n, bl, bl2);
    }

    private final boolean isCustomBlock(Location loc) {
        return BlockRegister.Companion.getBlock(loc) != null;
    }

    private static final List getFloodFillAsync$lambda$0(Location $startLoc, int $maxRange, boolean $nonSolidOnly, boolean $customBlockOnly) {
        Intrinsics.checkNotNullParameter($startLoc, "$startLoc");
        return INSTANCE.getFloodFill($startLoc, $maxRange, $nonSolidOnly, $customBlockOnly);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/mochibit/defcon/utils/FloodFill3D$Direction;", "", "vec", "Lcom/mochibit/defcon/math/Vector3;", "(Ljava/lang/String;ILcom/mochibit/defcon/math/Vector3;)V", "getVec", "()Lcom/mochibit/defcon/math/Vector3;", "UP", "DOWN", "NORTH", "SOUTH", "EAST", "WEST", "Defcon"})
    private static final class Direction
    extends Enum<Direction> {
        @NotNull
        private final Vector3 vec;
        public static final /* enum */ Direction UP = new Direction(new Vector3(0.0, 1.0, 0.0));
        public static final /* enum */ Direction DOWN = new Direction(new Vector3(0.0, -1.0, 0.0));
        public static final /* enum */ Direction NORTH = new Direction(new Vector3(0.0, 0.0, -1.0));
        public static final /* enum */ Direction SOUTH = new Direction(new Vector3(0.0, 0.0, 1.0));
        public static final /* enum */ Direction EAST = new Direction(new Vector3(1.0, 0.0, 0.0));
        public static final /* enum */ Direction WEST = new Direction(new Vector3(-1.0, 0.0, 0.0));
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Direction(Vector3 vec) {
            this.vec = vec;
        }

        @NotNull
        public final Vector3 getVec() {
            return this.vec;
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

