/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.utils;

import com.mochibit.defcon.utils.MathFunctions;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mochibit/defcon/utils/ColorUtils;", "", "()V", "rgbPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "darkenColor", "Lorg/bukkit/Color;", "color", "factor", "", "lerpColor", "a", "b", "t", "lightenColor", "parseColor", "", "inputString", "", "inputStrings", "", "stripColor", "Defcon"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();
    private static final Pattern rgbPattern = Pattern.compile("&#[a-fA-F0-9]{6}");

    private ColorUtils() {
    }

    @NotNull
    public final String parseColor(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter(inputString, "inputString");
        Matcher match = rgbPattern.matcher(inputString);
        String parsedString = inputString;
        while (match.find()) {
            String color;
            Intrinsics.checkNotNullExpressionValue(parsedString.substring(match.start(), match.end()), "substring(...)");
            parsedString = StringsKt.replace$default(parsedString, color, ChatColor.of((String)StringsKt.replace$default(color, "&", "", false, 4, null)).toString(), false, 4, null);
            match = rgbPattern.matcher(parsedString);
        }
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)parsedString);
        Intrinsics.checkNotNullExpressionValue(string, "translateAlternateColorCodes(...)");
        parsedString = string;
        return parsedString;
    }

    @NotNull
    public final List<String> parseColor(@NotNull List<String> inputStrings) {
        Intrinsics.checkNotNullParameter(inputStrings, "inputStrings");
        ListIterator<String> i = inputStrings.listIterator();
        while (i.hasNext()) {
            String element = i.next();
            i.set(this.parseColor(element));
        }
        return inputStrings;
    }

    @NotNull
    public final String stripColor(@NotNull String inputString) {
        Intrinsics.checkNotNullParameter(inputString, "inputString");
        String string = ChatColor.stripColor((String)inputString);
        Intrinsics.checkNotNullExpressionValue(string, "stripColor(...)");
        return string;
    }

    @NotNull
    public final Color lerpColor(@NotNull Color a, @NotNull Color b, double t) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        double r = MathFunctions.INSTANCE.lerp((double)a.getRed(), (double)b.getRed(), t);
        double g = MathFunctions.INSTANCE.lerp((double)a.getGreen(), (double)b.getGreen(), t);
        double bl = MathFunctions.INSTANCE.lerp((double)a.getBlue(), (double)b.getBlue(), t);
        Color color = Color.fromRGB((int)((int)r), (int)((int)g), (int)((int)bl));
        Intrinsics.checkNotNullExpressionValue(color, "fromRGB(...)");
        return color;
    }

    @NotNull
    public final Color darkenColor(@NotNull Color color, double factor) {
        Intrinsics.checkNotNullParameter(color, "color");
        if (factor <= 0.0) {
            return color;
        }
        int r = (int)RangesKt.coerceIn((double)color.getRed() * factor, 0.0, 255.0);
        int g = (int)RangesKt.coerceIn((double)color.getGreen() * factor, 0.0, 255.0);
        int b = (int)RangesKt.coerceIn((double)color.getBlue() * factor, 0.0, 255.0);
        Color color2 = Color.fromRGB((int)r, (int)g, (int)b);
        Intrinsics.checkNotNullExpressionValue(color2, "fromRGB(...)");
        return color2;
    }

    @NotNull
    public final Color lightenColor(@NotNull Color color, double factor) {
        Intrinsics.checkNotNullParameter(color, "color");
        if (factor <= 0.0) {
            return color;
        }
        int r = (int)RangesKt.coerceIn((double)color.getRed() + (double)(255 - color.getRed()) * factor, 0.0, 255.0);
        int g = (int)RangesKt.coerceIn((double)color.getGreen() + (double)(255 - color.getGreen()) * factor, 0.0, 255.0);
        int b = (int)RangesKt.coerceIn((double)color.getBlue() + (double)(255 - color.getBlue()) * factor, 0.0, 255.0);
        Color color2 = Color.fromRGB((int)r, (int)g, (int)b);
        Intrinsics.checkNotNullExpressionValue(color2, "fromRGB(...)");
        return color2;
    }
}

