/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.threading.jobs;

import com.mochibit.defcon.threading.jobs.Schedulable;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/mochibit/defcon/threading/jobs/ScheduledCompositionJob;", "T", "Lcom/mochibit/defcon/threading/jobs/Schedulable;", "valueSupplier", "Ljava/util/function/Supplier;", "breakupCondition", "Ljava/util/function/Predicate;", "valueConsumer", "Ljava/util/function/Consumer;", "(Ljava/util/function/Supplier;Ljava/util/function/Predicate;Ljava/util/function/Consumer;)V", "getBreakupCondition", "()Ljava/util/function/Predicate;", "failed", "", "getValueConsumer", "()Ljava/util/function/Consumer;", "getValueSupplier", "()Ljava/util/function/Supplier;", "compute", "", "shouldBeRescheduled", "Defcon"})
public final class ScheduledCompositionJob<T>
implements Schedulable {
    @NotNull
    private final Supplier<T> valueSupplier;
    @NotNull
    private final Predicate<T> breakupCondition;
    @NotNull
    private final Consumer<T> valueConsumer;
    private boolean failed;

    public ScheduledCompositionJob(@NotNull Supplier<T> valueSupplier, @NotNull Predicate<T> breakupCondition, @NotNull Consumer<T> valueConsumer) {
        Intrinsics.checkNotNullParameter(valueSupplier, "valueSupplier");
        Intrinsics.checkNotNullParameter(breakupCondition, "breakupCondition");
        Intrinsics.checkNotNullParameter(valueConsumer, "valueConsumer");
        this.valueSupplier = valueSupplier;
        this.breakupCondition = breakupCondition;
        this.valueConsumer = valueConsumer;
    }

    @NotNull
    public final Supplier<T> getValueSupplier() {
        return this.valueSupplier;
    }

    @NotNull
    public final Predicate<T> getBreakupCondition() {
        return this.breakupCondition;
    }

    @NotNull
    public final Consumer<T> getValueConsumer() {
        return this.valueConsumer;
    }

    @Override
    public void compute() {
        T element = this.valueSupplier.get();
        if (this.breakupCondition.test(element)) {
            this.failed = true;
            return;
        }
        this.valueConsumer.accept(element);
    }

    @Override
    public boolean shouldBeRescheduled() {
        return !this.failed;
    }
}

