/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.save.strategy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.save.savedata.SaveDataInfo;
import com.mochibit.defcon.save.schemas.SaveSchema;
import com.mochibit.defcon.save.strategy.SaveStrategy;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u001a\u001a\u0004\u0018\u00018\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\u0015\u0010\u001f\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00028\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010$R\u001c\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\f0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/mochibit/defcon/save/strategy/JsonSaver;", "T", "Lcom/mochibit/defcon/save/schemas/SaveSchema;", "Lcom/mochibit/defcon/save/strategy/SaveStrategy;", "saveDataInfo", "Lcom/mochibit/defcon/save/savedata/SaveDataInfo;", "schemaClass", "Lkotlin/reflect/KClass;", "(Lcom/mochibit/defcon/save/savedata/SaveDataInfo;Lkotlin/reflect/KClass;)V", "completePath", "Lkotlin/Function1;", "", "Ljava/nio/file/Path;", "file", "kotlin.jvm.PlatformType", "fileExtension", "", "fileNameSuffix", "Ljava/util/function/Supplier;", "getFileNameSuffix", "()Ljava/util/function/Supplier;", "setFileNameSuffix", "(Ljava/util/function/Supplier;)V", "gson", "Lcom/google/gson/Gson;", "path", "load", "page", "(Ljava/lang/Integer;)Lcom/mochibit/defcon/save/schemas/SaveSchema;", "pageExists", "", "pageToString", "(Ljava/lang/Integer;)Ljava/lang/String;", "save", "", "schema", "(Lcom/mochibit/defcon/save/schemas/SaveSchema;Ljava/lang/Integer;)V", "Defcon"})
@SourceDebugExtension(value={"SMAP\nJsonSaver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSaver.kt\ncom/mochibit/defcon/save/strategy/JsonSaver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class JsonSaver<T extends SaveSchema>
implements SaveStrategy<T> {
    @NotNull
    private final KClass<? extends T> schemaClass;
    @NotNull
    private Path path;
    private Path file;
    @NotNull
    private Supplier<String> fileNameSuffix;
    @NotNull
    private final String fileExtension;
    @NotNull
    private Function1<? super Integer, ? extends Path> completePath;
    @NotNull
    private final Gson gson;

    public JsonSaver(@NotNull SaveDataInfo saveDataInfo, @NotNull KClass<? extends T> schemaClass) {
        Intrinsics.checkNotNullParameter(saveDataInfo, "saveDataInfo");
        Intrinsics.checkNotNullParameter(schemaClass, "schemaClass");
        this.schemaClass = schemaClass;
        String[] stringArray = new String[]{saveDataInfo.filePath()};
        Path path = Paths.get(Defcon.Companion.getInstance().getDataFolder().getAbsolutePath(), stringArray);
        Intrinsics.checkNotNullExpressionValue(path, "get(...)");
        this.path = path;
        this.file = Paths.get(saveDataInfo.fileName(), new String[0]);
        this.fileNameSuffix = JsonSaver::fileNameSuffix$lambda$0;
        this.fileExtension = ".json";
        this.completePath = new Function1<Integer, Path>(this){
            final /* synthetic */ JsonSaver<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Path invoke(@Nullable Integer page) {
                String[] stringArray = new String[1];
                Integer n = page;
                stringArray[0] = JsonSaver.access$getFile$p(this.this$0) + this.this$0.getFileNameSuffix().get() + this.this$0.pageToString(n != null ? n : 0) + JsonSaver.access$getFileExtension$p(this.this$0);
                Path path = Paths.get(((Object)JsonSaver.access$getPath$p(this.this$0)).toString(), stringArray);
                Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                return path;
            }
        };
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        this.gson = gson;
    }

    @NotNull
    public final Supplier<String> getFileNameSuffix() {
        return this.fileNameSuffix;
    }

    public final void setFileNameSuffix(@NotNull Supplier<String> supplier) {
        Intrinsics.checkNotNullParameter(supplier, "<set-?>");
        this.fileNameSuffix = supplier;
    }

    @Override
    public void save(@NotNull T schema, @Nullable Integer page) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        String json = this.gson.toJson(schema);
        if (!Files.exists(this.path, new LinkOption[0])) {
            Files.createDirectories(this.path, new FileAttribute[0]);
        }
        Intrinsics.checkNotNull(json);
        String string = json;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        Files.write(this.completePath.invoke(page), byArray, new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T load(@Nullable Integer page) {
        if (!this.completePath.invoke(page).toFile().exists()) {
            return null;
        }
        File file = this.completePath.invoke(page).toFile();
        Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
        File file2 = file;
        Object object = Charsets.UTF_8;
        int n = 8192;
        Object object2 = file2;
        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), (Charset)object);
        BufferedReader jsonReader = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = jsonReader;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl = false;
            object2 = TextStreamsKt.readText(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        Object json = object2;
        return (T)((SaveSchema)((Object)this.gson.fromJson((String)json, JvmClassMappingKt.getJavaClass(this.schemaClass))));
    }

    @Override
    public boolean pageExists(int page) {
        return Files.exists(this.completePath.invoke((Integer)page), new LinkOption[0]);
    }

    @NotNull
    public final String pageToString(@Nullable Integer page) {
        Integer n = page;
        return n != null ? "-" + n : "";
    }

    private static final String fileNameSuffix$lambda$0() {
        return "";
    }

    public static final /* synthetic */ Path access$getPath$p(JsonSaver $this) {
        return $this.path;
    }

    public static final /* synthetic */ Path access$getFile$p(JsonSaver $this) {
        return $this.file;
    }

    public static final /* synthetic */ String access$getFileExtension$p(JsonSaver $this) {
        return $this.fileExtension;
    }
}

