/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.save.savedata;

import com.mochibit.defcon.radiation.RadiationArea;
import com.mochibit.defcon.save.AbstractSaveData;
import com.mochibit.defcon.save.savedata.SaveDataInfo;
import com.mochibit.defcon.save.schemas.RadiationAreaSchema;
import com.mochibit.defcon.save.schemas.SaveSchema;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SaveDataInfo(fileName="radiation_areas")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bJ\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u000bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015J\b\u0010\u0016\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mochibit/defcon/save/savedata/RadiationAreaSave;", "Lcom/mochibit/defcon/save/AbstractSaveData;", "Lcom/mochibit/defcon/save/schemas/RadiationAreaSchema;", "worldName", "", "(Ljava/lang/String;)V", "cachedMaxId", "Ljava/util/concurrent/atomic/AtomicInteger;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "maxPerFile", "", "addRadiationArea", "Lcom/mochibit/defcon/radiation/RadiationArea;", "radiationArea", "delete", "", "id", "get", "Lkotlin/Pair;", "getAll", "", "getMaximumId", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nRadiationAreaSave.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadiationAreaSave.kt\ncom/mochibit/defcon/save/savedata/RadiationAreaSave\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1#2:138\n1963#3,14:139\n*S KotlinDebug\n*F\n+ 1 RadiationAreaSave.kt\ncom/mochibit/defcon/save/savedata/RadiationAreaSave\n*L\n128#1:139,14\n*E\n"})
public final class RadiationAreaSave
extends AbstractSaveData<RadiationAreaSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String worldName;
    @NotNull
    private final ReentrantLock lock;
    private final int maxPerFile;
    @NotNull
    private AtomicInteger cachedMaxId;
    @NotNull
    private static final Map<String, RadiationAreaSave> radiationAreaSaves = new LinkedHashMap();

    private RadiationAreaSave(String worldName) {
        super((SaveSchema)new RadiationAreaSchema(null, 1, null), true);
        this.worldName = worldName;
        this.lock = new ReentrantLock();
        this.maxPerFile = 50;
        this.cachedMaxId = new AtomicInteger(0);
        this.setSuffixSupplier(() -> RadiationAreaSave._init_$lambda$0(this));
        this.getMaximumId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RadiationArea addRadiationArea(@NotNull RadiationArea radiationArea) {
        Intrinsics.checkNotNullParameter(radiationArea, "radiationArea");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            while (true) {
                Integer n = this.getCurrentPage();
                if (!this.pageExists(n != null ? n : 0)) break;
                this.load();
                if (((RadiationAreaSchema)this.getSchema()).getRadiationAreas().size() < this.maxPerFile) break;
                ((RadiationAreaSchema)this.getSchema()).getRadiationAreas().clear();
                this.nextPage();
            }
            RadiationArea indexedRadiationArea = RadiationArea.copy$default(radiationArea, null, null, null, null, null, 0.0, this.cachedMaxId.get() + 1, 63, null);
            ((RadiationAreaSchema)this.getSchema()).getRadiationAreas().add(indexedRadiationArea);
            this.save();
            this.cachedMaxId.incrementAndGet();
            RadiationArea radiationArea2 = indexedRadiationArea;
            return radiationArea2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Set<RadiationArea> getAll() {
        Lock lock = this.lock;
        lock.lock();
        try {
            void var3_4;
            boolean bl = false;
            Set allRadiationAreas = new LinkedHashSet();
            int page = 0;
            while (this.pageExists(page)) {
                RadiationAreaSchema schema = (RadiationAreaSchema)this.getSchema(page);
                if (schema == null) {
                    ++page;
                    continue;
                }
                allRadiationAreas.addAll((Collection)schema.getRadiationAreas());
                ++page;
            }
            void var6_7 = var3_4;
            return var6_7;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Pair<RadiationArea, Integer> get(int id) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            int page = 0;
            while (this.pageExists(page)) {
                Object v0;
                block8: {
                    RadiationAreaSchema schema = (RadiationAreaSchema)this.getSchema(page);
                    if (schema == null) {
                        ++page;
                        continue;
                    }
                    Iterable iterable = schema.getRadiationAreas();
                    for (Object t : iterable) {
                        RadiationArea it = (RadiationArea)t;
                        boolean bl2 = false;
                        if (!(it.getId() == id)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                RadiationArea area = v0;
                if (area != null) {
                    Pair<RadiationArea, Integer> pair = new Pair<RadiationArea, Integer>(area, page);
                    return pair;
                }
                ++page;
            }
            Pair<RadiationArea, Integer> pair = null;
            return pair;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(int id) {
        Lock lock = this.lock;
        lock.lock();
        try {
            RadiationAreaSchema radiationAreaSchema;
            Pair<RadiationArea, Integer> pair;
            boolean bl = false;
            if (this.get(id) == null) {
                return;
            }
            Pair<RadiationArea, Integer> areaToRemove = pair;
            if ((RadiationAreaSchema)this.getSchema(areaToRemove.getSecond()) == null) {
                return;
            }
            RadiationAreaSchema schema = radiationAreaSchema;
            schema.getRadiationAreas().remove(areaToRemove.getFirst());
            this.saveSchema((SaveSchema)schema, ((Number)areaToRemove.getSecond()).intValue());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getMaximumId() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            int maxId = 0;
            int page = 0;
            while (this.pageExists(page)) {
                int max;
                Object v0;
                RadiationAreaSchema schema = (RadiationAreaSchema)this.getSchema(page);
                if (schema == null) {
                    ++page;
                    continue;
                }
                Iterable $this$maxByOrNull$iv = schema.getRadiationAreas();
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        RadiationArea it = (RadiationArea)maxElem$iv;
                        boolean bl2 = false;
                        int maxValue$iv = it.getId();
                        do {
                            Object e$iv = iterator$iv.next();
                            RadiationArea it2 = (RadiationArea)e$iv;
                            $i$a$-maxByOrNull-RadiationAreaSave$getMaximumId$1$max$1 = false;
                            int v$iv = it2.getId();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                RadiationArea radiationArea = v0;
                int n = max = radiationArea != null ? radiationArea.getId() : 0;
                if (max > maxId) {
                    maxId = max;
                }
                ++page;
            }
            this.cachedMaxId.set(maxId);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private static final String _init_$lambda$0(RadiationAreaSave this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "-" + this$0.worldName;
    }

    public /* synthetic */ RadiationAreaSave(String worldName, DefaultConstructorMarker $constructor_marker) {
        this(worldName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mochibit/defcon/save/savedata/RadiationAreaSave$Companion;", "", "()V", "radiationAreaSaves", "", "", "Lcom/mochibit/defcon/save/savedata/RadiationAreaSave;", "getSave", "world", "Lorg/bukkit/World;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RadiationAreaSave getSave(@NotNull World world) {
            Intrinsics.checkNotNullParameter(world, "world");
            String string = world.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String worldName = string;
            if (radiationAreaSaves.containsKey(worldName)) {
                Object v = radiationAreaSaves.get(worldName);
                Intrinsics.checkNotNull(v);
                return (RadiationAreaSave)v;
            }
            RadiationAreaSave save = new RadiationAreaSave(worldName, null);
            radiationAreaSaves.put(worldName, save);
            return save;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

