/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.save;

import com.mochibit.defcon.save.savedata.SaveDataInfo;
import com.mochibit.defcon.save.schemas.SaveSchema;
import com.mochibit.defcon.save.strategy.JsonSaver;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0019J\r\u0010\u001a\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u001e\u001a\u00020\u001cJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u001b\u0010 \u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\t\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\tJ\u0014\u0010#\u001a\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%R\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/mochibit/defcon/save/AbstractSaveData;", "T", "Lcom/mochibit/defcon/save/schemas/SaveSchema;", "", "schema", "paginate", "", "(Lcom/mochibit/defcon/save/schemas/SaveSchema;Z)V", "currentPage", "", "getCurrentPage", "()Ljava/lang/Integer;", "setCurrentPage", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "saveDataInfo", "Lcom/mochibit/defcon/save/savedata/SaveDataInfo;", "saveStrategy", "Lcom/mochibit/defcon/save/strategy/JsonSaver;", "getSchema", "()Lcom/mochibit/defcon/save/schemas/SaveSchema;", "setSchema", "(Lcom/mochibit/defcon/save/schemas/SaveSchema;)V", "Lcom/mochibit/defcon/save/schemas/SaveSchema;", "page", "(Ljava/lang/Integer;)Lcom/mochibit/defcon/save/schemas/SaveSchema;", "load", "nextPage", "", "pageExists", "previousPage", "save", "saveSchema", "(Lcom/mochibit/defcon/save/schemas/SaveSchema;I)V", "setPage", "setSuffixSupplier", "propertySupplier", "Ljava/util/function/Supplier;", "", "Defcon"})
public abstract class AbstractSaveData<T extends SaveSchema> {
    @NotNull
    private T schema;
    @NotNull
    private final SaveDataInfo saveDataInfo;
    @Nullable
    private Integer currentPage;
    @NotNull
    private JsonSaver<T> saveStrategy;

    public AbstractSaveData(@NotNull T schema, boolean paginate) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        this.schema = schema;
        SaveDataInfo saveDataInfo = this.getClass().getAnnotation(SaveDataInfo.class);
        if (saveDataInfo == null) {
            throw new IllegalStateException("SaveDataInfo annotation not found");
        }
        this.saveDataInfo = saveDataInfo;
        this.currentPage = paginate ? Integer.valueOf(0) : null;
        this.saveStrategy = new JsonSaver(this.saveDataInfo, Reflection.getOrCreateKotlinClass(this.schema.getClass()));
    }

    public /* synthetic */ AbstractSaveData(SaveSchema saveSchema, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(saveSchema, bl);
    }

    @NotNull
    public final T getSchema() {
        return this.schema;
    }

    public final void setSchema(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, "<set-?>");
        this.schema = t;
    }

    @Nullable
    protected final Integer getCurrentPage() {
        return this.currentPage;
    }

    protected final void setCurrentPage(@Nullable Integer n) {
        this.currentPage = n;
    }

    public final void setSuffixSupplier(@NotNull Supplier<String> propertySupplier) {
        Intrinsics.checkNotNullParameter(propertySupplier, "propertySupplier");
        this.saveStrategy.setFileNameSuffix(propertySupplier);
    }

    public final void save() {
        Integer n = this.currentPage;
        this.saveSchema(this.schema, n != null ? n : 0);
    }

    @Nullable
    public final T load() {
        T t = this.getSchema(this.currentPage);
        if (t == null) {
            return null;
        }
        this.schema = t;
        return this.schema;
    }

    public final void saveSchema(@NotNull T schema, int page) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        this.saveStrategy.save(schema, page);
    }

    @Nullable
    public final T getSchema(@Nullable Integer page) {
        return this.saveStrategy.load(page);
    }

    public final void nextPage() {
        Integer n = this.currentPage;
        this.currentPage = n != null ? Integer.valueOf(n + 1) : Integer.valueOf(1);
    }

    public final void setPage(int page) {
        this.currentPage = page;
    }

    public final void previousPage() {
        if (this.currentPage == null) {
            return;
        }
        Integer n = this.currentPage;
        if (n != null && n == 0) {
            return;
        }
        Integer n2 = this.currentPage;
        this.currentPage = n2 != null ? Integer.valueOf(n2 - 1) : Integer.valueOf(0);
    }

    public final boolean pageExists(int page) {
        return this.saveStrategy.pageExists(page);
    }
}

