/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.registers;

import com.mochibit.defcon.Defcon;
import com.mochibit.defcon.api.customblockdata.CustomBlockData;
import com.mochibit.defcon.classes.PluginConfiguration;
import com.mochibit.defcon.classes.StructureBlock;
import com.mochibit.defcon.classes.structures.StructureQuery;
import com.mochibit.defcon.enums.BlockDataKey;
import com.mochibit.defcon.enums.ConfigurationStorages;
import com.mochibit.defcon.enums.StructureBehaviour;
import com.mochibit.defcon.exceptions.BlockNotRegisteredException;
import com.mochibit.defcon.extensions.ByteKt;
import com.mochibit.defcon.interfaces.PluginBlock;
import com.mochibit.defcon.interfaces.StructureDefinition;
import com.mochibit.defcon.registers.BlockRegister;
import com.mochibit.defcon.registers.StructureRegister;
import com.mochibit.defcon.utils.FloodFill3D;
import com.mochibit.defcon.utils.Geometry;
import com.mochibit.defcon.utils.MetaManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/mochibit/defcon/registers/StructureRegister;", "", "()V", "pluginInstance", "Lorg/bukkit/plugin/java/JavaPlugin;", "registerStructures", "", "searchByBlock", "Lcom/mochibit/defcon/classes/structures/StructureQuery;", "location", "Lorg/bukkit/Location;", "Companion", "Defcon"})
@SourceDebugExtension(value={"SMAP\nStructureRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureRegister.kt\ncom/mochibit/defcon/registers/StructureRegister\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 MetaManager.kt\ncom/mochibit/defcon/utils/MetaManager\n*L\n1#1,248:1\n1855#2:249\n731#2,9:250\n731#2,9:261\n1856#2:272\n1045#2:286\n2310#2,14:287\n2310#2,14:301\n2310#2,14:315\n37#3,2:259\n37#3,2:270\n38#4,13:273\n*S KotlinDebug\n*F\n+ 1 StructureRegister.kt\ncom/mochibit/defcon/registers/StructureRegister\n*L\n60#1:249\n82#1:250,9\n106#1:261,9\n60#1:272\n172#1:286\n175#1:287,14\n176#1:301,14\n177#1:315,14\n82#1:259,2\n106#1:270,2\n155#1:273,13\n*E\n"})
public final class StructureRegister {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private JavaPlugin pluginInstance = JavaPlugin.getPlugin(Defcon.class);
    @NotNull
    private static HashMap<String, StructureDefinition> registeredStructures = new HashMap();

    /*
     * WARNING - void declaration
     */
    public final void registerStructures() {
        HashMap<String, PluginBlock> hashMap;
        registeredStructures = new HashMap();
        PluginConfiguration structureConfiguration = new PluginConfiguration(this.pluginInstance, ConfigurationStorages.Structures);
        FileConfiguration structureConfig = structureConfiguration.getConfig();
        try {
            hashMap = BlockRegister.Companion.getRegisteredBlocks();
        }
        catch (BlockNotRegisteredException e) {
            throw new RuntimeException("Unable to register structures, blocks not registered");
        }
        HashMap<String, PluginBlock> registeredBlocks = hashMap;
        FileConfiguration fileConfiguration = structureConfig;
        Intrinsics.checkNotNull(fileConfiguration);
        List list = fileConfiguration.getList("enabled-structures");
        Intrinsics.checkNotNull(list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            List interfaceBlockNames;
            List blockDispositions;
            String thisCollection$iv;
            Object rawDefinition2;
            List rawDefinitions;
            String string;
            Object element$iv;
            Object item = element$iv = iterator2.next();
            boolean bl = false;
            StructureDefinition structure = null;
            if (structureConfig.getString(item + ".behaviour") == null) continue;
            Intrinsics.checkNotNull(string);
            String behaviour = string;
            boolean requiresInterface = structureConfig.getBoolean(item + ".requires-interface");
            StructureBehaviour structureBehaviour = StructureBehaviour.Companion.fromString(behaviour);
            try {
                if (structureBehaviour != null) {
                    GenericDeclaration genericDeclaration = structureBehaviour.getStructureClass();
                    structure = genericDeclaration != null && (genericDeclaration = ((Class)genericDeclaration).getDeclaredConstructor(new Class[0])) != null ? (StructureDefinition)((Constructor)genericDeclaration).newInstance(new Object[0]) : null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (structure == null) continue;
            Intrinsics.checkNotNullExpressionValue(structureConfig.getStringList(item + ".block-set"), "getStringList(...)");
            HashMap customBlockDefinitions = new HashMap();
            for (Object rawDefinition2 : rawDefinitions) {
                void $this$toTypedArray$iv;
                List list2;
                Collection $this$dropLastWhile$iv;
                Intrinsics.checkNotNull(rawDefinition2);
                Object object = (CharSequence)rawDefinition2;
                Regex regex = new Regex(":");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list2 = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list2;
                boolean $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] definition = thisCollection$iv.toArray((String[])new String[0]);
                ((Map)customBlockDefinitions).put(definition[0], definition[1]);
            }
            Intrinsics.checkNotNull(structureConfig.getList(item + ".block-dispositions"));
            rawDefinition2 = blockDispositions.iterator();
            while (rawDefinition2.hasNext()) {
                Object blockDisposition = rawDefinition2.next();
                Intrinsics.checkNotNull(blockDisposition, "null cannot be cast to non-null type java.util.LinkedHashMap<*, *>{ kotlin.collections.TypeAliasesKt.LinkedHashMap<*, *> }");
                LinkedHashMap blockDispositionDef = (LinkedHashMap)blockDisposition;
                Set set = blockDispositionDef.keySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                String string2 = thisCollection$iv = CollectionsKt.first(set);
                if (string2 == null) continue;
                Intrinsics.checkNotNull(string2);
                String set2 = thisCollection$iv;
                Object v = ((Map)blockDispositionDef).get(set2);
                Intrinsics.checkNotNull(v, "null cannot be cast to non-null type java.util.LinkedHashMap<*, *>{ kotlin.collections.TypeAliasesKt.LinkedHashMap<*, *> }");
                LinkedHashMap effectiveBlockDisposition = (LinkedHashMap)v;
                Object v2 = ((Map)effectiveBlockDisposition).get("y");
                Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type kotlin.Int");
                int y = (Integer)v2;
                Object v3 = ((Map)effectiveBlockDisposition).get("dispositions");
                Intrinsics.checkNotNull(v3, "null cannot be cast to non-null type kotlin.collections.List<*>");
                List dispositions = (List)v3;
                int n = dispositions.size();
                for (int z = 0; z < n; ++z) {
                    void $this$toTypedArray$iv;
                    List list3;
                    Collection $this$dropLastWhile$iv;
                    Object object = String.valueOf(dispositions.get(z));
                    Regex regex = new Regex(",");
                    int n2 = 0;
                    object = regex.split((CharSequence)object, n2);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl3 = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list3 = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                            break;
                        }
                    } else {
                        list3 = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list3;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv2 = $this$toTypedArray$iv;
                    String[] dispositionBlocks = thisCollection$iv2.toArray(new String[0]);
                    int n3 = dispositionBlocks.length;
                    for (int x = 0; x < n3; ++x) {
                        String blockName = dispositionBlocks[x];
                        if (!customBlockDefinitions.containsKey(blockName)) {
                            throw new RuntimeException("Unable to register structure, block variable " + blockName + " is unknown");
                        }
                        String blockId = (String)customBlockDefinitions.get(blockName);
                        HashMap<String, PluginBlock> hashMap2 = registeredBlocks;
                        if (hashMap2 == null || (hashMap2 = hashMap2.get(blockId)) == null) {
                            throw new RuntimeException("Unable to register structure, block " + blockId + " is unknown");
                        }
                        HashMap<String, PluginBlock> block = hashMap2;
                        structure.getStructureBlocks().add(new StructureBlock((PluginBlock)((Object)block), x, y, z, false, 16, null));
                    }
                }
            }
            Intrinsics.checkNotNullExpressionValue(structureConfig.getStringList(item + ".interface-blocks"), "getStringList(...)");
            for (String interfaceBlockName : interfaceBlockNames) {
                if (!customBlockDefinitions.containsKey(interfaceBlockName)) {
                    throw new RuntimeException("Unable to register structure, block variable " + interfaceBlockName + " is unknown");
                }
                String blockId = (String)customBlockDefinitions.get(interfaceBlockName);
                for (StructureBlock structureBlock : structure.getStructureBlocks()) {
                    if (!Intrinsics.areEqual(structureBlock.getBlock().getId(), blockId)) continue;
                    structureBlock.setInterface(true);
                }
            }
            Function1[] function1Array = new Function1[]{registerStructures.1.1.INSTANCE, registerStructures.1.2.INSTANCE, registerStructures.1.3.INSTANCE};
            structure.setStructureBlocks(CollectionsKt.toMutableList(CollectionsKt.sortedWith((Iterable)structure.getStructureBlocks(), ComparisonsKt.compareBy(function1Array))));
            structure.setRequiredInterface(requiresInterface);
            structure.setId(String.valueOf(item));
            JavaPlugin javaPlugin = this.pluginInstance;
            Intrinsics.checkNotNull(javaPlugin);
            javaPlugin.getLogger().info("Registered structure " + structure + ".id");
            ((Map)registeredStructures).put(String.valueOf(item), structure);
        }
        structureConfiguration.saveConfig();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StructureQuery searchByBlock(@NotNull Location location) {
        Object t;
        Object t2;
        Object t3;
        StructureDefinition foundStructure;
        String foundStructureId;
        void this_$iv;
        Intrinsics.checkNotNullParameter(location, "location");
        List foundStructures = TypeIntrinsics.asMutableList(new ArrayList());
        MetaManager metaManager = MetaManager.INSTANCE;
        BlockDataKey key$iv = BlockDataKey.StructureId;
        boolean $i$f$getBlockData = false;
        Block block = location.getWorld().getBlockAt(location);
        Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
        Block block$iv = block;
        PersistentDataContainer blockData$iv = new CustomBlockData(block$iv, (Plugin)Defcon.Companion.getInstance());
        PersistentDataType<?, ?> dataType$iv = this_$iv.getPersistentDataType(Reflection.getOrCreateKotlinClass(String.class));
        Object object = blockData$iv.get(key$iv.getKey(), dataType$iv);
        if (object == null) {
            v2 = null;
        } else {
            Object value$iv = object;
            if (String.class == Boolean.class) {
                Intrinsics.checkNotNull(value$iv, "null cannot be cast to non-null type kotlin.Byte");
                v2 = (String)((Object)Boolean.valueOf(ByteKt.toBoolean((Byte)value$iv)));
            } else {
                Object object2 = value$iv;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                v2 = foundStructureId = (String)object2;
            }
        }
        if (foundStructureId != null && (foundStructure = registeredStructures.get(foundStructureId)) != null) {
            foundStructures.add(foundStructure);
            List<Location> list = Collections.singletonList(location);
            Intrinsics.checkNotNullExpressionValue(list, "singletonList(...)");
            return new StructureQuery(foundStructures, list);
        }
        List<Location> pluginBlockLocations = FloodFill3D.getFloodFill$default(FloodFill3D.INSTANCE, location, 200, false, true, 4, null);
        if (pluginBlockLocations.isEmpty()) {
            return new StructureQuery(foundStructures, (List<? extends Location>)pluginBlockLocations);
        }
        Iterable $this$sortedBy$iv = pluginBlockLocations;
        boolean $i$f$sortedBy = false;
        pluginBlockLocations = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Location it = (Location)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getY());
                it = (Location)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getY());
            }
        });
        Iterable $this$minBy$iv = pluginBlockLocations;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t3 = minElem$iv;
        } else {
            Location it = (Location)minElem$iv;
            boolean bl = false;
            double minValue$iv = it.getX();
            do {
                Object e$iv = iterator$iv.next();
                Location it2 = (Location)e$iv;
                boolean bl2 = false;
                double v$iv = it2.getX();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t3 = minElem$iv;
        }
        Location minX = (Location)t3;
        Iterable $this$minBy$iv2 = pluginBlockLocations;
        boolean $i$f$minByOrThrow2 = false;
        Iterator iterator$iv2 = $this$minBy$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv2 = iterator$iv2.next();
        if (!iterator$iv2.hasNext()) {
            t2 = minElem$iv2;
        } else {
            Location it = (Location)minElem$iv2;
            boolean bl = false;
            double minValue$iv = it.getY();
            do {
                Object e$iv = iterator$iv2.next();
                Location it3 = (Location)e$iv;
                boolean bl3 = false;
                double v$iv = it3.getY();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv2 = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv2.hasNext());
            t2 = minElem$iv2;
        }
        Location minY = (Location)t2;
        Iterable $this$minBy$iv3 = pluginBlockLocations;
        boolean $i$f$minByOrThrow3 = false;
        Iterator iterator$iv3 = $this$minBy$iv3.iterator();
        if (!iterator$iv3.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv3 = iterator$iv3.next();
        if (!iterator$iv3.hasNext()) {
            t = minElem$iv3;
        } else {
            Location it = (Location)minElem$iv3;
            boolean bl = false;
            double minValue$iv = it.getZ();
            do {
                Object e$iv = iterator$iv3.next();
                Location it4 = (Location)e$iv;
                boolean bl4 = false;
                double v$iv = it4.getZ();
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv3 = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv3.hasNext());
            t = minElem$iv3;
        }
        Location minZ = (Location)t;
        List relativeStructureBlocks = new ArrayList();
        for (Location pluginBlockLocation : pluginBlockLocations) {
            PluginBlock pluginBlock;
            if (BlockRegister.Companion.getBlock(pluginBlockLocation) == null) continue;
            double relativeX = pluginBlockLocation.getX() - minX.getX();
            double relativeY = pluginBlockLocation.getY() - minY.getY();
            double relativeZ = pluginBlockLocation.getZ() - minZ.getZ();
            StructureBlock structureBlock = new StructureBlock(pluginBlock, (int)relativeX, (int)relativeY, (int)relativeZ, false, 16, null);
            relativeStructureBlocks.add(structureBlock);
        }
        if (relativeStructureBlocks.isEmpty()) {
            return new StructureQuery(foundStructures, pluginBlockLocations);
        }
        Function1[] function1Array = new Function1[]{searchByBlock.2.INSTANCE, searchByBlock.3.INSTANCE, searchByBlock.4.INSTANCE};
        relativeStructureBlocks = CollectionsKt.toMutableList(CollectionsKt.sortedWith(relativeStructureBlocks, ComparisonsKt.compareBy(function1Array)));
        block4: for (StructureDefinition registeredStructure : registeredStructures.values()) {
            if (registeredStructure.getStructureBlocks().size() != relativeStructureBlocks.size()) continue;
            List<StructureBlock> regBlocks = registeredStructure.getStructureBlocks();
            for (int rotations = 0; rotations < 3; ++rotations) {
                boolean isSame = true;
                int n = regBlocks.size();
                for (int i = 0; i < n; ++i) {
                    StructureBlock registeredStructureBlock = regBlocks.get(i);
                    StructureBlock relativeStructureBlock = (StructureBlock)relativeStructureBlocks.get(i);
                    if (!Intrinsics.areEqual(registeredStructureBlock.getBlock().getId(), relativeStructureBlock.getBlock().getId())) {
                        isSame = false;
                        break;
                    }
                    if (registeredStructureBlock.getX() != relativeStructureBlock.getX()) {
                        isSame = false;
                        break;
                    }
                    if (registeredStructureBlock.getY() != relativeStructureBlock.getY()) {
                        isSame = false;
                        break;
                    }
                    if (registeredStructureBlock.getZ() == relativeStructureBlock.getZ()) continue;
                    isSame = false;
                    break;
                }
                if (isSame) {
                    Intrinsics.checkNotNull(registeredStructure);
                    foundStructures.add(registeredStructure);
                    continue block4;
                }
                relativeStructureBlocks = Geometry.rotateStructureBlockPlaneXZ$default(Geometry.INSTANCE, relativeStructureBlocks, 0.0f, 2, null);
            }
        }
        return new StructureQuery(foundStructures, pluginBlockLocations);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/mochibit/defcon/registers/StructureRegister$Companion;", "", "()V", "registeredStructures", "Ljava/util/HashMap;", "", "Lcom/mochibit/defcon/interfaces/StructureDefinition;", "Lkotlin/collections/HashMap;", "Defcon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

