/*
 * Decompiled with CFR 0.152.
 */
package com.mochibit.defcon.registers;

import com.mochibit.defcon.Defcon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"copyFoldersFromResource", "", "resourceFolderPath", "", "targetPath", "Ljava/nio/file/Path;", "excludedPaths", "Ljava/util/HashSet;", "zipFile", "fileToZip", "Ljava/io/File;", "fileName", "zipOut", "Ljava/util/zip/ZipOutputStream;", "zipFolder", "folderPath", "zipPath", "zipFolderPathContent", "", "Defcon"})
@SourceDebugExtension(value={"SMAP\nResourcePackRegister.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcePackRegister.kt\ncom/mochibit/defcon/registers/ResourcePackRegisterKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,366:1\n1#2:367\n*E\n"})
public final class ResourcePackRegisterKt {
    public static final void zipFolder(@NotNull Path folderPath, @NotNull Path zipPath, boolean zipFolderPathContent) {
        Intrinsics.checkNotNullParameter(folderPath, "folderPath");
        Intrinsics.checkNotNullParameter(zipPath, "zipPath");
        FileOutputStream fos = new FileOutputStream(((Object)zipPath).toString());
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        File fileToZip = folderPath.toFile();
        if (fileToZip.isDirectory()) {
            if (zipFolderPathContent) {
                File[] children = fileToZip.listFiles();
                Intrinsics.checkNotNull(children);
                for (File childFile : children) {
                    Intrinsics.checkNotNull(childFile);
                    String string = childFile.getName();
                    Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                    ResourcePackRegisterKt.zipFile(childFile, string, zipOut);
                }
            } else {
                Intrinsics.checkNotNull(fileToZip);
                String string = fileToZip.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                ResourcePackRegisterKt.zipFile(fileToZip, string, zipOut);
            }
        } else {
            Intrinsics.checkNotNull(fileToZip);
            String string = fileToZip.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            ResourcePackRegisterKt.zipFile(fileToZip, string, zipOut);
        }
        zipOut.close();
        fos.close();
    }

    public static /* synthetic */ void zipFolder$default(Path path, Path path2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        ResourcePackRegisterKt.zipFolder(path, path2, bl);
    }

    private static final void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            if (StringsKt.endsWith$default(fileName, "/", false, 2, null)) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            File[] children = fileToZip.listFiles();
            Intrinsics.checkNotNull(children);
            for (File childFile : children) {
                Intrinsics.checkNotNull(childFile);
                ResourcePackRegisterKt.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        int length = 0;
        while (true) {
            int n;
            int it = n = fis.read(bytes);
            boolean bl = false;
            length = it;
            if (n < 0) break;
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public static final void copyFoldersFromResource(@NotNull String resourceFolderPath, @NotNull Path targetPath, @NotNull HashSet<String> excludedPaths) {
        Intrinsics.checkNotNullParameter(resourceFolderPath, "resourceFolderPath");
        Intrinsics.checkNotNullParameter(targetPath, "targetPath");
        Intrinsics.checkNotNullParameter(excludedPaths, "excludedPaths");
        File jarFile = new File(Defcon.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        block0: while (entries.hasMoreElements()) {
            String initialPath;
            String excludedPath2;
            JarEntry entry = entries.nextElement();
            for (String excludedPath2 : excludedPaths) {
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                Intrinsics.checkNotNull(excludedPath2);
                if (!StringsKt.startsWith$default(string, excludedPath2, false, 2, null)) continue;
                continue block0;
            }
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (!StringsKt.startsWith$default(string, resourceFolderPath, false, 2, null)) continue;
            Intrinsics.checkNotNullExpressionValue(entry.getName(), "getName(...)");
            int n = resourceFolderPath.length();
            Intrinsics.checkNotNullExpressionValue(excludedPath2.substring(n), "substring(...)");
            Path target = targetPath.resolve(initialPath);
            if (entry.isDirectory()) {
                Defcon.Companion.Logger.INSTANCE.info("Creating directory " + target);
                Files.createDirectories(target, new FileAttribute[0]);
                continue;
            }
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(jar.getInputStream(entry), target, copyOptionArray);
        }
    }

    public static /* synthetic */ void copyFoldersFromResource$default(String string, Path path, HashSet hashSet, int n, Object object) {
        if ((n & 4) != 0) {
            hashSet = new HashSet<String>();
        }
        ResourcePackRegisterKt.copyFoldersFromResource(string, path, hashSet);
    }
}

